/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.shell;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.qa.security.P11KeyGenSpeed;
import org.xipki.qa.security.P11SignSpeed;
import org.xipki.qa.security.P12KeyGenSpeed;
import org.xipki.qa.security.P12SignSpeed;
import org.xipki.qa.shell.QaCompleters;
import org.xipki.security.EdECConstants;
import org.xipki.security.SecurityFactory;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.Args;
import org.xipki.util.BenchmarkExecutor;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class QaSecurityActions {
    private static ASN1ObjectIdentifier getCurveOid(String curveName) {
        ASN1ObjectIdentifier curveOid = EdECConstants.getCurveOid((String)curveName);
        if (curveOid == null) {
            curveOid = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)curveName);
        }
        if (curveOid == null) {
            throw new IllegalArgumentException("unknown curveName " + curveName);
        }
        return curveOid;
    }

    @Command(scope="xi", name="speed-sm2-sign-p12", description="performance test of PKCS#12 SM2 signature creation")
    @Service
    public static class SpeedSm2SignP12
    extends SpeedP12SignAction {
        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12SignSpeed.SM2(this.securityFactory, this.getNumThreads());
        }
    }

    @Command(scope="xi", name="speed-sm2-gen-p12", description="performance test of PKCS#12 SM2 key generation")
    @Service
    public static class SpeedSm2GenP12
    extends SingleSpeedAction {
        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12KeyGenSpeed.EC(GMObjectIdentifiers.sm2p256v1, this.securityFactory);
        }
    }

    public static abstract class SpeedP12SignAction
    extends SingleSpeedAction {
    }

    @Command(scope="xi", name="speed-rsa-sign-p12", description="performance test of PKCS#12 RSA signature creation")
    @Service
    public static class SpeedRsaSignP12
    extends SpeedP12SignAction {
        @Option(name="--key-size", description="keysize in bit")
        private Integer keysize = 2048;
        @Option(name="-e", description="public exponent")
        private String publicExponent = "0x10001";
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.RSASigAlgCompleter.class)
        private String sigAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12SignSpeed.RSA(this.securityFactory, this.sigAlgo, this.getNumThreads(), this.keysize.intValue(), SpeedRsaSignP12.toBigInt((String)this.publicExponent));
        }
    }

    @Command(scope="xi", name="speed-rsa-gen-p12", description="performance test of PKCS#12 RSA key generation")
    @Service
    public static class SpeedRsaGenP12
    extends SingleSpeedAction {
        @Option(name="--key-size", description="keysize in bit")
        private Integer keysize = 2048;
        @Option(name="-e", description="public exponent")
        private String publicExponent = "0x10001";

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12KeyGenSpeed.RSA(this.keysize.intValue(), SpeedRsaGenP12.toBigInt((String)this.publicExponent), this.securityFactory);
        }
    }

    @Command(scope="xi", name="speed-hmac-sign-p12", description="performance test of PKCS#12 HMAC signature creation")
    @Service
    public static class SpeedHmacSignP12
    extends SpeedP12SignAction {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.HMACSigAlgCompleter.class)
        private String sigAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12SignSpeed.HMAC(this.securityFactory, this.sigAlgo, this.getNumThreads());
        }
    }

    @Command(scope="xi", name="speed-ed-sign-p12", description="performance test of PKCS#12 EdDSA signature creation")
    @Service
    public static class SpeedEdSignP12
    extends SpeedP12SignAction {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.EDDSASigAlgCompleter.class)
        private String sigAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            ASN1ObjectIdentifier curveOid = EdECConstants.getCurveOid((String)this.sigAlgo);
            return new P12SignSpeed.EC(this.securityFactory, this.sigAlgo, this.getNumThreads(), curveOid);
        }
    }

    @Command(scope="xi", name="speed-ed-gen-p12", description="performance test of PKCS#12 Edwards and montgomery EC key generation")
    @Service
    public static class SpeedEdGenP12
    extends SingleSpeedAction {
        @Option(name="--curve", required=true, description="curve name")
        @Completion(value=Completers.EdCurveNameCompleter.class)
        private String curveName;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12KeyGenSpeed.EC(QaSecurityActions.getCurveOid(this.curveName), this.securityFactory);
        }
    }

    @Command(scope="xi", name="speed-ec-sign-p12", description="performance test of PKCS#12 EC signature creation")
    @Service
    public static class SpeedEcSignP12
    extends SpeedP12SignAction {
        @Option(name="--curve", required=true, description="EC curve name")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName;
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.ECDSASigAlgCompleter.class)
        private String sigAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12SignSpeed.EC(this.securityFactory, this.sigAlgo, this.getNumThreads(), QaSecurityActions.getCurveOid(this.curveName));
        }
    }

    @Command(scope="xi", name="speed-ec-gen-p12", description="performance test of PKCS#12 EC key generation")
    @Service
    public static class SpeedEcGenP12
    extends SingleSpeedAction {
        @Option(name="--curve", required=true, description="EC curve name")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12KeyGenSpeed.EC(QaSecurityActions.getCurveOid(this.curveName), this.securityFactory);
        }
    }

    @Command(scope="xi", name="speed-dsa-sign-p12", description="performance test of PKCS#12 DSA signature creation")
    @Service
    public static class SpeedDsaSignP12
    extends SpeedP12SignAction {
        @Option(name="--plen", description="bit length of the prime")
        private Integer plen = 2048;
        @Option(name="--qlen", description="bit length of the sub-prime")
        private Integer qlen;
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.DSASigAlgCompleter.class)
        private String sigAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            if (this.qlen == null) {
                this.qlen = this.plen >= 2048 ? 256 : 160;
            }
            return new P12SignSpeed.DSA(this.securityFactory, this.sigAlgo, this.getNumThreads(), this.plen.intValue(), this.qlen.intValue());
        }
    }

    @Command(scope="xi", name="speed-dsa-gen-p12", description="performance test of PKCS#12 DSA key generation")
    @Service
    public static class SpeedDsaGenP12
    extends SingleSpeedAction {
        @Option(name="--plen", description="bit length of the prime")
        private Integer plen = 2048;
        @Option(name="--qlen", description="bit length of the sub-prime")
        private Integer qlen;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            if (this.qlen == null) {
                this.qlen = this.plen >= 2048 ? 256 : 160;
            }
            return new P12KeyGenSpeed.DSA(this.plen.intValue(), this.qlen.intValue(), this.securityFactory);
        }
    }

    @Command(scope="xi", name="speed-gmac-sign-p12", description="performance test of PKCS#12 AES GMAC signature creation")
    @Service
    public static class SpeedP12AESGmacSignAction
    extends SpeedP12SignAction {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.GMACSigAlgCompleter.class)
        private String sigAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12SignSpeed.AESGmac(this.securityFactory, this.sigAlgo, this.getNumThreads());
        }
    }

    public static abstract class BSpeedP12SignAction
    extends BatchSpeedAction {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        protected String sigAlgo;
    }

    @Command(scope="xi", name="bspeed-rsa-sign-p12", description="performance test of PKCS#12 RSA signature creation (batch)")
    @Service
    public static class BspeedRsaSignP12
    extends BSpeedP12SignAction {
        private final Queue<KeyControl.RSA> queue = new LinkedList<KeyControl.RSA>();

        public BspeedRsaSignP12() {
            this.queue.add(new KeyControl.RSA(1024));
            this.queue.add(new KeyControl.RSA(2048));
            this.queue.add(new KeyControl.RSA(3072));
            this.queue.add(new KeyControl.RSA(4096));
        }

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.RSA control = this.queue.poll();
            return control == null ? null : new P12SignSpeed.RSA(this.securityFactory, this.sigAlgo, this.getNumThreads(), control.modulusLen(), BspeedRsaSignP12.toBigInt((String)"0x10001"));
        }
    }

    @Command(scope="xi", name="bspeed-rsa-gen-p12", description="performance test of PKCS#12 RSA key generation (batch)")
    @Service
    public static class BspeedRsaGenP12
    extends BatchSpeedAction {
        private final Queue<KeyControl.RSA> queue = new LinkedList<KeyControl.RSA>();

        public BspeedRsaGenP12() {
            this.queue.add(new KeyControl.RSA(1024));
            this.queue.add(new KeyControl.RSA(2048));
            this.queue.add(new KeyControl.RSA(3072));
            this.queue.add(new KeyControl.RSA(4096));
        }

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.RSA control = this.queue.poll();
            return control == null ? null : new P12KeyGenSpeed.RSA(control.modulusLen(), BspeedRsaGenP12.toBigInt((String)"0x10001"), this.securityFactory);
        }
    }

    @Command(scope="xi", name="bspeed-ec-sign-p12", description="performance test of PKCS#12 EC signature creation (batch)")
    @Service
    public static class BspeedEcSignP12
    extends BSpeedP12SignAction {
        private final Queue<KeyControl.EC> queue = new LinkedList<KeyControl.EC>();

        public BspeedEcSignP12() {
            for (String curveName : this.getECCurveNames()) {
                this.queue.add(new KeyControl.EC(curveName));
            }
        }

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.EC control = this.queue.poll();
            return control == null ? null : new P12SignSpeed.EC(this.securityFactory, this.sigAlgo, this.getNumThreads(), QaSecurityActions.getCurveOid(control.curveName()));
        }
    }

    @Command(scope="xi", name="bspeed-ec-gen-p12", description="performance test of PKCS#12 EC key generation (batch)")
    @Service
    public static class BspeedEcGenP12
    extends BatchSpeedAction {
        private final Queue<KeyControl.EC> queue = new LinkedList<KeyControl.EC>();

        public BspeedEcGenP12() {
            for (String curveName : this.getECCurveNames()) {
                this.queue.add(new KeyControl.EC(curveName));
            }
        }

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.EC control = this.queue.poll();
            ASN1ObjectIdentifier curveOid = QaSecurityActions.getCurveOid(control.curveName());
            return control == null ? null : new P12KeyGenSpeed.EC(curveOid, this.securityFactory);
        }
    }

    @Command(scope="xi", name="bspeed-dsa-sign-p12", description="performance test of PKCS#12 DSA signature creation")
    @Service
    public static class BspeedDsaSignP12
    extends BSpeedP12SignAction {
        private final Queue<KeyControl.DSA> queue = new LinkedList<KeyControl.DSA>();

        public BspeedDsaSignP12() {
            this.queue.add(new KeyControl.DSA(1024, 160));
            this.queue.add(new KeyControl.DSA(2048, 224));
            this.queue.add(new KeyControl.DSA(2048, 256));
            this.queue.add(new KeyControl.DSA(3072, 256));
        }

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.DSA control = this.queue.poll();
            if (control == null) {
                return null;
            }
            if (control.plen() == 1024) {
                this.sigAlgo = "SHA1withDSA";
            }
            return new P12SignSpeed.DSA(this.securityFactory, this.sigAlgo, this.getNumThreads(), control.plen(), control.qlen());
        }
    }

    @Command(scope="xi", name="bspeed-dsa-gen-p12", description="performance test of PKCS#12 DSA key generation (batch)")
    @Service
    public static class BspeedDsaGenP12
    extends BatchSpeedAction {
        private final Queue<KeyControl.DSA> queue = new LinkedList<KeyControl.DSA>();

        public BspeedDsaGenP12() {
            this.queue.add(new KeyControl.DSA(1024, 160));
            this.queue.add(new KeyControl.DSA(2048, 224));
            this.queue.add(new KeyControl.DSA(2048, 256));
            this.queue.add(new KeyControl.DSA(3072, 256));
        }

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.DSA control = this.queue.poll();
            return control == null ? null : new P12KeyGenSpeed.DSA(control.plen(), control.qlen(), this.securityFactory);
        }
    }

    @Command(scope="xi", name="speed-sm2-sign-p11", description="performance test of PKCS#11 SM2 signature creation")
    @Service
    public static class SpeedSm2SignP11
    extends SpeedP11SignAction {
        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11SignSpeed.SM2(this.keyPresent.booleanValue(), this.securityFactory, this.getSlot(), this.getKeyId(), this.keyLabel, this.getNumThreads());
        }
    }

    @Command(scope="xi", name="speed-sm2-gen-p11", description="performance test of PKCS#11 SM2 key generation")
    @Service
    public static class SpeedSm2GenP11
    extends SpeedP11Action {
        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11KeyGenSpeed.SM2(this.getSlot(), this.getKeyId());
        }

        @Override
        protected int getNumThreads() {
            return this.getKeyId() == null ? super.getNumThreads() : 1;
        }
    }

    public static abstract class SpeedP11SignAction
    extends SpeedP11Action {
        @Option(name="--key-present", description="the PKCS#11 key is present")
        protected Boolean keyPresent = Boolean.FALSE;
        @Option(name="--key-label", description="label of the PKCS#11 key")
        protected String keyLabel;
    }

    @Command(scope="xi", name="speed-rsa-sign-p11", description="performance test of PKCS#11 RSA signature creation")
    @Service
    public static class SpeedRsaSignP11
    extends SpeedP11SignAction {
        @Option(name="--key-size", description="keysize in bit")
        private Integer keysize = 2048;
        @Option(name="-e", description="public exponent")
        private String publicExponent = "0x10001";
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.RSASigAlgCompleter.class)
        private String sigAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11SignSpeed.RSA(this.keyPresent.booleanValue(), this.securityFactory, this.getSlot(), this.getKeyId(), this.keyLabel, this.sigAlgo, this.getNumThreads(), this.keysize.intValue(), SpeedRsaSignP11.toBigInt((String)this.publicExponent));
        }
    }

    @Command(scope="xi", name="speed-rsa-gen-p11", description="performance test of PKCS#11 RSA key generation")
    @Service
    public static class SpeedRsaGenP11
    extends SpeedP11Action {
        @Option(name="--key-size", description="keysize in bit")
        private Integer keysize = 2048;
        @Option(name="--exponent", aliases={"-e"}, description="public exponent")
        private String publicExponent = "0x10001";

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11KeyGenSpeed.RSA(this.getSlot(), this.getKeyId(), this.keysize.intValue(), SpeedRsaGenP11.toBigInt((String)this.publicExponent));
        }

        @Override
        protected int getNumThreads() {
            return this.getKeyId() == null ? super.getNumThreads() : 1;
        }
    }

    @Command(scope="xi", name="speed-hmac-sign-p11", description="performance test of PKCS#11 HMAC signature creation")
    @Service
    public static class SpeedHmacSignP11
    extends SpeedP11SignAction {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.HMACSigAlgCompleter.class)
        private String sigAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11SignSpeed.HMAC(this.keyPresent.booleanValue(), this.securityFactory, this.getSlot(), this.getKeyId(), this.keyLabel, this.sigAlgo, this.getNumThreads());
        }
    }

    @Command(scope="xi", name="speed-ed-sign-p11", description="performance test of PKCS#11 EdDSA signature creation")
    @Service
    public static class SpeedEdSignP11
    extends SpeedP11SignAction {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.EDDSASigAlgCompleter.class)
        private String sigAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            ASN1ObjectIdentifier curveOid = EdECConstants.getCurveOid((String)this.sigAlgo);
            if (curveOid == null) {
                throw new IllegalCmdParamException("invalid sigAlgo " + this.sigAlgo);
            }
            return new P11SignSpeed.EC(this.keyPresent.booleanValue(), this.securityFactory, this.getSlot(), this.getKeyId(), this.keyLabel, this.sigAlgo, this.getNumThreads(), curveOid);
        }
    }

    @Command(scope="xi", name="speed-ed-gen-p11", description="performance test of PKCS#11 Edwards and montgomery EC key generation")
    @Service
    public static class SpeedEdGenP11
    extends SpeedP11Action {
        @Option(name="--curve", required=true, description="curve name")
        @Completion(value=Completers.EdCurveNameCompleter.class)
        private String curveName;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            ASN1ObjectIdentifier curveOid = QaSecurityActions.getCurveOid(this.curveName);
            return new P11KeyGenSpeed.EC(this.getSlot(), this.getKeyId(), curveOid);
        }

        @Override
        protected int getNumThreads() {
            return this.getKeyId() == null ? super.getNumThreads() : 1;
        }
    }

    @Command(scope="xi", name="speed-ec-sign-p11", description="performance test of PKCS#11 EC signature creation")
    @Service
    public static class SpeedEcSignP11
    extends SpeedP11SignAction {
        @Option(name="--curve", description="EC curve name")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName = "secp256r1";
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.ECDSASigAlgCompleter.class)
        private String sigAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11SignSpeed.EC(this.keyPresent.booleanValue(), this.securityFactory, this.getSlot(), this.getKeyId(), this.keyLabel, this.sigAlgo, this.getNumThreads(), AlgorithmUtil.getCurveOidForCurveNameOrOid((String)this.curveName));
        }
    }

    @Command(scope="xi", name="speed-ec-gen-p11", description="performance test of PKCS#11 EC key generation")
    @Service
    public static class SpeedEcGenP11
    extends SpeedP11Action {
        @Option(name="--curve", required=true, description="EC curve name")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            ASN1ObjectIdentifier curveOid = QaSecurityActions.getCurveOid(this.curveName);
            return new P11KeyGenSpeed.EC(this.getSlot(), this.getKeyId(), curveOid);
        }

        @Override
        protected int getNumThreads() {
            return this.getKeyId() == null ? super.getNumThreads() : 1;
        }
    }

    @Command(scope="xi", name="speed-dsa-sign-p11", description="performance test of PKCS#11 DSA signature creation")
    @Service
    public static class SpeedDsaSignP11
    extends SpeedP11SignAction {
        @Option(name="--plen", description="bit length of the prime")
        private Integer plen = 2048;
        @Option(name="--qlen", description="bit length of the sub-prime")
        private Integer qlen;
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.DSASigAlgCompleter.class)
        private String sigAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            if (this.qlen == null) {
                this.qlen = this.plen >= 2048 ? 256 : 160;
            }
            if (this.plen == 1024 && !"SHA1withDSA".equalsIgnoreCase(this.sigAlgo)) {
                throw new IllegalCmdParamException("only SHA1withDSA is permitted for DSA with 1024 bit");
            }
            return new P11SignSpeed.DSA(this.keyPresent.booleanValue(), this.securityFactory, this.getSlot(), this.getKeyId(), this.keyLabel, this.sigAlgo, this.getNumThreads(), this.plen.intValue(), this.qlen.intValue());
        }
    }

    @Command(scope="xi", name="speed-dsa-gen-p11", description="performance test of PKCS#11 DSA key generation")
    @Service
    public static class SpeedDsaGenP11
    extends SpeedP11Action {
        @Option(name="--plen", description="bit length of the prime")
        private Integer plen = 2048;
        @Option(name="--qlen", description="bit length of the sub-prime")
        private Integer qlen;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            if (this.qlen == null) {
                this.qlen = this.plen >= 2048 ? 256 : 160;
            }
            return new P11KeyGenSpeed.DSA(this.getSlot(), this.getKeyId(), this.plen.intValue(), this.qlen.intValue());
        }

        @Override
        protected int getNumThreads() {
            return this.getKeyId() == null ? super.getNumThreads() : 1;
        }
    }

    public static abstract class SpeedP11Action
    extends SingleSpeedAction {
        @Reference(optional=true)
        protected P11CryptServiceFactory p11CryptServiceFactory;
        @Option(name="--key-id", description="id of the PKCS#11 key")
        private String hexKeyId;
        @Option(name="--slot", required=true, description="slot index")
        protected Integer slotIndex;
        @Option(name="--module", description="Name of the PKCS#11 module.")
        @Completion(value=QaCompleters.P11ModuleNameCompleter.class)
        protected String moduleName = "default";

        protected P11Slot getSlot() throws XiSecurityException, P11TokenException, IllegalCmdParamException {
            P11CryptService p11Service = this.p11CryptServiceFactory.getP11CryptService(this.moduleName);
            if (p11Service == null) {
                throw new IllegalCmdParamException("undefined module " + this.moduleName);
            }
            P11Module module = p11Service.getModule();
            return module.getSlot(module.getSlotIdForIndex(this.slotIndex.intValue()));
        }

        protected byte[] getKeyId() {
            return StringUtil.isBlank((String)this.hexKeyId) ? null : Hex.decode((String)this.hexKeyId);
        }
    }

    @Command(scope="xi", name="bspeed-rsa-sign-p11", description="performance test of PKCS#11 RSA signature creation (batch)")
    @Service
    public static class BspeedRsaSignP11
    extends BSpeedP11Action {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.RSASigAlgCompleter.class)
        private String sigAlgo;
        private final Queue<KeyControl.RSA> queue = new LinkedList<KeyControl.RSA>();

        public BspeedRsaSignP11() {
            this.queue.add(new KeyControl.RSA(1024));
            this.queue.add(new KeyControl.RSA(2048));
            this.queue.add(new KeyControl.RSA(3072));
            this.queue.add(new KeyControl.RSA(4096));
        }

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.RSA control = this.queue.poll();
            if (control == null) {
                return null;
            }
            return new P11SignSpeed.RSA(this.securityFactory, this.getSlot(), this.getKeyId(), this.sigAlgo, this.getNumThreads(), control.modulusLen(), BspeedRsaSignP11.toBigInt((String)"0x10001"));
        }
    }

    @Command(scope="xi", name="bspeed-rsa-gen-p11", description="performance test of PKCS#11 RSA key generation (batch)")
    @Service
    public static class BspeedRsaGenP11
    extends BSpeedP11Action {
        private final Queue<KeyControl.RSA> queue = new LinkedList<KeyControl.RSA>();

        public BspeedRsaGenP11() {
            this.queue.add(new KeyControl.RSA(1024));
            this.queue.add(new KeyControl.RSA(2048));
            this.queue.add(new KeyControl.RSA(3072));
            this.queue.add(new KeyControl.RSA(4096));
        }

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.RSA control = this.queue.poll();
            if (control == null) {
                return null;
            }
            return new P11KeyGenSpeed.RSA(this.getSlot(), this.getKeyId(), control.modulusLen(), BspeedRsaGenP11.toBigInt((String)"0x10001"));
        }
    }

    @Command(scope="xi", name="bspeed-ec-sign-p11", description="performance test of PKCS#11 EC signature creation (batch)")
    @Service
    public static class BspeedEcSignP11
    extends BSpeedP11Action {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.ECDSASigAlgCompleter.class)
        private String sigAlgo;
        private final Queue<KeyControl.EC> queue = new LinkedList<KeyControl.EC>();

        public BspeedEcSignP11() {
            for (String curveName : this.getECCurveNames()) {
                this.queue.add(new KeyControl.EC(curveName));
            }
        }

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.EC control = this.queue.poll();
            if (control == null) {
                return null;
            }
            return new P11SignSpeed.EC(this.securityFactory, this.getSlot(), this.getKeyId(), this.sigAlgo, this.getNumThreads(), AlgorithmUtil.getCurveOidForCurveNameOrOid((String)control.curveName));
        }
    }

    @Command(scope="xi", name="bspeed-ec-gen-p11", description="performance test of PKCS#11 EC key generation (batch)")
    @Service
    public static class BspeedEcGenP11
    extends BSpeedP11Action {
        private final Queue<KeyControl.EC> queue = new LinkedList<KeyControl.EC>();

        public BspeedEcGenP11() {
            for (String curveName : this.getECCurveNames()) {
                this.queue.add(new KeyControl.EC(curveName));
            }
        }

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.EC control = this.queue.poll();
            if (control == null) {
                return null;
            }
            ASN1ObjectIdentifier curveOid = QaSecurityActions.getCurveOid(control.curveName());
            return new P11KeyGenSpeed.EC(this.getSlot(), this.getKeyId(), curveOid);
        }

        protected int getNumThreads(int numThreads) {
            return this.getKeyId() == null ? numThreads : 1;
        }
    }

    @Command(scope="xi", name="bspeed-dsa-sign-p11", description="performance test of PKCS#11 DSA signature creation (batch)")
    @Service
    public static class BspeedDsaSignP11
    extends BSpeedP11Action {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.DSASigAlgCompleter.class)
        private String sigAlgo;
        private final Queue<KeyControl.DSA> queue = new LinkedList<KeyControl.DSA>();

        public BspeedDsaSignP11() {
            this.queue.add(new KeyControl.DSA(1024, 160));
            this.queue.add(new KeyControl.DSA(2048, 224));
            this.queue.add(new KeyControl.DSA(2048, 256));
            this.queue.add(new KeyControl.DSA(3072, 256));
        }

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.DSA control = this.queue.poll();
            if (control == null) {
                return null;
            }
            if (control.plen() == 1024 && !"SHA1withDSA".equalsIgnoreCase(this.sigAlgo)) {
                throw new IllegalCmdParamException("only SHA1withDSA is permitted for DSA with 1024 bit");
            }
            return new P11SignSpeed.DSA(this.securityFactory, this.getSlot(), this.getKeyId(), this.sigAlgo, this.getNumThreads(), control.plen(), control.qlen());
        }
    }

    @Command(scope="xi", name="bspeed-dsa-gen-p11", description="performance test of PKCS#11 DSA key generation (batch)")
    @Service
    public static class BspeedDsaGenP11
    extends BSpeedP11Action {
        private final Queue<KeyControl.DSA> queue = new LinkedList<KeyControl.DSA>();

        public BspeedDsaGenP11() {
            this.queue.add(new KeyControl.DSA(1024, 160));
            this.queue.add(new KeyControl.DSA(2048, 224));
            this.queue.add(new KeyControl.DSA(2048, 256));
            this.queue.add(new KeyControl.DSA(3072, 256));
        }

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.DSA control = this.queue.poll();
            if (control == null) {
                return null;
            }
            return new P11KeyGenSpeed.DSA(this.getSlot(), this.getKeyId(), control.plen(), control.qlen());
        }

        @Override
        protected int getNumThreads() {
            return this.getKeyId() == null ? super.getNumThreads() : 1;
        }
    }

    public static abstract class BSpeedP11Action
    extends BatchSpeedAction {
        @Reference(optional=true)
        protected P11CryptServiceFactory p11CryptServiceFactory;
        @Option(name="--key-id", description="id of the PKCS#11 key")
        private String hexKeyId;
        @Option(name="--slot", required=true, description="slot index")
        protected Integer slotIndex;
        @Option(name="--module", description="name of the PKCS#11 module.")
        @Completion(value=QaCompleters.P11ModuleNameCompleter.class)
        protected String moduleName = "default";

        protected P11Slot getSlot() throws XiSecurityException, P11TokenException, IllegalCmdParamException {
            P11CryptService p11Service = this.p11CryptServiceFactory.getP11CryptService(this.moduleName);
            if (p11Service == null) {
                throw new IllegalCmdParamException("undefined module " + this.moduleName);
            }
            P11Module module = p11Service.getModule();
            P11SlotIdentifier slotId = module.getSlotIdForIndex(this.slotIndex.intValue());
            return module.getSlot(slotId);
        }

        protected byte[] getKeyId() {
            return StringUtil.isBlank((String)this.hexKeyId) ? null : Hex.decode((String)this.hexKeyId);
        }
    }

    public static abstract class BatchSpeedAction
    extends SecurityAction {
        private static final Logger LOG = LoggerFactory.getLogger(BatchSpeedAction.class);
        @Option(name="--duration", description="duration for each test case")
        private String duration = "10s";
        @Option(name="--thread", description="number of threads")
        private Integer numThreads = 5;

        protected abstract BenchmarkExecutor nextTester() throws Exception;

        protected Object execute0() throws InterruptedException {
            block3: {
                while (true) {
                    BenchmarkExecutor tester;
                    this.println("============================================");
                    try {
                        tester = this.nextTester();
                    }
                    catch (Exception ex) {
                        String msg = "could not get nextTester";
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        this.println(msg + ": " + ex.getMessage());
                        continue;
                    }
                    if (tester == null) break block3;
                    tester.setDuration(this.duration);
                    tester.setThreads(this.numThreads.intValue());
                    tester.execute();
                    if (tester.isInterrupted()) break;
                }
                throw new InterruptedException("cancelled by the user");
            }
            return null;
        }

        protected List<String> getECCurveNames() {
            return AlgorithmUtil.getECCurveNames();
        }

        protected int getNumThreads() {
            return this.numThreads;
        }
    }

    public static abstract class SingleSpeedAction
    extends SecurityAction {
        @Option(name="--duration", description="duration")
        private String duration = "30s";
        @Option(name="--thread", description="number of threads")
        private Integer numThreads = 5;

        protected abstract BenchmarkExecutor getTester() throws Exception;

        protected Object execute0() throws Exception {
            BenchmarkExecutor tester = this.getTester();
            tester.setDuration(this.duration);
            tester.setThreads(this.getNumThreads());
            tester.execute();
            return null;
        }

        protected int getNumThreads() {
            return this.numThreads;
        }
    }

    public static abstract class SecurityAction
    extends XiAction {
        @Reference
        protected SecurityFactory securityFactory;
    }

    public static class KeyControl {

        public static class RSA
        extends KeyControl {
            private final int modulusLen;

            public RSA(int modulusLen) {
                this.modulusLen = modulusLen;
            }

            public int modulusLen() {
                return this.modulusLen;
            }
        }

        public static class EC
        extends KeyControl {
            private final String curveName;

            public EC(String curveName) {
                this.curveName = Args.notBlank((String)curveName, (String)"curveName");
            }

            public String curveName() {
                return this.curveName;
            }
        }

        public static class DSA
        extends KeyControl {
            private final int plen;
            private final int qlen;

            public DSA(int plen, int qlen) {
                this.plen = plen;
                this.qlen = qlen;
            }

            public int plen() {
                return this.plen;
            }

            public int qlen() {
                return this.qlen;
            }
        }
    }
}

