/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ocsp.client.OcspRequestor;
import org.xipki.ocsp.client.RequestOptions;
import org.xipki.ocsp.client.shell.Actions;
import org.xipki.qa.BigIntegerRange;
import org.xipki.qa.FileBigIntegerIterator;
import org.xipki.qa.RangeBigIntegerIterator;
import org.xipki.qa.ValidationIssue;
import org.xipki.qa.ValidationResult;
import org.xipki.qa.ocsp.OcspBenchmark;
import org.xipki.qa.ocsp.OcspCertStatus;
import org.xipki.qa.ocsp.OcspError;
import org.xipki.qa.ocsp.OcspQa;
import org.xipki.qa.ocsp.OcspResponseOption;
import org.xipki.qa.shell.QaCompleters;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.IssuerHash;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.RandomUtil;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.StringUtil;
import org.xipki.util.TripleState;

public class QaOcspActions {

    @Command(scope="xiqa", name="qa-ocsp-status", description="request certificate status (QA)")
    @Service
    public static class OcspQaStatusAction
    extends Actions.BaseOcspStatusAction {
        @Option(name="--exp-error", description="expected error")
        @Completion(value=QaCompleters.OcspErrorCompleter.class)
        private String errorText;
        @Option(name="--exp-status", multiValued=true, description="expected status")
        @Completion(value=QaCompleters.CertStatusCompleter.class)
        private List<String> statusTexts;
        @Option(name="--rev-time", multiValued=true, description="revocation time, UTC time of format yyyyMMddHHmmss")
        private List<String> revTimeTexts;
        @Option(name="--exp-sig-alg", description="expected signature algorithm")
        @Completion(value=Completers.SigAlgCompleter.class)
        private String sigAlgo;
        @Option(name="--no-sig-verify", description="no verification of the signature")
        private Boolean noSigVerify = Boolean.FALSE;
        @Option(name="--exp-nextupdate", description="occurrence of nextUpdate")
        @Completion(value=QaCompleters.OccurrenceCompleter.class)
        private String nextUpdateOccurrenceText = TripleState.optional.name();
        @Option(name="--exp-certhash", description="occurrence of certHash, will be set to forbidden for status unknown and issuerUnknown")
        @Completion(value=QaCompleters.OccurrenceCompleter.class)
        private String certhashOccurrenceText = TripleState.optional.name();
        @Option(name="--exp-certhash-alg", description="occurrence of certHash")
        @Completion(value=Completers.HashAlgCompleter.class)
        private String certhashAlg;
        @Option(name="--exp-nonce", description="occurrence of nonce")
        @Completion(value=QaCompleters.OccurrenceCompleter.class)
        private String nonceOccurrenceText = TripleState.optional.name();
        @Reference
        private SecurityFactory securityFactory;
        private OcspQa ocspQa;
        private OcspError expectedOcspError;
        private Map<BigInteger, OcspCertStatus> expectedStatuses;
        private Map<BigInteger, Date> expecteRevTimes;
        private TripleState expectedNextUpdateOccurrence;
        private TripleState expectedCerthashOccurrence;
        private TripleState expectedNonceOccurrence;

        protected void checkParameters(X509Cert respIssuer, List<BigInteger> serialNumbers, Map<BigInteger, byte[]> encodedCerts) throws Exception {
            int i;
            int n;
            Args.notEmpty(serialNumbers, (String)"serialNunmbers");
            if (OcspQaStatusAction.isBlank((String)this.errorText) && OcspQaStatusAction.isEmpty(this.statusTexts)) {
                throw new IllegalArgumentException("neither expError nor expStatus is set, this is not permitted");
            }
            if (OcspQaStatusAction.isNotBlank((String)this.errorText) && OcspQaStatusAction.isNotEmpty(this.statusTexts)) {
                throw new IllegalArgumentException("both expError and expStatus are set, this is not permitted");
            }
            if (OcspQaStatusAction.isNotBlank((String)this.errorText)) {
                this.expectedOcspError = OcspError.forName((String)this.errorText);
            }
            if (OcspQaStatusAction.isNotEmpty(this.statusTexts)) {
                if (this.statusTexts.size() != serialNumbers.size()) {
                    throw new IllegalArgumentException("number of expStatus is invalid: " + this.statusTexts.size() + ", it should be " + serialNumbers.size());
                }
                this.expectedStatuses = new HashMap<BigInteger, OcspCertStatus>();
                n = serialNumbers.size();
                for (i = 0; i < n; ++i) {
                    String expectedStatusText = this.statusTexts.get(i);
                    OcspCertStatus certStatus = OcspCertStatus.forName((String)expectedStatusText);
                    this.expectedStatuses.put(serialNumbers.get(i), certStatus);
                }
            }
            if (OcspQaStatusAction.isNotEmpty(this.revTimeTexts)) {
                if (this.revTimeTexts.size() != serialNumbers.size()) {
                    throw new IllegalArgumentException("number of revTimes is invalid: " + this.revTimeTexts.size() + ", it should be " + serialNumbers.size());
                }
                this.expecteRevTimes = new HashMap<BigInteger, Date>();
                n = serialNumbers.size();
                for (i = 0; i < n; ++i) {
                    Date revTime = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.revTimeTexts.get(i));
                    this.expecteRevTimes.put(serialNumbers.get(i), revTime);
                }
            }
            this.expectedCerthashOccurrence = TripleState.valueOf((String)this.certhashOccurrenceText);
            this.expectedNextUpdateOccurrence = TripleState.valueOf((String)this.nextUpdateOccurrenceText);
            this.expectedNonceOccurrence = TripleState.valueOf((String)this.nonceOccurrenceText);
        }

        protected void processResponse(OCSPResp response, X509Cert respIssuer, IssuerHash issuerHash, List<BigInteger> serialNumbers, Map<BigInteger, byte[]> encodedCerts) throws Exception {
            OcspResponseOption responseOption = new OcspResponseOption();
            responseOption.setNextUpdateOccurrence(this.expectedNextUpdateOccurrence);
            responseOption.setCerthashOccurrence(this.expectedCerthashOccurrence);
            responseOption.setNonceOccurrence(this.expectedNonceOccurrence);
            responseOption.setRespIssuer(respIssuer);
            if (OcspQaStatusAction.isNotBlank((String)this.sigAlgo)) {
                responseOption.setSignatureAlg(SignAlgo.getInstance((String)this.sigAlgo));
            }
            if (OcspQaStatusAction.isNotBlank((String)this.certhashAlg)) {
                responseOption.setCerthashAlg(HashAlgo.getInstance((String)this.certhashAlg));
            }
            if (this.ocspQa == null) {
                this.ocspQa = new OcspQa(this.securityFactory);
            }
            ValidationResult result = this.expectedOcspError != null ? this.ocspQa.checkOcsp(response, this.expectedOcspError) : this.ocspQa.checkOcsp(response, issuerHash, serialNumbers, encodedCerts, this.expectedStatuses, this.expecteRevTimes, responseOption, this.noSigVerify.booleanValue());
            StringBuilder sb = new StringBuilder(50);
            sb.append("OCSP response is ").append(result.isAllSuccessful() ? "valid" : "invalid");
            if (this.verbose.booleanValue()) {
                for (ValidationIssue issue : result.getValidationIssues()) {
                    sb.append("\n");
                    OcspQaStatusAction.format(issue, "    ", sb);
                }
            } else {
                for (ValidationIssue issue : result.getValidationIssues()) {
                    if (!issue.isFailed()) continue;
                    sb.append("\n");
                    OcspQaStatusAction.format(issue, "    ", sb);
                }
            }
            this.println(sb.toString());
            if (!result.isAllSuccessful()) {
                throw new CmdFailure("OCSP response is invalid");
            }
        }

        static void format(ValidationIssue issue, String prefix, StringBuilder sb) {
            sb.append(prefix).append(issue.getCode()).append(", ").append(issue.getDescription());
            sb.append(", ").append(issue.isFailed() ? "failed" : "successful");
            if (issue.getFailureMessage() != null) {
                sb.append(", ").append(issue.getFailureMessage());
            }
        }
    }

    @Command(scope="xiqa", name="benchmark-ocsp-status", description="OCSP benchmark")
    @Service
    public static class BenchmarkOcspStatusAction
    extends Actions.CommonOcspStatusAction {
        @Option(name="--hex", description="serial number without prefix is hex number")
        private Boolean hex = Boolean.FALSE;
        @Option(name="--serial", aliases={"-s"}, description="comma-separated serial numbers or ranges (like 1,3,6-10)\n(exactly one of serial, serial-file and cert must be specified)")
        private String serialNumberList;
        @Option(name="--serial-file", description="file that contains serial numbers")
        @Completion(value=FileCompleter.class)
        private String serialNumberFile;
        @Option(name="--cert", multiValued=true, description="certificate files")
        @Completion(value=FileCompleter.class)
        private List<String> certFiles;
        @Option(name="--duration", description="duration")
        private String duration = "30s";
        @Option(name="--thread", description="number of threads")
        private Integer numThreads = 5;
        @Option(name="--url", required=true, description="OCSP responder URL")
        private String serverUrl;
        @Option(name="--max-num", description="maximal number of OCSP queries\n0 for unlimited")
        private Integer maxRequests = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            FileBigIntegerIterator serialNumberIterator;
            int ii = 0;
            if (this.serialNumberList != null) {
                ++ii;
            }
            if (this.serialNumberFile != null) {
                ++ii;
            }
            if (CollectionUtil.isNotEmpty(this.certFiles)) {
                ++ii;
            }
            if (ii != 1) {
                throw new IllegalCmdParamException("exactly one of serial, serial-file and cert must be specified");
            }
            if (this.numThreads < 1) {
                throw new IllegalCmdParamException("invalid number of threads " + this.numThreads);
            }
            if (this.serialNumberFile != null) {
                serialNumberIterator = new FileBigIntegerIterator(IoUtil.expandFilepath((String)this.serialNumberFile), this.hex.booleanValue(), true);
            } else {
                LinkedList<BigIntegerRange> serialNumbers = new LinkedList<BigIntegerRange>();
                if (this.serialNumberList != null) {
                    StringTokenizer st = new StringTokenizer(this.serialNumberList, ", ");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        StringTokenizer st2 = new StringTokenizer(token, "-");
                        BigInteger from = BenchmarkOcspStatusAction.toBigInt((String)st2.nextToken(), (boolean)this.hex);
                        BigInteger to = st2.hasMoreTokens() ? BenchmarkOcspStatusAction.toBigInt((String)st2.nextToken(), (boolean)this.hex) : from;
                        serialNumbers.add(new BigIntegerRange(from, to));
                    }
                } else if (this.certFiles != null) {
                    for (String certFile : this.certFiles) {
                        X509Cert cert;
                        try {
                            cert = X509Util.parseCert((File)new File(certFile));
                        }
                        catch (Exception ex) {
                            throw new IllegalCmdParamException("invalid certificate file  '" + certFile + "'", (Throwable)ex);
                        }
                        BigInteger serial = cert.getSerialNumber();
                        serialNumbers.add(new BigIntegerRange(serial, serial));
                    }
                }
                serialNumberIterator = new RangeBigIntegerIterator(serialNumbers, true);
            }
            try {
                String description = StringUtil.concatObjects((Object)"issuer cert: ", (Object[])new Object[]{this.issuerCertFile, "\nserver URL: ", this.serverUrl, "\nmaxRequest: ", this.maxRequests, "\nhash: ", this.hashAlgo});
                X509Cert issuerCert = X509Util.parseCert((File)new File(this.issuerCertFile));
                RequestOptions options = this.getRequestOptions();
                OcspBenchmark loadTest = new OcspBenchmark(issuerCert, this.serverUrl, options, (Iterator)serialNumberIterator, this.maxRequests.intValue(), description);
                loadTest.setDuration(this.duration);
                loadTest.setThreads(this.numThreads.intValue());
                loadTest.execute();
            }
            finally {
                if (serialNumberIterator instanceof FileBigIntegerIterator) {
                    serialNumberIterator.close();
                }
            }
            return null;
        }
    }

    @Command(scope="xiqa", name="batch-ocsp-status", description="batch request status of certificates (QA)")
    @Service
    public static class BatchOcspQaStatusAction
    extends Actions.CommonOcspStatusAction {
        private static final Logger LOG = LoggerFactory.getLogger(BatchOcspQaStatusAction.class);
        private static final String FILE_SEP = File.separator;
        @Option(name="--resp-issuer", description="certificate file of the responder's issuer")
        @Completion(value=FileCompleter.class)
        private String respIssuerFile;
        @Option(name="--url", required=true, description="OCSP responder URL")
        private String serverUrlStr;
        @Option(name="--sn-file", required=true, description="file containing the serial number and revocation information\nEach line starts with # for comment or is of following format\nserial-number[,status[,revocation-time]]")
        @Completion(value=FileCompleter.class)
        private String snFile;
        @Option(name="--hex", description="serial number without prefix is hex number")
        private Boolean hex = Boolean.FALSE;
        @Option(name="--out-dir", required=true, description="folder to save the request and response")
        @Completion(value=Completers.DirCompleter.class)
        private String outDirStr;
        @Option(name="--save-req", description="whether to save the request")
        private Boolean saveReq = Boolean.FALSE;
        @Option(name="--save-resp", description="whether to save the request")
        private Boolean saveResp = Boolean.FALSE;
        @Option(name="--unknown-as", description="expected status for unknown certificate")
        @Completion(value=QaCompleters.CertStatusCompleter.class)
        private String unknownAs;
        @Option(name="--no-sig-verify", description="where to verify the signature")
        private Boolean noSigVerify = Boolean.FALSE;
        @Option(name="--exp-sig-alg", description="expected signature algorithm")
        @Completion(value=Completers.SigAlgCompleter.class)
        private String sigAlgo;
        @Option(name="--exp-nextupdate", description="occurrence of nextUpdate")
        @Completion(value=QaCompleters.OccurrenceCompleter.class)
        private String nextUpdateOccurrenceText = TripleState.optional.name();
        @Option(name="--exp-certhash", description="occurrence of certHash, will be set to forbidden for status unknown and issuerUnknown")
        @Completion(value=QaCompleters.OccurrenceCompleter.class)
        private String certhashOccurrenceText = TripleState.optional.name();
        @Option(name="--exp-certhash-alg", description="occurrence of certHash")
        @Completion(value=Completers.HashAlgCompleter.class)
        private String certhashAlg;
        @Option(name="--exp-nonce", description="occurrence of nonce")
        @Completion(value=QaCompleters.OccurrenceCompleter.class)
        private String nonceOccurrenceText = TripleState.optional.name();
        @Reference
        private SecurityFactory securityFactory;
        @Reference
        private OcspRequestor requestor;
        private TripleState expectedCerthashOccurrence;
        private TripleState expectedNextUpdateOccurrence;
        private TripleState expectedNonceOccurrence;

        protected final Object execute0() throws Exception {
            this.expectedCerthashOccurrence = TripleState.valueOf((String)this.certhashOccurrenceText);
            this.expectedNextUpdateOccurrence = TripleState.valueOf((String)this.nextUpdateOccurrenceText);
            this.expectedNonceOccurrence = TripleState.valueOf((String)this.nonceOccurrenceText);
            File outDir = new File(this.outDirStr);
            File messageDir = new File(outDir, "messages");
            messageDir.mkdirs();
            File detailsDir = new File(outDir, "details");
            detailsDir.mkdirs();
            this.println("The result is saved in the folder " + outDir.getPath());
            String linuxIssuer = this.respIssuerFile != null ? "-CAfile ../../responder_issuer.pem" : "-no_cert_verify";
            String winIssuer = this.respIssuerFile != null ? "-CAfile ..\\..\\responder_issuer.pem" : "-no_cert_verify";
            String linuxMsg = "openssl ocsp -text ";
            String winMsg = "openssl ocsp -text ";
            String shellFilePath = null;
            if (this.saveReq.booleanValue() && this.saveResp.booleanValue()) {
                linuxMsg = linuxMsg + linuxIssuer + " -reqin request.der -respin response.der";
                winMsg = winMsg + winIssuer + " -reqin request.der -respin response.der";
                shellFilePath = new File(outDir, "verify-req-resp").getPath();
            } else if (this.saveReq.booleanValue()) {
                linuxMsg = linuxMsg + "-reqin request.der\n";
                winMsg = winMsg + "-reqin request.der\n";
                shellFilePath = new File(outDir, "verify-req").getPath();
            } else if (this.saveResp.booleanValue()) {
                linuxMsg = linuxMsg + linuxIssuer + " -respin response.der\n";
                winMsg = winMsg + winIssuer + " -respin response.der\n";
                shellFilePath = new File(outDir, "verify-resp").getPath();
            }
            if (shellFilePath != null) {
                File linuxShellFile = new File(shellFilePath + ".sh");
                IoUtil.save((File)linuxShellFile, (byte[])StringUtil.toUtf8Bytes((String)("#!/bin/sh\n" + linuxMsg)));
                IoUtil.save((String)(shellFilePath + ".bat"), (byte[])StringUtil.toUtf8Bytes((String)("@echo off\r\n" + winMsg)));
                linuxShellFile.setExecutable(true);
            }
            X509Cert issuerCert = X509Util.parseCert((File)new File(this.issuerCertFile));
            X509Cert respIssuer = null;
            if (this.respIssuerFile != null) {
                respIssuer = X509Util.parseCert((File)new File(this.respIssuerFile));
                IoUtil.save((File)new File(outDir, "responder-issuer.pem"), (byte[])StringUtil.toUtf8Bytes((String)X509Util.toPemCert((X509Cert)respIssuer)));
            }
            RequestOptions requestOptions = this.getRequestOptions();
            IssuerHash issuerHash = new IssuerHash(requestOptions.getHashAlgorithm(), issuerCert);
            int numSucc = 0;
            int numFail = 0;
            try (OutputStream resultOut = Files.newOutputStream(Paths.get(outDir.getPath(), "overview.txt"), new OpenOption[0]);
                 BufferedReader snReader = Files.newBufferedReader(Paths.get(this.snFile, new String[0]));){
                String line;
                URL serverUrl = new URL(this.serverUrlStr);
                OcspQa ocspQa = new OcspQa(this.securityFactory);
                int lineNo = 0;
                int sum = 0;
                long startDate = System.currentTimeMillis();
                long lastPrintDate = 0L;
                while ((line = snReader.readLine()) != null) {
                    ++lineNo;
                    if ((line = line.trim()).startsWith("#") || line.isEmpty()) {
                        resultOut.write(StringUtil.toUtf8Bytes((String)line));
                        resultOut.write(10);
                        continue;
                    }
                    ++sum;
                    String resultText = lineNo + ": " + line + ": ";
                    try {
                        ValidationResult result = this.processOcspQuery(ocspQa, line, messageDir, detailsDir, serverUrl, respIssuer, issuerCert, issuerHash, requestOptions);
                        if (result.isAllSuccessful()) {
                            ++numSucc;
                            resultText = resultText + "valid";
                        } else {
                            ++numFail;
                            resultText = resultText + "invalid";
                        }
                    }
                    catch (Throwable th) {
                        LogUtil.error((Logger)LOG, (Throwable)th);
                        ++numFail;
                        resultText = resultText + "error - " + th.getMessage();
                    }
                    this.println(resultText, resultOut);
                    long now = System.currentTimeMillis();
                    if (now - lastPrintDate <= 980L) continue;
                    String duration = StringUtil.formatTime((long)((now - startDate) / 1000L), (boolean)false);
                    this.print("\rProcessed " + sum + " requests in " + duration);
                    lastPrintDate = now;
                }
                byte[] bytes = RandomUtil.nextBytes((int)16);
                bytes[0] = (byte)(0x7F & bytes[0]);
                BigInteger serialNumber = new BigInteger(bytes);
                String resultText = ++lineNo + ": " + serialNumber.toString(16) + ",unknown: ";
                try {
                    ValidationResult result = this.processOcspQuery(ocspQa, serialNumber, OcspCertStatus.unknown, null, messageDir, detailsDir, serverUrl, respIssuer, issuerCert, issuerHash, requestOptions);
                    if (result.isAllSuccessful()) {
                        ++numSucc;
                        resultText = resultText + "valid";
                    } else {
                        ++numFail;
                        resultText = resultText + "invalid";
                    }
                }
                catch (Throwable th) {
                    LogUtil.error((Logger)LOG, (Throwable)th);
                    ++numFail;
                    resultText = resultText + "error - " + th.getMessage();
                }
                this.print("\rProcessed " + ++sum + " requests in " + StringUtil.formatTime((long)((System.currentTimeMillis() - startDate) / 1000L), (boolean)false));
                this.println("");
                this.println(resultText, resultOut);
                String message = StringUtil.concatObjectsCap((int)200, (Object)"=====BEGIN SUMMARY=====", (Object[])new Object[]{"\n       url: ", this.serverUrlStr, "\n       sum: ", numFail + numSucc, "\nsuccessful: ", numSucc, "\n    failed: ", numFail, "\n=====END SUMMARY====="});
                this.println(message);
                this.println(message, resultOut);
            }
            return null;
        }

        private ValidationResult processOcspQuery(OcspQa ocspQa, String line, File messageDir, File detailsDir, URL serverUrl, X509Cert respIssuer, X509Cert issuerCert, IssuerHash issuerHash, RequestOptions requestOptions) throws Exception {
            OcspCertStatus status;
            BigInteger serialNumber;
            StringTokenizer tokens = new StringTokenizer(line, ",;:");
            int count = tokens.countTokens();
            Date revTime = null;
            try {
                serialNumber = BatchOcspQaStatusAction.toBigInt((String)tokens.nextToken(), (boolean)this.hex);
                if (count > 1) {
                    String token = tokens.nextToken();
                    if ("unknown".equalsIgnoreCase(token)) {
                        status = OcspCertStatus.unknown;
                    } else if ("good".equalsIgnoreCase(token)) {
                        status = OcspCertStatus.good;
                    } else {
                        CrlReason reason = CrlReason.forNameOrText((String)token);
                        switch (reason) {
                            case AA_COMPROMISE: {
                                status = OcspCertStatus.aACompromise;
                                break;
                            }
                            case CA_COMPROMISE: {
                                status = OcspCertStatus.cACompromise;
                                break;
                            }
                            case AFFILIATION_CHANGED: {
                                status = OcspCertStatus.affiliationChanged;
                                break;
                            }
                            case CERTIFICATE_HOLD: {
                                status = OcspCertStatus.certificateHold;
                                break;
                            }
                            case CESSATION_OF_OPERATION: {
                                status = OcspCertStatus.cessationOfOperation;
                                break;
                            }
                            case KEY_COMPROMISE: {
                                status = OcspCertStatus.keyCompromise;
                                break;
                            }
                            case PRIVILEGE_WITHDRAWN: {
                                status = OcspCertStatus.privilegeWithdrawn;
                                break;
                            }
                            case SUPERSEDED: {
                                status = OcspCertStatus.superseded;
                                break;
                            }
                            case UNSPECIFIED: {
                                status = OcspCertStatus.unspecified;
                                break;
                            }
                            default: {
                                throw new Exception("invalid reason " + reason);
                            }
                        }
                    }
                } else {
                    status = OcspCertStatus.good;
                }
                if (count > 2 && status != OcspCertStatus.good && status != OcspCertStatus.unknown) {
                    revTime = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)tokens.nextToken());
                }
            }
            catch (Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("Could not parse line '" + line + "'"));
                throw new IllegalArgumentException("illegal line");
            }
            return this.processOcspQuery(ocspQa, serialNumber, status, revTime, messageDir, detailsDir, serverUrl, respIssuer, issuerCert, issuerHash, requestOptions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ValidationResult processOcspQuery(OcspQa ocspQa, BigInteger serialNumber, OcspCertStatus status, Date revTime, File messageDir, File detailsDir, URL serverUrl, X509Cert respIssuer, X509Cert issuerCert, IssuerHash issuerHash, RequestOptions requestOptions) throws Exception {
            ValidationResult ret;
            OCSPResp response;
            if (status == OcspCertStatus.unknown && BatchOcspQaStatusAction.isNotBlank((String)this.unknownAs)) {
                status = OcspCertStatus.forName((String)this.unknownAs);
            }
            ReqRespDebug debug = null;
            if (this.saveReq.booleanValue() || this.saveResp.booleanValue()) {
                debug = new ReqRespDebug(this.saveReq.booleanValue(), this.saveResp.booleanValue());
            }
            try {
                response = this.requestor.ask(issuerCert, serialNumber, serverUrl, requestOptions, debug);
            }
            finally {
                if (debug != null && debug.size() > 0) {
                    byte[] bytes;
                    ReqRespDebug.ReqRespPair reqResp = debug.get(0);
                    String filename = serialNumber.toString(16);
                    if (this.saveReq.booleanValue() && (bytes = reqResp.getRequest()) != null) {
                        IoUtil.save((File)new File(messageDir, filename + FILE_SEP + "request.der"), (byte[])bytes);
                    }
                    if (this.saveResp.booleanValue() && (bytes = reqResp.getResponse()) != null) {
                        IoUtil.save((File)new File(messageDir, filename + FILE_SEP + "response.der"), (byte[])bytes);
                    }
                }
            }
            OcspResponseOption responseOption = new OcspResponseOption();
            responseOption.setNextUpdateOccurrence(this.expectedNextUpdateOccurrence);
            responseOption.setCerthashOccurrence(this.expectedCerthashOccurrence);
            responseOption.setNonceOccurrence(this.expectedNonceOccurrence);
            responseOption.setRespIssuer(respIssuer);
            if (BatchOcspQaStatusAction.isNotBlank((String)this.sigAlgo)) {
                responseOption.setSignatureAlg(SignAlgo.getInstance((String)this.sigAlgo));
            }
            if (BatchOcspQaStatusAction.isNotBlank((String)this.certhashAlg)) {
                responseOption.setCerthashAlg(HashAlgo.getInstance((String)this.certhashAlg));
            }
            String validity = (ret = ocspQa.checkOcsp(response, issuerHash, serialNumber, null, status, responseOption, revTime, this.noSigVerify.booleanValue())).isAllSuccessful() ? "valid" : "invalid";
            String hexSerial = serialNumber.toString(16);
            StringBuilder sb = new StringBuilder("OCSP response for ");
            sb.append(serialNumber).append(" (0x").append(hexSerial).append(") is ").append(validity);
            for (ValidationIssue issue : ret.getValidationIssues()) {
                sb.append("\n");
                OcspQaStatusAction.format(issue, "    ", sb);
            }
            IoUtil.save((File)new File(detailsDir, hexSerial + "." + validity), (byte[])StringUtil.toUtf8Bytes((String)sb.toString()));
            return ret;
        }

        private void println(String message, OutputStream out) throws IOException {
            out.write(StringUtil.toUtf8Bytes((String)message));
            out.write(10);
        }
    }
}

