/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.shell;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.qa.ca.CaQaSystemManager;
import org.xipki.qa.ocsp.OcspCertStatus;
import org.xipki.qa.ocsp.OcspError;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.shell.DynamicEnumCompleter;
import org.xipki.shell.EnumCompleter;
import org.xipki.util.CollectionUtil;
import org.xipki.util.TripleState;

public class QaCompleters {

    @Service
    public static class P11ModuleNameCompleter
    extends DynamicEnumCompleter {
        @Reference(optional=true)
        private P11CryptServiceFactory p11CryptServiceFactory;

        protected Set<String> getEnums() {
            Set names = this.p11CryptServiceFactory.getModuleNames();
            if (CollectionUtil.isEmpty((Collection)names)) {
                return Collections.emptySet();
            }
            return names;
        }
    }

    @Service
    public static class OcspErrorCompleter
    extends EnumCompleter {
        public OcspErrorCompleter() {
            LinkedList<String> enums = new LinkedList<String>();
            for (OcspError entry : OcspError.values()) {
                enums.add(entry.name());
            }
            this.setTokens(enums);
        }
    }

    @Service
    public static class OccurrenceCompleter
    extends EnumCompleter {
        public OccurrenceCompleter() {
            LinkedList<String> enums = new LinkedList<String>();
            for (TripleState entry : TripleState.values()) {
                enums.add(entry.name());
            }
            this.setTokens(enums);
        }
    }

    @Service
    public static class IssuerNameCompleter
    extends DynamicEnumCompleter {
        @Reference
        private CaQaSystemManager qaSystemManager;

        protected Set<String> getEnums() {
            return this.qaSystemManager.getIssuerNames();
        }
    }

    @Service
    public static class CertStatusCompleter
    extends EnumCompleter {
        public CertStatusCompleter() {
            LinkedList<String> enums = new LinkedList<String>();
            for (OcspCertStatus entry : OcspCertStatus.values()) {
                enums.add(entry.name());
            }
            this.setTokens(enums);
        }
    }

    @Service
    public static class CertprofileNameCompleter
    extends DynamicEnumCompleter {
        @Reference
        private CaQaSystemManager qaSystemManager;

        protected Set<String> getEnums() {
            return this.qaSystemManager.getCertprofileNames();
        }
    }
}

