/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.shell;

import java.io.File;
import java.rmi.UnexpectedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extensions;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.mgmt.CaProfileEntry;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.Permissions;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.ca.mgmt.shell.ProfileActions;
import org.xipki.ca.mgmt.shell.PublisherActions;
import org.xipki.ca.mgmt.shell.RequestorActions;
import org.xipki.ca.mgmt.shell.SignerActions;
import org.xipki.qa.ValidationIssue;
import org.xipki.qa.ValidationResult;
import org.xipki.qa.ca.CaEnrollBenchEntry;
import org.xipki.qa.ca.CaEnrollBenchKeyEntry;
import org.xipki.qa.ca.CaEnrollBenchmark;
import org.xipki.qa.ca.CaQaSystemManager;
import org.xipki.qa.ca.CertprofileQa;
import org.xipki.qa.ca.IssuerInfo;
import org.xipki.qa.shell.QaCompleters;
import org.xipki.security.EdECConstants;
import org.xipki.security.X509Cert;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class QaCaActions {
    private static void assertTypeEquals(String desc, String ex, String is) throws CmdFailure {
        boolean bo;
        String tmpEx = ex;
        if ("null".equals(tmpEx)) {
            tmpEx = null;
        }
        boolean bl = tmpEx == null ? is == null : (bo = tmpEx.equalsIgnoreCase(is));
        if (!bo) {
            throw new CmdFailure(desc + ": is '" + is + "', but expected '" + tmpEx + "'");
        }
    }

    private static void assertEquals(String desc, String ex, String is) throws CmdFailure {
        String tmpEx;
        String string = tmpEx = "null".equals(ex) ? null : ex;
        if (!Objects.equals(tmpEx, is)) {
            throw new CmdFailure(desc + ": is '" + is + "', but expected '" + tmpEx + "'");
        }
    }

    private static void assertObjEquals(String desc, Object ex, Object is) throws CmdFailure {
        if (!Objects.equals(ex, is)) {
            throw new CmdFailure(desc + ": is '" + is + "', but expected '" + ex + "'");
        }
    }

    private static boolean certEquals(byte[] certBytes1, byte[] certBytes2) {
        if (certBytes1 == null && certBytes2 == null) {
            return true;
        }
        if (certBytes1 != null && certBytes2 != null) {
            try {
                return Arrays.equals(X509Util.parseCert((byte[])certBytes1).getEncoded(), X509Util.parseCert((byte[])certBytes2).getEncoded());
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    @Command(scope="caqa", name="signer-check", description="check information of signer (QA)")
    @Service
    public static class SignerCheck
    extends SignerActions.SignerUp {
        protected Object execute0() throws Exception {
            String signerConf;
            this.println("checking signer " + this.name);
            SignerEntry cr = Optional.ofNullable(this.caManager.getSigner(this.name)).orElseThrow(() -> new CmdFailure("signer named '" + this.name + "' is not configured"));
            if ("null".equalsIgnoreCase(this.certFile)) {
                if (cr.base64Cert() != null) {
                    throw new CmdFailure("CaCert: is configured but expected is none");
                }
            } else if (this.certFile != null) {
                byte[] ex = IoUtil.read((String)this.certFile);
                if (cr.base64Cert() == null) {
                    throw new CmdFailure("CaCert: is not configured explicitly as expected");
                }
                if (!QaCaActions.certEquals(ex, Base64.decode((String)cr.base64Cert()))) {
                    throw new CmdFailure("CaCert: the expected one and the actual one differ");
                }
            }
            if ((signerConf = this.getSignerConf()) != null) {
                ConfPairs pairs = new ConfPairs(signerConf);
                String name = "algo";
                if (pairs.value(name) != null) {
                    pairs.putPair(name, pairs.value(name).toUpperCase(Locale.ROOT));
                }
                signerConf = pairs.getEncoded();
                QaCaActions.assertEquals("conf", signerConf, cr.getConf());
            }
            this.println(" checked signer " + this.name);
            return null;
        }
    }

    @Command(scope="caqa", name="requestor-check", description="check information of requestors (QA)")
    @Service
    public static class RequestorCheck
    extends RequestorActions.RequestorUp {
        protected Object execute0() throws Exception {
            this.println("checking requestor " + this.name);
            RequestorEntry cr = Optional.ofNullable(this.caManager.getRequestor(this.name)).orElseThrow(() -> new CmdFailure("requestor named '" + this.name + "' is not configured"));
            byte[] ex = IoUtil.read((String)this.certFile);
            String expType = "cert";
            if (!cr.getType().equals(expType)) {
                throw new CmdFailure("IdNameTypeConf type is not " + expType);
            }
            String conf = Optional.ofNullable(cr.getConf()).orElseThrow(() -> new CmdFailure("CaCert: is not configured explicitly as expected"));
            if (!QaCaActions.certEquals(ex, Base64.decode((String)conf))) {
                throw new CmdFailure("CaCert: the expected one and the actual one differ");
            }
            this.println(" checked requestor " + this.name);
            return null;
        }
    }

    @Command(scope="caqa", name="publisher-check", description="check information of publishers (QA)")
    @Service
    public static class PublisherCheck
    extends PublisherActions.PublisherUp {
        protected Object execute0() throws Exception {
            this.println("checking publisher " + this.name);
            PublisherEntry cp = Optional.ofNullable(this.caManager.getPublisher(this.name)).orElseThrow(() -> new CmdFailure("publisher named '" + this.name + "' is not configured"));
            if (cp.getType() != null) {
                QaCaActions.assertTypeEquals("type", this.type, cp.getType());
            }
            if (cp.getConf() != null) {
                QaCaActions.assertEquals("signer conf", this.conf, cp.getConf());
            }
            this.println(" checked publisher " + this.name);
            return null;
        }
    }

    @Command(scope="caqa", name="profile-check", description="check information of profiles (QA)")
    @Service
    public static class ProfileCheck
    extends ProfileActions.ProfileUp {
        protected Object execute0() throws Exception {
            this.println("checking profile " + this.name);
            if (this.type == null && this.conf == null && this.confFile == null) {
                System.out.println("nothing to update");
                return null;
            }
            if (this.conf == null && this.confFile != null) {
                this.conf = StringUtil.toUtf8String((byte[])IoUtil.read((String)this.confFile));
            }
            CertprofileEntry cp = Optional.ofNullable(this.caManager.getCertprofile(this.name)).orElseThrow(() -> new CmdFailure("certificate profile named '" + this.name + "' is not configured"));
            QaCaActions.assertTypeEquals("type", this.type == null ? "xijson" : this.type, cp.getType());
            QaCaActions.assertEquals("conf", this.conf, cp.getConf());
            this.println(" checked profile " + this.name);
            return null;
        }
    }

    @Command(scope="caqa", name="careq-check", description="check information of requestors in CA (QA)")
    @Service
    public static class CaReqCheck
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--requestor", required=true, description="requestor name")
        @Completion(value=CaCompleters.RequestorNameCompleter.class)
        private String requestorName;
        @Option(name="--permission", multiValued=true, description="permission")
        @Completion(value=CaCompleters.PermissionCompleter.class)
        private Set<String> permissions;
        @Option(name="--profile", multiValued=true, description="profile name or 'all' for all profiles, and 'null' for no profiles")
        @Completion(value=CaCompleters.ProfileNameAndAllCompleter.class)
        private Set<String> profiles;

        protected Object execute0() throws Exception {
            Permissions objPermissions;
            this.println("checking CA requestor CA='" + this.caName + "', requestor='" + this.requestorName + "'");
            if (this.caManager.getCa(this.caName) == null) {
                throw new UnexpectedException("could not find CA '" + this.caName + "'");
            }
            Set entries = this.caManager.getRequestorsForCa(this.caName);
            CaHasRequestorEntry entry = null;
            String upRequestorName = this.requestorName.toLowerCase();
            for (CaHasRequestorEntry m : entries) {
                if (!m.getRequestorIdent().getName().equals(upRequestorName)) continue;
                entry = m;
                break;
            }
            if (entry == null) {
                throw new CmdFailure("CA is not associated with requestor '" + this.requestorName + "'");
            }
            if (this.permissions != null && (objPermissions = new Permissions(this.permissions)).getValue() != entry.getPermissions().getValue()) {
                throw new CmdFailure("permissions: is '" + entry.getPermissions().getValue() + "', but expected '" + objPermissions.getValue() + "'");
            }
            if (this.profiles != null) {
                if (this.profiles.size() == 1 && "null".equalsIgnoreCase(this.profiles.iterator().next())) {
                    this.profiles = Collections.emptySet();
                }
                if (!this.profiles.equals(entry.getProfiles())) {
                    throw new CmdFailure("profiles: is '" + entry.getProfiles() + "', but expected '" + this.profiles + "'");
                }
            }
            this.println(" checked CA requestor CA='" + this.caName + "', requestor='" + this.requestorName + "'");
            return null;
        }
    }

    @Command(scope="caqa", name="capub-check", description="check information of publishers in given CA (QA)")
    @Service
    public static class CapubCheck
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--publisher", required=true, description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        private String publisherName;

        protected Object execute0() throws Exception {
            this.println("checking CA publisher CA='" + this.caName + "', publisher='" + this.publisherName + "'");
            if (this.caManager.getCa(this.caName) == null) {
                throw new CmdFailure("could not find CA '" + this.caName + "'");
            }
            Set entries = this.getPublisherNamesForCa(this.caName);
            String upPublisherName = this.publisherName.toLowerCase();
            for (String m : entries) {
                if (!m.equals(upPublisherName)) continue;
                this.println(" checked CA publisher CA='" + this.caName + "', publisher='" + this.publisherName + "'");
                return null;
            }
            throw new CmdFailure("CA is not associated with publisher '" + this.publisherName + "'");
        }
    }

    @Command(scope="caqa", name="caprofile-check", description="check information of certificate profiles in given CA (QA)")
    @Service
    public static class CaprofileCheck
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--profile", required=true, description="profile name and aliases, <name>[:<\",\"-separated aliases>]")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private String profileNameAliases;

        protected Object execute0() throws Exception {
            this.println("checking CA profile CA='" + this.caName + "', profile='" + this.profileNameAliases + "'");
            if (this.caManager.getCa(this.caName) == null) {
                throw new CmdFailure("could not find CA '" + this.caName + "'");
            }
            CaProfileEntry expectedEntry = CaProfileEntry.decode((String)this.profileNameAliases);
            Set entries = this.caManager.getCertprofilesForCa(this.caName);
            CaProfileEntry receivedEntry = null;
            for (CaProfileEntry entry : entries) {
                if (!entry.getProfileName().equals(expectedEntry.getProfileName())) continue;
                receivedEntry = entry;
                break;
            }
            if (receivedEntry == null) {
                throw new CmdFailure("CA is not associated with profile '" + expectedEntry.getProfileName() + "'");
            }
            if (!expectedEntry.equals(receivedEntry)) {
                throw new CmdFailure("CA-Profile unmatch, expected=" + expectedEntry + ", but received=" + receivedEntry);
            }
            this.println(" checked CA profile CA='" + this.caName + "', profile='" + this.profileNameAliases + "'");
            return null;
        }
    }

    @Command(scope="caqa", name="ca-check", description="check information of CAs (QA)")
    @Service
    public static class CaCheck
    extends CaActions.CaUp {
        protected Object execute0() throws Exception {
            ChangeCaEntry ey = this.getChangeCaEntry();
            String caName = ey.getIdent().getName();
            this.println("checking CA " + caName);
            CaEntry ca = Optional.ofNullable(this.caManager.getCa(caName)).orElseThrow(() -> new CmdFailure("could not find CA '" + caName + "'"));
            CaUris eyUris = ey.getCaUris();
            if (eyUris != null) {
                QaCaActions.assertObjEquals("CA URIs", ey.getCaUris(), ca.getCaUris());
            }
            if (ey.getEncodedCert() != null && !QaCaActions.certEquals(ey.getEncodedCert(), ca.getCert().getEncoded())) {
                throw new CmdFailure("CA cert is not as expected");
            }
            if (ey.getEncodedCertchain() != null) {
                int isSize;
                List eyList = ey.getEncodedCertchain();
                List isList = ca.getCertchain();
                int eySize = eyList == null ? 0 : eyList.size();
                int n = isSize = isList == null ? 0 : isList.size();
                if (eySize != isSize) {
                    if (CollectionUtil.isNotEmpty((Collection)ca.getCertchain())) {
                        throw new CmdFailure("Length of CA certchain " + isSize + " is not as expected " + eySize);
                    }
                } else if (eySize != 0) {
                    for (int i = 0; i < eySize; ++i) {
                        if (QaCaActions.certEquals((byte[])eyList.get(i), ((X509Cert)isList.get(i)).getEncoded())) continue;
                        throw new CmdFailure("CA cert chain[" + i + "] is not as expected");
                    }
                }
            }
            if (ey.getSerialNoLen() != null) {
                QaCaActions.assertObjEquals("serial number length", ey.getSerialNoLen(), ca.getSnSize());
            }
            if (ey.getCrlControl() != null) {
                QaCaActions.assertObjEquals("CRL control", new CrlControl(ey.getCrlControl()), ca.getCrlControl());
            }
            if (ey.getCrlSignerName() != null) {
                QaCaActions.assertEquals("CRL signer name", ey.getCrlSignerName(), ca.getCrlSignerName());
            }
            if (ey.getExpirationPeriod() != null) {
                QaCaActions.assertObjEquals("Expiration period", ey.getExpirationPeriod(), ca.getExpirationPeriod());
            }
            if (ey.getExtraControl() != null) {
                QaCaActions.assertObjEquals("Extra control", ey.getExtraControl(), ca.getExtraControl());
            }
            if (ey.getMaxValidity() != null) {
                QaCaActions.assertObjEquals("Max validity", ey.getMaxValidity(), ca.getMaxValidity());
            }
            if (ey.getKeepExpiredCertDays() != null) {
                QaCaActions.assertObjEquals("keepExpiredCertDays", ey.getKeepExpiredCertDays(), ca.getKeepExpiredCertDays());
            }
            if (ey.getNumCrls() != null) {
                QaCaActions.assertObjEquals("num CRLs", ey.getNumCrls(), ca.getNumCrls());
            }
            if (ey.getPermission() != null) {
                QaCaActions.assertObjEquals("permission", new Permissions((Collection)ey.getPermission()), ca.getPermissions());
            }
            if (ey.getSignerType() != null) {
                QaCaActions.assertTypeEquals("signer type", ey.getSignerType(), ca.getSignerType());
            }
            if (ey.getSignerConf() != null) {
                ConfPairs ex = new ConfPairs(ey.getSignerConf());
                ex.removePair("keystore");
                ConfPairs is = new ConfPairs(ca.getSignerConf());
                is.removePair("keystore");
                QaCaActions.assertObjEquals("signer conf", ex, is);
            }
            if (ey.getStatus() != null) {
                QaCaActions.assertObjEquals("status", ey.getStatus(), ca.getStatus());
            }
            if (ey.getValidityMode() != null) {
                QaCaActions.assertObjEquals("validity mode", ey.getValidityMode(), ca.getValidityMode());
            }
            this.println(" checked CA" + caName);
            return null;
        }
    }

    @Command(scope="xiqa", name="benchmark-enroll", description="Enroll certificate (benchmark)")
    @Service
    public static class BenchmarkEnroll
    extends AbstractBenchmarkEnroll {
        @Completion(value=StringsCompleter.class, values={"RSA", "EC", "DSA"})
        @Option(name="--key-type", description="key type to be requested")
        private String keyType = "RSA";
        @Option(name="--key-size", description="modulus length of RSA key or p length of DSA key")
        private Integer keysize = 2048;
        @Option(name="--curve", description="EC curve name or OID of EC key")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName;
        @Option(name="--new-key", description="Generate different keypair for each certificate")
        private boolean newKey = false;

        protected Object execute0() throws Exception {
            CaEnrollBenchKeyEntry.ECKeyEntry keyEntry;
            if (this.numThreads < 1) {
                throw new IllegalCmdParamException("invalid number of threads " + this.numThreads);
            }
            if ("EC".equalsIgnoreCase(this.keyType) && StringUtil.isBlank((String)this.curveName)) {
                throw new IllegalCmdParamException("curveName is not specified");
            }
            String description = StringUtil.concatObjectsCap((int)200, (Object)"subjectTemplate: ", (Object[])new Object[]{this.subjectTemplate, "\nprofile: ", this.certprofile, "\nkeyType: ", this.keyType, "\nmaxRequests: ", this.maxRequests});
            CaEnrollBenchEntry.RandomDn randomDn = null;
            if (this.randomDnStr != null) {
                randomDn = Optional.ofNullable(CaEnrollBenchEntry.RandomDn.getInstance((String)this.randomDnStr)).orElseThrow(() -> new IllegalCmdParamException("invalid randomDn " + this.randomDnStr));
            }
            if ("EC".equalsIgnoreCase(this.keyType)) {
                ASN1ObjectIdentifier curveOid = EdECConstants.getCurveOid((String)this.curveName);
                if (curveOid == null) {
                    curveOid = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)this.curveName);
                }
                keyEntry = new CaEnrollBenchKeyEntry.ECKeyEntry(curveOid, !this.newKey);
            } else if ("RSA".equalsIgnoreCase(this.keyType)) {
                keyEntry = new CaEnrollBenchKeyEntry.RSAKeyEntry(this.keysize.intValue(), !this.newKey);
            } else if ("DSA".equalsIgnoreCase(this.keyType)) {
                keyEntry = new CaEnrollBenchKeyEntry.DSAKeyEntry(this.keysize.intValue(), !this.newKey);
            } else {
                throw new IllegalCmdParamException("invalid keyType " + this.keyType);
            }
            CaEnrollBenchEntry benchmarkEntry = new CaEnrollBenchEntry(this.certprofile, (CaEnrollBenchKeyEntry)keyEntry, this.subjectTemplate, randomDn);
            CaEnrollBenchmark benchmark = new CaEnrollBenchmark(this.caName, benchmarkEntry, this.maxRequests.intValue(), this.num.intValue(), description);
            benchmark.setDuration(this.duration).setThreads(this.numThreads.intValue()).execute();
            return null;
        }
    }

    @Command(scope="xiqa", name="benchmark-enroll-serverkeygen", description="Enroll certificate (CA generates keypairs, benchmark)")
    @Service
    public static class BenchmarkCaGenEnroll
    extends AbstractBenchmarkEnroll {
        protected Object execute0() throws Exception {
            if (this.numThreads < 1) {
                throw new IllegalCmdParamException("invalid number of threads " + this.numThreads);
            }
            String description = StringUtil.concatObjectsCap((int)200, (Object)"subjectTemplate: ", (Object[])new Object[]{this.subjectTemplate, "\nprofile: ", this.certprofile, "\nmaxRequests: ", this.maxRequests});
            CaEnrollBenchEntry.RandomDn randomDn = null;
            if (this.randomDnStr != null) {
                randomDn = Optional.ofNullable(CaEnrollBenchEntry.RandomDn.getInstance((String)this.randomDnStr)).orElseThrow(() -> new IllegalCmdParamException("invalid randomDn " + this.randomDnStr));
            }
            CaEnrollBenchEntry benchmarkEntry = new CaEnrollBenchEntry(this.certprofile, null, this.subjectTemplate, randomDn);
            CaEnrollBenchmark benchmark = new CaEnrollBenchmark(this.caName, benchmarkEntry, this.maxRequests.intValue(), this.num.intValue(), description);
            benchmark.setDuration(this.duration).setThreads(this.numThreads.intValue()).execute();
            return null;
        }
    }

    private static abstract class AbstractBenchmarkEnroll
    extends XiAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        protected String caName;
        @Option(name="--profile", aliases={"-p"}, required=true, description="certificate profile that allows duplication of public key")
        protected String certprofile;
        @Option(name="--subject", aliases={"-s"}, required=true, description="subject template")
        protected String subjectTemplate;
        @Option(name="--random-dn", description="DN name to be incremented")
        @Completion(value=StringsCompleter.class, values={"GIVENNAME", "SURNAME", "STREET", "POSTALCODE", "O", "OU", "CN"})
        protected String randomDnStr = "O";
        @Option(name="--duration", description="duration")
        protected String duration = "30s";
        @Option(name="--thread", description="number of threads")
        protected Integer numThreads = 5;
        @Option(name="-n", description="number of certificates to be requested in one request")
        protected Integer num = 1;
        @Option(name="--max-num", description="maximal number of requests\n0 for unlimited")
        protected Integer maxRequests = 0;

        private AbstractBenchmarkEnroll() {
        }
    }

    @Command(scope="caqa", name="caalias-check", description="check CA aliases (QA)")
    @Service
    public static class CaAliasCheck
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--alias", required=true, description="alias name")
        private String aliasName;

        protected Object execute0() throws Exception {
            this.println("checking CA alias='" + this.aliasName + "', CA='" + this.caName + "'");
            String tmpCaName = Optional.ofNullable(this.caManager.getCaNameForAlias(this.aliasName)).orElseThrow(() -> new CmdFailure("alias '" + this.aliasName + "' is not configured"));
            QaCaActions.assertEquals("CA name", this.caName, tmpCaName);
            this.println(" checked CA alias='" + this.aliasName + "', CA='" + this.caName + "'");
            return null;
        }
    }

    @Command(scope="caqa", name="check-cert", description="check the certificate")
    @Service
    public static class CheckCert
    extends XiAction {
        @Option(name="--cert", aliases={"-c"}, required=true, description="certificate file")
        @Completion(value=FileCompleter.class)
        private String certFile;
        @Option(name="--issuer", description="issuer name\n(required if multiple issuers are configured)")
        @Completion(value=QaCompleters.IssuerNameCompleter.class)
        private String issuerName;
        @Option(name="--csr", required=true, description="CSR file")
        @Completion(value=FileCompleter.class)
        private String csrFile;
        @Option(name="--profile", aliases={"-p"}, required=true, description="certificate profile")
        @Completion(value=QaCompleters.CertprofileNameCompleter.class)
        private String profileName;
        @Option(name="--verbose", aliases={"-v"}, description="show status verbosely")
        private Boolean verbose = Boolean.FALSE;
        @Reference
        private CaQaSystemManager qaSystemManager;

        protected Object execute0() throws Exception {
            Set issuerNames = this.qaSystemManager.getIssuerNames();
            if (CheckCert.isEmpty((Collection)issuerNames)) {
                throw new IllegalCmdParamException("no issuer is configured");
            }
            if (this.issuerName == null) {
                if (issuerNames.size() != 1) {
                    throw new IllegalCmdParamException("no issuer is specified");
                }
                this.issuerName = (String)issuerNames.iterator().next();
            }
            if (!issuerNames.contains(this.issuerName)) {
                throw new IllegalCmdParamException("issuer " + this.issuerName + " is not within the configured issuers " + issuerNames);
            }
            IssuerInfo issuerInfo = this.qaSystemManager.getIssuer(this.issuerName);
            CertprofileQa qa = Optional.ofNullable(this.qaSystemManager.getCertprofile(this.profileName)).orElseThrow(() -> new IllegalCmdParamException("found no certificate profile named '" + this.profileName + "'"));
            CertificationRequest csr = X509Util.parseCsr((File)new File(this.csrFile));
            Extensions extensions = null;
            CertificationRequestInfo reqInfo = csr.getCertificationRequestInfo();
            ASN1Set attrs = reqInfo.getAttributes();
            for (int i = 0; i < attrs.size(); ++i) {
                Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(i));
                if (!PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((ASN1Primitive)attr.getAttrType())) continue;
                extensions = Extensions.getInstance((Object)attr.getAttributeValues()[0]);
            }
            byte[] certBytes = IoUtil.read((String)this.certFile);
            ValidationResult result = qa.checkCert(certBytes, issuerInfo, reqInfo.getSubject(), reqInfo.getSubjectPublicKeyInfo(), extensions);
            StringBuilder sb = new StringBuilder();
            sb.append(this.certFile).append(" (certprofile ").append(this.profileName).append(")\n");
            sb.append("\tcertificate is ");
            sb.append(result.isAllSuccessful() ? "valid" : "invalid");
            if (this.verbose.booleanValue()) {
                for (ValidationIssue issue : result.getValidationIssues()) {
                    sb.append("\n");
                    CheckCert.format(issue, "    ", sb);
                }
            } else {
                for (ValidationIssue issue : result.getValidationIssues()) {
                    if (!issue.isFailed()) continue;
                    sb.append("\n");
                    CheckCert.format(issue, "    ", sb);
                }
            }
            this.println(sb.toString());
            if (!result.isAllSuccessful()) {
                throw new CmdFailure("certificate is invalid");
            }
            return null;
        }

        private static void format(ValidationIssue issue, String prefix, StringBuilder sb) {
            sb.append(prefix).append(issue.getCode());
            sb.append(", ").append(issue.getDescription());
            sb.append(", ").append(issue.isFailed() ? "failed" : "successful");
            if (issue.getFailureMessage() != null) {
                sb.append(", ").append(issue.getFailureMessage());
            }
        }
    }

    @Command(scope="caqa", name="init", description="initialize the CA QA manager")
    @Service
    public static class Init
    extends XiAction {
        @Reference
        private CaQaSystemManager qaSystemManager;

        protected Object execute0() throws Exception {
            if (this.qaSystemManager.init()) {
                this.println("CA QA system initialized successfully");
            } else {
                this.println("CA QA system initialization failed");
            }
            return null;
        }
    }
}

