/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.isismtt.x509.AdmissionSyntax;
import org.bouncycastle.asn1.isismtt.x509.Admissions;
import org.bouncycastle.asn1.isismtt.x509.ProfessionInfo;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.xipki.security.BadInputException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs12.KeystoreGenerationParameters;
import org.xipki.security.pkcs12.P12KeyGenerationResult;
import org.xipki.security.pkcs12.P12KeyGenerator;
import org.xipki.security.shell.Actions;
import org.xipki.security.shell.SecurityCompleters;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;
import org.xipki.util.ObjectCreationException;

public class P12Actions {

    @Command(scope="xi", name="sm2-p12", description="generate SM2 (curve sm2p256v1) keypair in PKCS#12 keystore")
    @Service
    public static class Sm2P12
    extends P12KeyGenAction {
        @Option(name="--subject", aliases={"-s"}, description="subject of the self-signed certificate")
        protected String subject;

        protected Object execute0() throws Exception {
            P12KeyGenerationResult keypair = new P12KeyGenerator().generateECKeypair(GMObjectIdentifiers.sm2p256v1.getId(), this.getKeyGenParameters(), this.subject);
            this.saveKey(keypair);
            return null;
        }
    }

    public static abstract class P12SecurityAction
    extends Actions.SecurityAction {
        @Option(name="--p12", required=true, description="PKCS#12 keystore file")
        @Completion(value=FileCompleter.class)
        protected String p12File;
        @Option(name="--password", description="password of the PKCS#12 file")
        protected String password;

        protected char[] getPassword() throws IOException {
            char[] pwdInChar = this.readPasswordIfNotSet(this.password);
            if (pwdInChar != null) {
                this.password = new String(pwdInChar);
            }
            return pwdInChar;
        }

        protected KeyStore getKeyStore() throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, NoSuchProviderException {
            KeyStore ks;
            try (InputStream in = Files.newInputStream(Paths.get(P12SecurityAction.expandFilepath((String)this.p12File), new String[0]), new OpenOption[0]);){
                ks = KeyUtil.getKeyStore((String)"PKCS12");
                ks.load(in, this.getPassword());
            }
            return ks;
        }
    }

    @Command(scope="xi", name="rsa-p12", description="generate RSA keypair in PKCS#12 keystore")
    @Service
    public static class RsaP12
    extends P12KeyGenAction {
        @Option(name="--subject", aliases={"-s"}, description="subject of the self-signed certificate")
        private String subject;
        @Option(name="--key-size", description="keysize in bit")
        private Integer keysize = 2048;
        @Option(name="-e", description="public exponent")
        private String publicExponent = "0x10001";

        protected Object execute0() throws Exception {
            if (this.keysize % 1024 != 0) {
                throw new IllegalCmdParamException("keysize is not multiple of 1024: " + this.keysize);
            }
            P12KeyGenerationResult keypair = new P12KeyGenerator().generateRSAKeypair(this.keysize.intValue(), RsaP12.toBigInt((String)this.publicExponent), this.getKeyGenParameters(), this.subject);
            this.saveKey(keypair);
            return null;
        }
    }

    public static abstract class P12KeyGenAction
    extends Actions.SecurityAction {
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the key")
        @Completion(value=FileCompleter.class)
        protected String keyOutFile;
        @Option(name="--password", description="password of the keystore file")
        protected String password;

        protected void saveKey(P12KeyGenerationResult keyGenerationResult) throws IOException {
            Args.notNull((Object)keyGenerationResult, (String)"keyGenerationResult");
            this.saveVerbose("saved PKCS#12 keystore to file", this.keyOutFile, keyGenerationResult.keystore());
        }

        protected KeystoreGenerationParameters getKeyGenParameters() throws IOException {
            KeystoreGenerationParameters params = new KeystoreGenerationParameters(this.getPassword());
            SecureRandom random = this.securityFactory.getRandom4Key();
            if (random != null) {
                params.setRandom(random);
            }
            return params;
        }

        private char[] getPassword() throws IOException {
            char[] pwdInChar = this.readPasswordIfNotSet(this.password);
            if (pwdInChar != null) {
                this.password = new String(pwdInChar);
            }
            return pwdInChar;
        }
    }

    @Command(scope="xi", name="ec-p12", description="generate EC keypair in PKCS#12 keystore")
    @Service
    public static class EcP12
    extends P12KeyGenAction {
        @Option(name="--subject", aliases={"-s"}, description="subject of the self-signed certificate")
        protected String subject;
        @Option(name="--curve", description="EC curve name or OID")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName = "secp256r1";

        protected Object execute0() throws Exception {
            P12KeyGenerationResult keypair = new P12KeyGenerator().generateECKeypair(this.curveName, this.getKeyGenParameters(), this.subject);
            this.saveKey(keypair);
            return null;
        }
    }

    @Command(scope="xi", name="dsa-p12", description="generate RSA keypair in PKCS#12 keystore")
    @Service
    public static class DsaP12
    extends P12KeyGenAction {
        @Option(name="--subject", aliases={"-s"}, description="subject of the self-signed certificate")
        private String subject;
        @Option(name="--plen", description="bit length of the prime")
        private Integer plen = 2048;
        @Option(name="--qlen", description="bit length of the sub-prime")
        private Integer qlen;

        protected Object execute0() throws Exception {
            if (this.plen % 1024 != 0) {
                throw new IllegalCmdParamException("plen is not multiple of 1024: " + this.plen);
            }
            if (this.qlen == null) {
                this.qlen = this.plen <= 1024 ? Integer.valueOf(160) : (this.plen <= 2048 ? Integer.valueOf(224) : Integer.valueOf(256));
            }
            P12KeyGenerationResult keypair = new P12KeyGenerator().generateDSAKeypair(this.plen.intValue(), this.qlen.intValue(), this.getKeyGenParameters(), this.subject);
            this.saveKey(keypair);
            return null;
        }
    }

    @Command(scope="xi", name="csr-p12", description="generate CSR with PKCS#12 keystore")
    @Service
    public static class CsrP12
    extends Actions.CsrGenAction {
        @Option(name="--p12", required=true, description="PKCS#12 keystore file")
        @Completion(value=FileCompleter.class)
        private String p12File;
        @Option(name="--password", description="password of the PKCS#12 keystore file")
        private String password;

        private char[] getPassword() throws IOException {
            char[] pwdInChar = this.readPasswordIfNotSet(this.password);
            if (pwdInChar != null) {
                this.password = new String(pwdInChar);
            }
            return pwdInChar;
        }

        public KeyStore getKeyStore() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
            KeyStore ks;
            try (InputStream in = Files.newInputStream(Paths.get(CsrP12.expandFilepath((String)this.p12File), new String[0]), new OpenOption[0]);){
                ks = KeyUtil.getKeyStore((String)"PKCS12");
                ks.load(in, this.getPassword());
            }
            return ks;
        }

        @Override
        protected ConcurrentContentSigner getSigner(SignatureAlgoControl signatureAlgoControl) throws ObjectCreationException {
            char[] pwd;
            Args.notNull((Object)signatureAlgoControl, (String)"signatureAlgoControl");
            try {
                pwd = this.getPassword();
            }
            catch (IOException ex) {
                throw new ObjectCreationException("could not read password: " + ex.getMessage(), (Throwable)ex);
            }
            SignerConf conf = CsrP12.getKeystoreSignerConf(this.p12File, new String(pwd), HashAlgo.getNonNullInstance((String)this.hashAlgo), signatureAlgoControl);
            return this.securityFactory.createSigner("PKCS12", conf, (X509Certificate[])null);
        }

        static SignerConf getKeystoreSignerConf(String keystoreFile, String password, HashAlgo hashAlgo, SignatureAlgoControl signatureAlgoControl) {
            ConfPairs conf = new ConfPairs("password", password);
            conf.putPair("parallelism", Integer.toString(1));
            conf.putPair("keystore", "file:" + keystoreFile);
            return new SignerConf(conf.getEncoded(), hashAlgo, signatureAlgoControl);
        }
    }

    @Command(scope="xi", name="csr-p12-complex", description="generate complex CSR with PKCS#12 keystore (only for test)")
    @Service
    public static class CsrP12Complex
    extends Actions.CsrGenAction {
        @Option(name="--p12", required=true, description="PKCS#12 keystore file")
        @Completion(value=FileCompleter.class)
        private String p12File;
        @Option(name="--password", description="password of the PKCS#12 keystore file")
        private String password;
        @Option(name="--complex-subject", description="whether complex subject should be used")
        private Boolean complexSubject = Boolean.FALSE;

        private char[] getPassword() throws IOException {
            char[] pwdInChar = this.readPasswordIfNotSet(this.password);
            if (pwdInChar != null) {
                this.password = new String(pwdInChar);
            }
            return pwdInChar;
        }

        public KeyStore getKeyStore() throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
            KeyStore ks;
            try (InputStream in = Files.newInputStream(Paths.get(CsrP12Complex.expandFilepath((String)this.p12File), new String[0]), new OpenOption[0]);){
                ks = KeyUtil.getKeyStore((String)"PKCS12");
                ks.load(in, this.getPassword());
            }
            return ks;
        }

        @Override
        protected ConcurrentContentSigner getSigner(SignatureAlgoControl signatureAlgoControl) throws ObjectCreationException {
            char[] pwd;
            Args.notNull((Object)signatureAlgoControl, (String)"signatureAlgoControl");
            try {
                pwd = this.getPassword();
            }
            catch (IOException ex) {
                throw new ObjectCreationException("could not read password: " + ex.getMessage(), (Throwable)ex);
            }
            SignerConf signerConf = CsrP12.getKeystoreSignerConf(this.p12File, new String(pwd), HashAlgo.getNonNullInstance((String)this.hashAlgo), signatureAlgoControl);
            return this.securityFactory.createSigner("PKCS12", signerConf, (X509Certificate[])null);
        }

        @Override
        protected X500Name getSubject(String subject) {
            RDN rdn;
            ASN1ObjectIdentifier id;
            RDN[] rdns;
            RDN[] rs;
            X500Name name = new X500Name(subject);
            LinkedList<RDN> list = new LinkedList<RDN>();
            for (RDN m : rs = name.getRDNs()) {
                list.add(m);
            }
            if (this.complexSubject.booleanValue() && ((rdns = name.getRDNs(id = ObjectIdentifiers.DN.dateOfBirth)) == null || rdns.length == 0)) {
                DERGeneralizedTime atvValue = new DERGeneralizedTime("19950102120000Z");
                rdn = new RDN(id, (ASN1Encodable)atvValue);
                list.add(rdn);
            }
            if (this.complexSubject.booleanValue() && ((rdns = name.getRDNs(id = ObjectIdentifiers.DN.postalAddress)) == null || rdns.length == 0)) {
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)new DERUTF8String("my street 1"));
                vec.add((ASN1Encodable)new DERUTF8String("12345 Germany"));
                DERSequence atvValue = new DERSequence(vec);
                RDN rdn2 = new RDN(id, (ASN1Encodable)atvValue);
                list.add(rdn2);
            }
            if ((rdns = name.getRDNs(id = ObjectIdentifiers.DN.uniqueIdentifier)) == null || rdns.length == 0) {
                DERUTF8String atvValue = new DERUTF8String("abc-def-ghi");
                rdn = new RDN(id, (ASN1Encodable)atvValue);
                list.add(rdn);
            }
            return new X500Name(list.toArray(new RDN[0]));
        }

        @Override
        protected ASN1OctetString createExtnValueSubjectAltName() throws BadInputException {
            if (!CsrP12Complex.isEmpty((Collection)this.subjectAltNames)) {
                throw new BadInputException("subjectAltNames must be null");
            }
            GeneralNames names = CsrP12Complex.createComplexGeneralNames("SAN-");
            try {
                return new DEROctetString((ASN1Encodable)names);
            }
            catch (IOException ex) {
                throw new BadInputException(ex.getMessage(), (Throwable)ex);
            }
        }

        @Override
        protected ASN1OctetString createExtnValueSubjectInfoAccess() throws BadInputException {
            if (!CsrP12Complex.isEmpty((Collection)this.subjectInfoAccesses)) {
                throw new BadInputException("subjectInfoAccess must be null");
            }
            ASN1EncodableVector vec = new ASN1EncodableVector();
            GeneralName[] names = CsrP12Complex.createComplexGeneralNames("SIA-").getNames();
            ASN1EncodableVector vec2 = new ASN1EncodableVector();
            vec2.add((ASN1Encodable)ObjectIdentifiers.Extn.id_ad_caRepository);
            vec2.add((ASN1Encodable)names[0]);
            vec.add((ASN1Encodable)new DERSequence(vec2));
            for (int i = 1; i < names.length; ++i) {
                vec2 = new ASN1EncodableVector();
                vec2.add((ASN1Encodable)new ASN1ObjectIdentifier("2.3.4." + i));
                vec2.add((ASN1Encodable)names[i]);
                vec.add((ASN1Encodable)new DERSequence(vec2));
            }
            try {
                return new DEROctetString((ASN1Encodable)new DERSequence(vec));
            }
            catch (IOException ex) {
                throw new BadInputException(ex.getMessage(), (Throwable)ex);
            }
        }

        private static GeneralNames createComplexGeneralNames(String prefix) {
            LinkedList<GeneralName> list = new LinkedList<GeneralName>();
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.3.1"));
            vec.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(prefix + "I am otherName 1.2.3.1")));
            list.add(new GeneralName(0, (ASN1Encodable)new DERSequence(vec)));
            vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.3.2"));
            vec.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(prefix + "I am otherName 1.2.3.2")));
            list.add(new GeneralName(0, (ASN1Encodable)new DERSequence(vec)));
            list.add(new GeneralName(1, prefix + "info@example.org"));
            list.add(new GeneralName(2, prefix + "dns.example.org"));
            list.add(new GeneralName(4, (ASN1Encodable)new X500Name("CN=demo,C=DE")));
            vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DirectoryString(prefix + "assigner1")));
            vec.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DirectoryString(prefix + "party1")));
            list.add(new GeneralName(5, (ASN1Encodable)new DERSequence(vec)));
            list.add(new GeneralName(6, prefix + "uri.example.org"));
            list.add(new GeneralName(7, "69.1.2.190"));
            list.add(new GeneralName(8, "2.3.4.5"));
            return new GeneralNames(list.toArray(new GeneralName[0]));
        }

        @Override
        protected List<Extension> getAdditionalExtensions() throws BadInputException {
            String[] countryOfResidenceList;
            String[] countryOfCitizenshipList;
            LinkedList<Extension> extensions = new LinkedList<Extension>();
            ASN1EncodableVector vec = new ASN1EncodableVector();
            DirectoryString[] dummyItems = new DirectoryString[]{new DirectoryString("dummy")};
            ProfessionInfo pi = new ProfessionInfo(null, dummyItems, null, "aaaab", null);
            Admissions admissions = new Admissions(null, null, new ProfessionInfo[]{pi});
            vec.add((ASN1Encodable)admissions);
            AdmissionSyntax adSyn = new AdmissionSyntax(null, (ASN1Sequence)new DERSequence(vec));
            try {
                extensions.add(new Extension(ObjectIdentifiers.Extn.id_extension_admission, false, adSyn.getEncoded()));
            }
            catch (IOException ex) {
                throw new BadInputException(ex.getMessage(), (Throwable)ex);
            }
            Vector<Attribute> attrs = new Vector<Attribute>();
            ASN1GeneralizedTime dateOfBirth = new ASN1GeneralizedTime("19800122120000Z");
            attrs.add(new Attribute(ObjectIdentifiers.DN.dateOfBirth, (ASN1Set)new DERSet((ASN1Encodable)dateOfBirth)));
            DERPrintableString gender = new DERPrintableString("M");
            attrs.add(new Attribute(ObjectIdentifiers.DN.gender, (ASN1Set)new DERSet((ASN1Encodable)gender)));
            DERUTF8String placeOfBirth = new DERUTF8String("Berlin");
            attrs.add(new Attribute(ObjectIdentifiers.DN.placeOfBirth, (ASN1Set)new DERSet((ASN1Encodable)placeOfBirth)));
            for (String country : countryOfCitizenshipList = new String[]{"DE", "FR"}) {
                DERPrintableString val = new DERPrintableString(country);
                attrs.add(new Attribute(ObjectIdentifiers.DN.countryOfCitizenship, (ASN1Set)new DERSet((ASN1Encodable)val)));
            }
            for (String country : countryOfResidenceList = new String[]{"DE"}) {
                DERPrintableString val = new DERPrintableString(country);
                attrs.add(new Attribute(ObjectIdentifiers.DN.countryOfResidence, (ASN1Set)new DERSet((ASN1Encodable)val)));
            }
            SubjectDirectoryAttributes subjectDirAttrs = new SubjectDirectoryAttributes(attrs);
            try {
                extensions.add(new Extension(Extension.subjectDirectoryAttributes, false, subjectDirAttrs.getEncoded()));
            }
            catch (IOException ex) {
                throw new BadInputException(ex.getMessage(), (Throwable)ex);
            }
            return extensions;
        }
    }

    @Command(scope="xi", name="update-cert-p12", description="update certificate in PKCS#12 keystore")
    @Service
    public static class UpdateCertP12
    extends P12SecurityAction {
        @Option(name="--cert", required=true, description="certificate file")
        @Completion(value=FileCompleter.class)
        private String certFile;
        @Option(name="--ca-cert", multiValued=true, description="CA Certificate file")
        @Completion(value=FileCompleter.class)
        private Set<String> caCertFiles;

        protected Object execute0() throws Exception {
            KeyStore ks = this.getKeyStore();
            char[] pwd = this.getPassword();
            X509Certificate newCert = X509Util.parseCert((File)new File(this.certFile));
            this.assertMatch(newCert, new String(pwd));
            String keyname = null;
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!ks.isKeyEntry(alias)) continue;
                keyname = alias;
                break;
            }
            if (keyname == null) {
                throw new XiSecurityException("could not find private key");
            }
            Key key = ks.getKey(keyname, pwd);
            HashSet<X509Certificate> caCerts = new HashSet<X509Certificate>();
            if (UpdateCertP12.isNotEmpty(this.caCertFiles)) {
                for (String caCertFile : this.caCertFiles) {
                    caCerts.add(X509Util.parseCert((File)new File(caCertFile)));
                }
            }
            Certificate[] certChain = X509Util.buildCertPath((X509Certificate)newCert, caCerts);
            ks.setKeyEntry(keyname, key, pwd, certChain);
            try (OutputStream out = Files.newOutputStream(Paths.get(this.p12File, new String[0]), new OpenOption[0]);){
                ks.store(out, pwd);
                this.println("updated certificate");
                Object var11_11 = null;
                return var11_11;
            }
        }

        private void assertMatch(X509Certificate cert, String password) throws ObjectCreationException {
            ConfPairs pairs = new ConfPairs("keystore", "file:" + this.p12File);
            if (password != null) {
                pairs.putPair("password", new String(password));
            }
            SignerConf conf = new SignerConf(pairs.getEncoded(), HashAlgo.SHA256, null);
            this.securityFactory.createSigner("PKCS12", conf, cert);
        }
    }

    @Command(scope="xi", name="export-cert-p12", description="export certificate from PKCS#12 keystore")
    @Service
    public static class ExportCertP12
    extends P12SecurityAction {
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outFile;

        protected Object execute0() throws Exception {
            KeyStore ks = this.getKeyStore();
            String keyname = null;
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!ks.isKeyEntry(alias)) continue;
                keyname = alias;
                break;
            }
            if (keyname == null) {
                throw new CmdFailure("could not find private key");
            }
            X509Certificate cert = (X509Certificate)ks.getCertificate(keyname);
            this.saveVerbose("saved certificate to file", this.outFile, ExportCertP12.encodeCert((byte[])cert.getEncoded(), (String)this.outform));
            return null;
        }
    }

    @Command(scope="xi", name="secretkey-p12", description="generate secret key in JCEKS (not PKCS#12) keystore")
    @Service
    public static class SecretkeyP12
    extends P12KeyGenAction {
        @Option(name="--key-type", required=true, description="keytype, current only AES, DES3 and GENERIC are supported")
        @Completion(value=SecurityCompleters.SecretKeyTypeCompleter.class)
        private String keyType;
        @Option(name="--key-size", required=true, description="keysize in bit")
        private Integer keysize;

        protected Object execute0() throws Exception {
            if (!("AES".equalsIgnoreCase(this.keyType) || "DES3".equalsIgnoreCase(this.keyType) || "GENERIC".equalsIgnoreCase(this.keyType))) {
                throw new IllegalCmdParamException("invalid keyType " + this.keyType);
            }
            P12KeyGenerationResult key = new P12KeyGenerator().generateSecretKey(this.keyType.toUpperCase(), this.keysize.intValue(), this.getKeyGenParameters());
            this.saveKey(key);
            return null;
        }
    }
}

