/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.P11UnsupportedMechanismException;
import org.xipki.security.pkcs11.provider.XiSM2ParameterSpec;
import org.xipki.security.shell.Actions;
import org.xipki.security.shell.SecurityCompleters;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class P11Actions {

    @Command(scope="xi", name="token-info-p11", description="list objects in PKCS#11 device")
    @Service
    public static class TokenInfoP11
    extends Actions.SecurityAction {
        @Option(name="--verbose", aliases={"-v"}, description="show object information verbosely")
        private Boolean verbose = Boolean.FALSE;
        @Option(name="--module", description="name of the PKCS#11 module.")
        @Completion(value=SecurityCompleters.P11ModuleNameCompleter.class)
        private String moduleName = "default";
        @Option(name="--slot", description="slot index")
        private Integer slotIndex;
        @Reference(optional=true)
        protected P11CryptServiceFactory p11CryptServiceFactory;

        protected Object execute0() throws Exception {
            P11CryptService p11Service = this.p11CryptServiceFactory.getP11CryptService(this.moduleName);
            if (p11Service == null) {
                throw new IllegalCmdParamException("undefined module " + this.moduleName);
            }
            P11Module module = p11Service.getModule();
            this.println("module: " + this.moduleName);
            this.println(module.getDescription());
            List slots = module.getSlotIds();
            if (this.slotIndex == null) {
                this.output(slots);
                return null;
            }
            P11SlotIdentifier slotId = module.getSlotIdForIndex(this.slotIndex.intValue());
            P11Slot slot = module.getSlot(slotId);
            this.println("Details of slot");
            slot.showDetails((OutputStream)System.out, this.verbose.booleanValue());
            System.out.println();
            System.out.flush();
            return null;
        }

        private void output(List<P11SlotIdentifier> slots) {
            int n = slots.size();
            if (n == 0 || n == 1) {
                String numText = n == 0 ? "no" : "1";
                this.println(numText + " slot is configured");
            } else {
                this.println(n + " slots are configured");
            }
            for (P11SlotIdentifier slotId : slots) {
                this.println("\tslot[" + slotId.getIndex() + "]: " + slotId.getId());
            }
        }
    }

    @Command(scope="xi", name="sm2-p11", description="generate SM2 (curve sm2p256v1) keypair in PKCS#11 device")
    @Service
    public static class Sm2P11
    extends P11KeyGenAction {
        protected Object execute0() throws Exception {
            P11Slot slot = this.getSlot();
            P11IdentityId identityId = slot.generateSM2Keypair(this.getControl());
            this.finalize("SM2", identityId);
            return null;
        }
    }

    public static abstract class P11SecurityAction
    extends Actions.SecurityAction {
        protected static final String DEFAULT_P11MODULE_NAME = "default";
        @Option(name="--slot", required=true, description="slot index")
        protected Integer slotIndex;
        @Option(name="--module", description="name of the PKCS#11 module")
        @Completion(value=SecurityCompleters.P11ModuleNameCompleter.class)
        protected String moduleName = "default";
        @Reference(optional=true)
        protected P11CryptServiceFactory p11CryptServiceFactory;

        protected P11Slot getSlot() throws XiSecurityException, P11TokenException, IllegalCmdParamException {
            P11Module module = this.getP11Module(this.moduleName);
            P11SlotIdentifier slotId = module.getSlotIdForIndex(this.slotIndex.intValue());
            return module.getSlot(slotId);
        }

        protected P11Module getP11Module(String moduleName) throws XiSecurityException, P11TokenException, IllegalCmdParamException {
            P11CryptService p11Service = this.p11CryptServiceFactory.getP11CryptService(moduleName);
            if (p11Service == null) {
                throw new IllegalCmdParamException("undefined module " + moduleName);
            }
            return p11Service.getModule();
        }

        public P11ObjectIdentifier getObjectIdentifier(String hexId, String label) throws IllegalCmdParamException, XiSecurityException, P11TokenException {
            P11ObjectIdentifier objIdentifier;
            P11Slot slot = this.getSlot();
            if (hexId != null && label == null) {
                objIdentifier = slot.getObjectId(Hex.decode((String)hexId), null);
            } else if (hexId == null && label != null) {
                objIdentifier = slot.getObjectId(null, label);
            } else {
                throw new IllegalCmdParamException("exactly one of keyId or keyLabel should be specified");
            }
            return objIdentifier;
        }
    }

    @Command(scope="xi", name="import-secretkey-p11", description="import secret key with given value in PKCS#11 device")
    @Service
    public static class ImportSecretkeyP11
    extends P11KeyGenAction {
        @Option(name="--key-type", required=true, description="keytype, current only AES, DES3 and GENERIC are supported")
        @Completion(value=SecurityCompleters.SecretKeyTypeCompleter.class)
        private String keyType;
        @Option(name="--keystore", required=true, description="JCEKS keystore from which the key is imported")
        @Completion(value=FileCompleter.class)
        private String keyOutFile;
        @Option(name="--password", description="password of the keystore file")
        private String password;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            long p11KeyType;
            if ("AES".equalsIgnoreCase(this.keyType)) {
                p11KeyType = 31L;
            } else if ("DES3".equalsIgnoreCase(this.keyType)) {
                p11KeyType = 21L;
            } else if ("GENERIC".equalsIgnoreCase(this.keyType)) {
                p11KeyType = 16L;
            } else {
                throw new IllegalCmdParamException("invalid keyType " + this.keyType);
            }
            KeyStore ks = KeyStore.getInstance("JCEKS");
            char[] pwd = this.getPassword();
            try (InputStream ksStream = Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)this.keyOutFile), new String[0]), new OpenOption[0]);){
                ks.load(ksStream, pwd);
            }
            byte[] keyValue = null;
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                Key key;
                String alias = aliases.nextElement();
                if (!ks.isKeyEntry(alias) || !((key = ks.getKey(alias, pwd)) instanceof SecretKey)) continue;
                keyValue = ((SecretKey)key).getEncoded();
                break;
            }
            if (keyValue == null) {
                throw new IllegalCmdParamException("keystore does not contain secret key");
            }
            P11Slot slot = this.getSlot();
            P11ObjectIdentifier objId = slot.importSecretKey(p11KeyType, keyValue, this.getControl());
            this.println("imported " + this.keyType + " key " + objId);
            return null;
        }

        protected char[] getPassword() throws IOException {
            char[] pwdInChar = this.readPasswordIfNotSet(this.password);
            if (pwdInChar != null) {
                this.password = new String(pwdInChar);
            }
            return pwdInChar;
        }
    }

    @Command(scope="xi", name="secretkey-p11", description="generate secret key in PKCS#11 device")
    @Service
    public static class SecretkeyP11
    extends P11KeyGenAction {
        private static final Logger LOG = LoggerFactory.getLogger(SecretkeyP11.class);
        @Option(name="--key-type", required=true, description="keytype, current only AES, DES3 and GENERIC are supported")
        @Completion(value=SecurityCompleters.SecretKeyTypeCompleter.class)
        private String keyType;
        @Option(name="--key-size", required=true, description="keysize in bit")
        private Integer keysize;
        @Option(name="--extern-if-gen-unsupported", description="If set, if the generation mechanism is not supported by the PKCS#11 device, create in memory and then import it to the device")
        private Boolean createExternIfGenUnsupported = Boolean.FALSE;

        protected Object execute0() throws Exception {
            long p11KeyType;
            if (this.keysize % 8 != 0) {
                throw new IllegalCmdParamException("keysize is not multiple of 8: " + this.keysize);
            }
            if ("AES".equalsIgnoreCase(this.keyType)) {
                p11KeyType = 31L;
            } else if ("DES3".equalsIgnoreCase(this.keyType)) {
                p11KeyType = 21L;
            } else if ("GENERIC".equalsIgnoreCase(this.keyType)) {
                p11KeyType = 16L;
            } else {
                throw new IllegalCmdParamException("invalid keyType " + this.keyType);
            }
            P11Slot slot = this.getSlot();
            P11Slot.P11NewKeyControl control = this.getControl();
            P11IdentityId identityId = null;
            try {
                identityId = slot.generateSecretKey(p11KeyType, this.keysize.intValue(), control);
                this.finalize(this.keyType, identityId);
            }
            catch (P11UnsupportedMechanismException ex) {
                if (!this.createExternIfGenUnsupported.booleanValue()) {
                    throw ex;
                }
                String msgPrefix = "could not generate secret key ";
                if (control.getId() != null) {
                    msgPrefix = msgPrefix + "id=" + Hex.encode((byte[])control.getId());
                    if (control.getLabel() != null) {
                        msgPrefix = msgPrefix + " and ";
                    }
                }
                if (control.getLabel() != null) {
                    msgPrefix = msgPrefix + "label=" + control.getLabel();
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info(msgPrefix + ex.getMessage());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(msgPrefix, (Throwable)ex);
                }
                byte[] keyValue = new byte[this.keysize / 8];
                this.securityFactory.getRandom4Key().nextBytes(keyValue);
                P11ObjectIdentifier objId = slot.importSecretKey(p11KeyType, keyValue, control);
                Arrays.fill((byte[])keyValue, (byte)0);
                this.println("generated in memory and imported " + this.keyType + " key " + objId);
            }
            return null;
        }
    }

    @Command(scope="xi", name="rsa-p11", description="generate RSA keypair in PKCS#11 device")
    @Service
    public static class RsaP11
    extends P11KeyGenAction {
        @Option(name="--key-size", description="keysize in bit")
        private Integer keysize = 2048;
        @Option(name="-e", description="public exponent")
        private String publicExponent = "0x10001";

        protected Object execute0() throws Exception {
            if (this.keysize % 1024 != 0) {
                throw new IllegalCmdParamException("keysize is not multiple of 1024: " + this.keysize);
            }
            P11Slot slot = this.getSlot();
            P11IdentityId identityId = slot.generateRSAKeypair(this.keysize.intValue(), RsaP11.toBigInt((String)this.publicExponent), this.getControl());
            this.finalize("RSA", identityId);
            return null;
        }
    }

    @Command(scope="xi", name="refresh-p11", description="refresh PKCS#11 module")
    @Service
    public static class RefreshP11
    extends Actions.SecurityAction {
        @Option(name="--module", description="name of the PKCS#11 module.")
        @Completion(value=SecurityCompleters.P11ModuleNameCompleter.class)
        private String moduleName = "default";
        @Reference
        P11CryptServiceFactory p11CryptServiceFactory;

        protected Object execute0() throws Exception {
            P11CryptService p11Service = this.p11CryptServiceFactory.getP11CryptService(this.moduleName);
            if (p11Service == null) {
                throw new IllegalCmdParamException("undefined module " + this.moduleName);
            }
            p11Service.refresh();
            this.println("refreshed module " + this.moduleName);
            return null;
        }
    }

    @Command(scope="xi", name="p11prov-test", description="test the Xipki PKCS#11 JCA/JCE provider")
    @Service
    public static class P11provTest
    extends P11SecurityAction {
        @Option(name="--id", description="id of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String id;
        @Option(name="--label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String label;
        @Option(name="--verbose", aliases={"-v"}, description="show object information verbosely")
        private Boolean verbose = Boolean.FALSE;
        @Option(name="--hash", description="hash algorithm name")
        @Completion(value=Completers.HashAlgCompleter.class)
        protected String hashAlgo = "SHA256";
        @Option(name="--rsa-mgf1", description="whether to use the RSAPSS MGF1 for the POPO computation\n(only applied to RSA key)")
        private Boolean rsaMgf1 = Boolean.FALSE;
        @Option(name="--dsa-plain", description="whether to use the Plain DSA for the POPO computation\n(only applied to ECDSA key)")
        private Boolean dsaPlain = Boolean.FALSE;
        @Option(name="--gm", description="whether to use the chinese GM algorithm for the POPO computation\n(only applied to EC key with GM curves)")
        private Boolean gm = Boolean.FALSE;

        protected Object execute0() throws Exception {
            KeyStore ks = KeyStore.getInstance("PKCS11", "XIPKI");
            ks.load(null, null);
            if (this.verbose.booleanValue()) {
                this.println("available aliases:");
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias2 = aliases.nextElement();
                    this.println("    " + alias2);
                }
            }
            String alias = this.getAlias();
            this.println("alias: " + alias);
            PrivateKey key = (PrivateKey)ks.getKey(alias, null);
            if (key == null) {
                this.println("could not find key with alias '" + alias + "'");
                return null;
            }
            Certificate cert = ks.getCertificate(alias);
            if (cert == null) {
                this.println("could not find certificate to verify signature");
                return null;
            }
            PublicKey pubKey = cert.getPublicKey();
            String sigAlgo = this.getSignatureAlgo(pubKey);
            this.println("signature algorithm: " + sigAlgo);
            Signature sig = Signature.getInstance(sigAlgo, "XIPKI");
            sig.initSign(key);
            byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            sig.update(data);
            byte[] signature = sig.sign();
            this.println("signature created successfully");
            Signature ver = Signature.getInstance(sigAlgo, "BC");
            ver.initVerify(pubKey);
            ver.update(data);
            boolean valid = ver.verify(signature);
            this.println("signature valid: " + valid);
            return null;
        }

        private String getAlias() {
            if (this.label != null) {
                return StringUtil.concat((String)this.moduleName, (String[])new String[]{"#slotindex-", this.slotIndex.toString(), "#keylabel-", this.label});
            }
            return StringUtil.concat((String)this.moduleName, (String[])new String[]{"#slotindex-", this.slotIndex.toString(), "#keyid-", this.id.toLowerCase()});
        }

        private String getSignatureAlgo(PublicKey pubKey) throws NoSuchAlgorithmException {
            SignatureAlgoControl algoControl = new SignatureAlgoControl(this.rsaMgf1.booleanValue(), this.dsaPlain.booleanValue(), this.gm.booleanValue());
            AlgorithmIdentifier sigAlgId = AlgorithmUtil.getSigAlgId((PublicKey)pubKey, (HashAlgo)HashAlgo.getNonNullInstance((String)this.hashAlgo), (SignatureAlgoControl)algoControl);
            return AlgorithmUtil.getSignatureAlgoName((AlgorithmIdentifier)sigAlgId);
        }
    }

    @Command(scope="xi", name="p11prov-sm2-test", description="test the SM2 implementation of Xipki PKCS#11 JCA/JCE provider")
    @Service
    public static class P11provSm2Test
    extends P11SecurityAction {
        @Option(name="--id", description="id of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String id;
        @Option(name="--label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String label;
        @Option(name="--verbose", aliases={"-v"}, description="show object information verbosely")
        private Boolean verbose = Boolean.FALSE;
        @Option(name="--ida", description="IDA (ID user A)")
        protected String ida;

        protected Object execute0() throws Exception {
            KeyStore ks = KeyStore.getInstance("PKCS11", "XIPKI");
            ks.load(null, null);
            if (this.verbose.booleanValue()) {
                this.println("available aliases:");
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias2 = aliases.nextElement();
                    this.println("    " + alias2);
                }
            }
            String alias = this.getAlias();
            this.println("alias: " + alias);
            PrivateKey key = (PrivateKey)ks.getKey(alias, null);
            if (key == null) {
                this.println("could not find key with alias '" + alias + "'");
                return null;
            }
            Certificate cert = ks.getCertificate(alias);
            if (cert == null) {
                this.println("could not find certificate to verify signature");
                return null;
            }
            String sigAlgo = "SM3withSM2";
            this.println("signature algorithm: " + sigAlgo);
            Signature sig = Signature.getInstance(sigAlgo, "XIPKI");
            if (StringUtil.isNotBlank((String)this.ida)) {
                sig.setParameter((AlgorithmParameterSpec)new XiSM2ParameterSpec(StringUtil.toUtf8Bytes((String)this.ida)));
            }
            sig.initSign(key);
            byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            sig.update(data);
            byte[] signature = sig.sign();
            this.println("signature created successfully");
            Signature ver = Signature.getInstance(sigAlgo, "BC");
            if (StringUtil.isNotBlank((String)this.ida)) {
                ver.setParameter((AlgorithmParameterSpec)new SM2ParameterSpec(StringUtil.toUtf8Bytes((String)this.ida)));
            }
            ver.initVerify(cert.getPublicKey());
            ver.update(data);
            boolean valid = ver.verify(signature);
            this.println("signature valid: " + valid);
            return null;
        }

        private String getAlias() {
            if (this.label != null) {
                return StringUtil.concat((String)this.moduleName, (String[])new String[]{"#slotindex-", this.slotIndex.toString(), "#keylabel-", this.label});
            }
            return StringUtil.concat((String)this.moduleName, (String[])new String[]{"#slotindex-", this.slotIndex.toString(), "#keyid-", this.id.toLowerCase()});
        }
    }

    @Command(scope="xi", name="delete-objects-p11", description="delete objects in PKCS#11 device")
    @Service
    public static class DeleteObjectsP11
    extends P11SecurityAction {
        @Option(name="--id", description="id (hex) of the objects in the PKCS#11 device\nat least one of id and label must be specified")
        private String id;
        @Option(name="--label", description="label of the objects in the PKCS#11 device\nat least one of id and label must be specified")
        private String label;
        @Option(name="--force", aliases={"-f"}, description="remove identifies without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            if (this.force.booleanValue() || this.confirm("Do you want to remove the PKCS#11 objects (id = " + this.id + ", label = " + this.label + ")", 3)) {
                P11Slot slot = this.getSlot();
                byte[] idBytes = null;
                if (this.id != null) {
                    idBytes = Hex.decode((String)this.id);
                }
                int num = slot.removeObjects(idBytes, this.label);
                this.println("deleted " + num + " objects");
            }
            return null;
        }
    }

    public static abstract class P11KeyGenAction
    extends P11SecurityAction {
        @Option(name="--id", description="id of the PKCS#11 objects")
        private String hexId;
        @Option(name="--label", required=true, description="label of the PKCS#11 objects")
        protected String label;
        @Option(name="--extractable", aliases={"-x"}, description="whether the key is extractable, valid values are yes|no|true|false")
        private String extractable;
        @Option(name="--sensitive", description="whether the key is sensitive, valid values are yes|no|true|false")
        private String sensitive;
        @Option(name="--key-usage", multiValued=true, description="key usage of the private key")
        @Completion(value=SecurityCompleters.P11KeyUsageCompleter.class)
        private List<String> keyusages;

        protected void finalize(String keyType, P11IdentityId identityId) throws Exception {
            Args.notNull((Object)identityId, (String)"identityId");
            this.println("generated " + keyType + " key \"" + identityId + "\"");
        }

        protected P11Slot.P11NewKeyControl getControl() throws IllegalCmdParamException {
            byte[] id = this.hexId == null ? null : Hex.decode((String)this.hexId);
            P11Slot.P11NewKeyControl control = new P11Slot.P11NewKeyControl(id, this.label);
            if (StringUtil.isNotBlank((String)this.extractable)) {
                control.setExtractable(Boolean.valueOf(P11KeyGenAction.isEnabled((String)this.extractable, (boolean)false, (String)"extractable")));
            }
            if (StringUtil.isNotBlank((String)this.sensitive)) {
                control.setSensitive(Boolean.valueOf(P11KeyGenAction.isEnabled((String)this.sensitive, (boolean)false, (String)"sensitive")));
            }
            if (CollectionUtil.isNonEmpty(this.keyusages)) {
                control.setUsages(SecurityCompleters.P11KeyUsageCompleter.parseUsages(this.keyusages));
            }
            return control;
        }
    }

    @Command(scope="xi", name="delete-key-p11", description="delete key and cert in PKCS#11 device")
    @Service
    public static class DeleteKeyP11
    extends P11SecurityAction {
        @Option(name="--id", description="id of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String id;
        @Option(name="--label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String label;
        @Option(name="--force", aliases={"-f"}, description="remove identifies without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            P11Slot slot = this.getSlot();
            P11ObjectIdentifier keyId = this.getObjectIdentifier(this.id, this.label);
            if (keyId == null) {
                this.println("unkown identity");
                return null;
            }
            if (this.force.booleanValue() || this.confirm("Do you want to remove the identity " + keyId, 3)) {
                slot.removeIdentityByKeyId(keyId);
                this.println("deleted identity " + keyId);
            }
            return null;
        }
    }

    @Command(scope="xi", name="ec-p11", description="generate EC keypair in PKCS#11 device")
    @Service
    public static class EcP11
    extends P11KeyGenAction {
        @Option(name="--curve", description="EC curve name")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName = "secp256r1";

        protected Object execute0() throws Exception {
            P11Slot slot = this.getSlot();
            P11IdentityId identityId = slot.generateECKeypair(this.curveName, this.getControl());
            this.finalize("EC", identityId);
            return null;
        }
    }

    @Command(scope="xi", name="dsa-p11", description="generate DSA keypair in PKCS#11 device")
    @Service
    public static class Dsa11
    extends P11KeyGenAction {
        @Option(name="--plen", description="bit length of the prime")
        private Integer plen = 2048;
        @Option(name="--qlen", description="bit length of the sub-prime")
        private Integer qlen;

        protected Object execute0() throws Exception {
            if (this.plen % 1024 != 0) {
                throw new IllegalCmdParamException("plen is not multiple of 1024: " + this.plen);
            }
            if (this.qlen == null) {
                this.qlen = this.plen <= 1024 ? Integer.valueOf(160) : (this.plen <= 2048 ? Integer.valueOf(224) : Integer.valueOf(256));
            }
            P11Slot slot = this.getSlot();
            P11IdentityId identityId = slot.generateDSAKeypair(this.plen.intValue(), this.qlen.intValue(), this.getControl());
            this.finalize("DSA", identityId);
            return null;
        }
    }

    @Command(scope="xi", name="csr-p11", description="generate CSR request with PKCS#11 device")
    @Service
    public static class CsrP11
    extends Actions.CsrGenAction {
        @Option(name="--slot", required=true, description="slot index")
        private Integer slotIndex;
        @Option(name="--id", description="id of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        private String id;
        @Option(name="--label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        private String label;
        @Option(name="--module", description="name of the PKCS#11 module")
        @Completion(value=SecurityCompleters.P11ModuleNameCompleter.class)
        private String moduleName = "default";

        @Override
        protected ConcurrentContentSigner getSigner(SignatureAlgoControl signatureAlgoControl) throws Exception {
            Args.notNull((Object)signatureAlgoControl, (String)"signatureAlgoControl");
            byte[] idBytes = null;
            if (this.id != null) {
                idBytes = Hex.decode((String)this.id);
            }
            SignerConf conf = CsrP11.getPkcs11SignerConf(this.moduleName, this.slotIndex, this.label, idBytes, 1, HashAlgo.getNonNullInstance((String)this.hashAlgo), signatureAlgoControl);
            return this.securityFactory.createSigner("PKCS11", conf, (X509Certificate[])null);
        }

        public static SignerConf getPkcs11SignerConf(String pkcs11ModuleName, Integer slotIndex, String keyLabel, byte[] keyId, int parallelism, HashAlgo hashAlgo, SignatureAlgoControl signatureAlgoControl) {
            Args.positive((int)parallelism, (String)"parallelism");
            Args.notNull((Object)hashAlgo, (String)"hashAlgo");
            if (slotIndex == null) {
                throw new IllegalArgumentException("slotIndex may not be null");
            }
            if (keyId == null && keyLabel == null) {
                throw new IllegalArgumentException("at least one of keyId and keyLabel may not be null");
            }
            ConfPairs conf = new ConfPairs();
            conf.putPair("parallelism", Integer.toString(parallelism));
            if (pkcs11ModuleName != null && pkcs11ModuleName.length() > 0) {
                conf.putPair("module", pkcs11ModuleName);
            }
            if (slotIndex != null) {
                conf.putPair("slot", slotIndex.toString());
            }
            if (keyId != null) {
                conf.putPair("key-id", Hex.encode((byte[])keyId));
            }
            if (keyLabel != null) {
                conf.putPair("key-label", keyLabel);
            }
            return new SignerConf(conf.getEncoded(), hashAlgo, signatureAlgoControl);
        }
    }

    @Command(scope="xi", name="update-cert-p11", description="update certificate in PKCS#11 device")
    @Service
    public static class UpdateCertP11
    extends P11SecurityAction {
        @Option(name="--id", description="id of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String id;
        @Option(name="--label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String label;
        @Option(name="--cert", required=true, description="certificate file")
        @Completion(value=FileCompleter.class)
        private String certFile;

        protected Object execute0() throws Exception {
            P11Slot slot = this.getSlot();
            P11ObjectIdentifier objIdentifier = this.getObjectIdentifier(this.id, this.label);
            X509Certificate newCert = X509Util.parseCert((File)new File(this.certFile));
            slot.updateCertificate(objIdentifier, newCert);
            this.println("updated certificate");
            return null;
        }
    }

    @Command(scope="xi", name="export-cert-p11", description="export certificate from PKCS#11 device")
    @Service
    public static class ExportCertP11
    extends P11SecurityAction {
        @Option(name="--id", description="id of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String id;
        @Option(name="--label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String label;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outFile;

        protected Object execute0() throws Exception {
            P11ObjectIdentifier objIdentifier;
            P11Slot slot = this.getSlot();
            X509Certificate cert = slot.exportCert(objIdentifier = this.getObjectIdentifier(this.id, this.label));
            if (cert == null) {
                throw new CmdFailure("could not export certificate " + objIdentifier);
            }
            this.saveVerbose("saved certificate to file", this.outFile, ExportCertP11.encodeCert((byte[])cert.getEncoded(), (String)this.outform));
            return null;
        }
    }

    @Command(scope="xi", name="delete-cert-p11", description="remove certificate from PKCS#11 device")
    @Service
    public static class DeleteCertP11
    extends P11SecurityAction {
        @Option(name="--id", required=true, description="id of the certificate in the PKCS#11 device")
        private String id;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            if (this.force.booleanValue() || this.confirm("Do you want to remove PKCS#11 certificate object with id " + this.id, 3)) {
                P11Slot slot = this.getSlot();
                P11ObjectIdentifier objectId = slot.getObjectId(Hex.decode((String)this.id), null);
                if (objectId == null) {
                    this.println("unkown certificates");
                } else {
                    slot.removeCerts(objectId);
                    this.println("deleted certificates");
                }
            }
            return null;
        }
    }

    @Command(scope="xi", name="add-cert-p11", description="add certificate to PKCS#11 device")
    @Service
    public static class AddCertP11
    extends P11SecurityAction {
        @Option(name="--id", description="id of the PKCS#11 objects")
        private String hexId;
        @Option(name="--label", description="label of the PKCS#11 objects.")
        protected String label;
        @Option(name="--cert", required=true, description="certificate file")
        @Completion(value=FileCompleter.class)
        private String certFile;

        protected Object execute0() throws Exception {
            byte[] id = this.hexId == null ? null : Hex.decode((String)this.hexId);
            X509Certificate cert = X509Util.parseCert((File)new File(this.certFile));
            if (this.label == null) {
                this.label = X509Util.getCommonName((X500Principal)cert.getSubjectX500Principal());
            }
            P11Slot.P11NewObjectControl control = new P11Slot.P11NewObjectControl(id, this.label);
            P11Slot slot = this.getSlot();
            P11ObjectIdentifier objectId = slot.addCert(cert, control);
            this.println("added certificate under " + objectId);
            return null;
        }
    }
}

