/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.security.SignAlgo;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.shell.DynamicEnumCompleter;
import org.xipki.shell.EnumCompleter;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.CollectionUtil;

public class SecurityCompleters {

    @Service
    public static class SignAlgoCompleter
    extends EnumCompleter {
        private static Set<String> algos = new HashSet<String>();

        public SignAlgoCompleter() {
            this.setTokens(algos);
        }

        static {
            for (SignAlgo m : SignAlgo.values()) {
                algos.add(m.getJceName());
            }
        }
    }

    @Service
    public static class SecretKeyTypeCompleter
    extends EnumCompleter {
        public SecretKeyTypeCompleter() {
            this.setTokens(new String[]{"DES3", "AES", "GENERIC"});
        }
    }

    @Service
    public static class P11ModuleNameCompleter
    extends DynamicEnumCompleter {
        @Reference(optional=true)
        private P11CryptServiceFactory p11CryptServiceFactory;

        protected Set<String> getEnums() {
            Set names = this.p11CryptServiceFactory.getModuleNames();
            if (CollectionUtil.isEmpty((Collection)names)) {
                return Collections.emptySet();
            }
            return names;
        }
    }

    @Service
    public static class P11KeyUsageCompleter
    extends EnumCompleter {
        public P11KeyUsageCompleter() {
            HashSet<String> names = new HashSet<String>();
            for (P11Slot.P11KeyUsage usage : P11Slot.P11KeyUsage.values()) {
                names.add(usage.name());
            }
            this.setTokens(names);
        }

        public static Set<P11Slot.P11KeyUsage> parseUsages(List<String> usageTexts) throws IllegalCmdParamException {
            HashSet<P11Slot.P11KeyUsage> usages = new HashSet<P11Slot.P11KeyUsage>();
            for (String usageText : usageTexts) {
                P11Slot.P11KeyUsage usage = P11Slot.P11KeyUsage.valueOf((String)usageText.toUpperCase());
                usages.add(usage);
            }
            return usages;
        }
    }

    @Service
    public static class KeystoreTypeCompleter
    extends EnumCompleter {
        public KeystoreTypeCompleter() {
            this.setTokens(new String[]{"PKCS12", "JCEKS"});
        }
    }
}

