/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.qualified.BiometricData;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.xipki.password.OBFPasswordService;
import org.xipki.password.PBEAlgo;
import org.xipki.password.PBEPasswordService;
import org.xipki.security.BadInputException;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.ExtensionExistence;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.X509Cert;
import org.xipki.security.X509ExtensionType;
import org.xipki.security.XiSecurityException;
import org.xipki.security.shell.SecurityCompleters;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class Actions {

    public static abstract class SecurityAction
    extends XiAction {
        @Reference
        protected SecurityFactory securityFactory;

        protected String toUtcTimeyyyyMMddhhmmssZ(Date date) {
            return DateUtil.toUtcTimeyyyyMMddhhmmss((Date)date) + "Z";
        }
    }

    @Command(scope="xi", name="pbe-enc", description="encrypt password with master password")
    @Service
    public static class PbeEnc
    extends SecurityAction {
        @Option(name="--iteration-count", aliases={"-n"}, description="iteration count, between 1 and 65535")
        private int iterationCount = 2000;
        @Option(name="--out", description="where to save the encrypted password")
        @Completion(value=FileCompleter.class)
        private String outFile;
        @Option(name="-k", description="quorum of the password parts")
        private Integer quorum = 1;
        @Option(name="--mpassword-file", description="file containing the (obfuscated) master password")
        @Completion(value=FileCompleter.class)
        private String masterPasswordFile;
        @Option(name="--mk", description="quorum of the master password parts")
        private Integer mquorum = 1;

        protected Object execute0() throws Exception {
            char[] password;
            char[] masterPassword;
            Args.range((int)this.iterationCount, (String)"iterationCount", (int)1, (int)65535);
            Args.range((int)this.quorum, (String)"k", (int)1, (int)10);
            Args.range((int)this.mquorum, (String)"mk", (int)1, (int)10);
            if (this.masterPasswordFile != null) {
                String str = new String(IoUtil.read((String)this.masterPasswordFile));
                if (str.startsWith("OBF:") || str.startsWith("obf:")) {
                    str = OBFPasswordService.deobfuscate((String)str);
                }
                masterPassword = str.toCharArray();
            } else if (this.mquorum == 1) {
                masterPassword = this.readPassword("Master password");
            } else {
                char[][] parts = new char[this.mquorum.intValue()][];
                for (int i = 0; i < this.mquorum; ++i) {
                    parts[i] = this.readPassword("Master password (part " + (i + 1) + "/" + this.mquorum + ")");
                }
                masterPassword = StringUtil.merge((char[][])parts);
            }
            if (this.quorum == 1) {
                password = this.readPassword("Password");
            } else {
                char[][] parts = new char[this.quorum.intValue()][];
                for (int i = 0; i < this.quorum; ++i) {
                    parts[i] = this.readPassword("Password (part " + (i + 1) + "/" + this.quorum + ")");
                }
                password = StringUtil.merge((char[][])parts);
            }
            String passwordHint = PBEPasswordService.encryptPassword((PBEAlgo)PBEAlgo.PBEWithHmacSHA256AndAES_256, (int)this.iterationCount, (char[])masterPassword, (char[])password);
            if (this.outFile != null) {
                this.saveVerbose("saved the encrypted password to file", this.outFile, StringUtil.toUtf8Bytes((String)passwordHint));
            } else {
                this.println("the encrypted password is: '" + passwordHint + "'");
            }
            return null;
        }
    }

    @Command(scope="xi", name="pbe-dec", description="decrypt password with master password")
    @Service
    public static class PbeDec
    extends SecurityAction {
        @Option(name="--password", description="encrypted password, starts with PBE:\nexactly one of password and password-file must be specified")
        private String passwordHint;
        @Option(name="--password-file", description="file containing the encrypted password")
        @Completion(value=FileCompleter.class)
        private String passwordFile;
        @Option(name="--mpassword-file", description="file containing the (obfuscated) master password")
        @Completion(value=FileCompleter.class)
        private String masterPasswordFile;
        @Option(name="--mk", description="quorum of the master password parts")
        private Integer mquorum = 1;
        @Option(name="--out", description="where to save the password")
        @Completion(value=FileCompleter.class)
        private String outFile;

        protected Object execute0() throws Exception {
            char[] masterPassword;
            Args.range((int)this.mquorum, (String)"mk", (int)1, (int)10);
            if (!(this.passwordHint == null ^ this.passwordFile == null)) {
                throw new IllegalCmdParamException("exactly one of password and password-file must be specified");
            }
            if (this.passwordHint == null) {
                this.passwordHint = new String(IoUtil.read((String)this.passwordFile));
            }
            if (!StringUtil.startsWithIgnoreCase((String)this.passwordHint, (String)"PBE:")) {
                throw new IllegalCmdParamException("encrypted password '" + this.passwordHint + "' does not start with PBE:");
            }
            if (this.masterPasswordFile != null) {
                String str = new String(IoUtil.read((String)this.masterPasswordFile));
                if (str.startsWith("OBF:") || str.startsWith("obf:")) {
                    str = OBFPasswordService.deobfuscate((String)str);
                }
                masterPassword = str.toCharArray();
            } else if (this.mquorum == 1) {
                masterPassword = this.readPassword("Master password");
            } else {
                char[][] parts = new char[this.mquorum.intValue()][];
                for (int i = 0; i < this.mquorum; ++i) {
                    parts[i] = this.readPassword("Master password (part " + (i + 1) + "/" + this.mquorum + ")");
                }
                masterPassword = StringUtil.merge((char[][])parts);
            }
            char[] password = PBEPasswordService.decryptPassword((char[])masterPassword, (String)this.passwordHint);
            if (this.outFile != null) {
                this.saveVerbose("saved the password to file", this.outFile, StringUtil.toUtf8Bytes((String)new String(password)));
            } else {
                this.println("the password is: '" + new String(password) + "'");
            }
            return null;
        }
    }

    @Command(scope="xi", name="obfuscate", description="obfuscate password")
    @Service
    public static class Obfuscate
    extends SecurityAction {
        @Option(name="--out", description="where to save the encrypted password")
        @Completion(value=FileCompleter.class)
        private String outFile;
        @Option(name="-k", description="quorum of the password parts")
        private Integer quorum = 1;

        protected Object execute0() throws Exception {
            char[] password;
            Args.range((int)this.quorum, (String)"k", (int)1, (int)10);
            if (this.quorum == 1) {
                password = this.readPassword("Password");
            } else {
                char[][] parts = new char[this.quorum.intValue()][];
                for (int i = 0; i < this.quorum; ++i) {
                    parts[i] = this.readPassword("Password " + (i + 1) + "/" + this.quorum);
                }
                password = StringUtil.merge((char[][])parts);
            }
            String passwordHint = OBFPasswordService.obfuscate((String)new String(password));
            if (this.outFile != null) {
                this.saveVerbose("saved the obfuscated password to file", this.outFile, StringUtil.toUtf8Bytes((String)passwordHint));
            } else {
                this.println("the obfuscated password is: '" + passwordHint + "'");
            }
            return null;
        }
    }

    @Command(scope="xi", name="keystore-convert", description="convert the keystore format")
    @Service
    public static class KeystoreConvert
    extends SecurityAction {
        @Option(name="--in-type", required=true, description="type of source keystore")
        private String inType;
        @Option(name="--in", required=true, description="file of source keystore")
        @Completion(value=FileCompleter.class)
        private String inFile;
        @Option(name="--in-provider", description="Security provider of source keystore")
        private String inProvider;
        @Option(name="--in-pass", description="password of source keystore")
        private String inPass;
        @Option(name="--in-keypass-diff", description="whether the password for the keys differs from that of source keystore\nwill be ignored if --in-keypass is set")
        private Boolean inKeyPassDiff = Boolean.FALSE;
        @Option(name="--in-keypass", valueToShowInHelp="keystore password", description="password for the keys of source keystore")
        private String inKeyPass;
        @Option(name="--out-type", required=true, description="type of target keystore")
        private String outType;
        @Option(name="--out-provider", description="Security provider of target keystore")
        private String outProvider;
        @Option(name="--out", required=true, description="file of target keystore")
        @Completion(value=FileCompleter.class)
        private String outFile;
        @Option(name="--out-pass", description="password of target keystore")
        private String outPass;
        @Option(name="--out-keypass-diff", description="whether the password for the keys differs from that of target keystore\nwill be ignored if --out-keypass is set")
        private Boolean outKeyPassDiff = Boolean.FALSE;
        @Option(name="--out-keypass", valueToShowInHelp="keystore password", description="password for the keys of target keystore")
        private String outKeyPass;

        protected Object execute0() throws Exception {
            KeyStore srcKs = StringUtil.isBlank((String)this.inProvider) ? KeyStore.getInstance(this.inType) : KeyStore.getInstance(this.inType, this.inProvider);
            char[] inPwd = this.inPass != null ? this.inPass.toCharArray() : this.readPassword("Enter the password of the source keystore");
            srcKs.load(Files.newInputStream(Paths.get(this.inFile, new String[0]), new OpenOption[0]), inPwd);
            Enumeration<String> aliases = srcKs.aliases();
            boolean containsKeyEntry = false;
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!srcKs.isKeyEntry(alias)) continue;
                containsKeyEntry = true;
                break;
            }
            char[] inKeyPwd = null;
            if (containsKeyEntry) {
                inKeyPwd = this.inKeyPass != null ? this.inKeyPass.toCharArray() : (this.inKeyPassDiff != false ? this.readPassword("Enter the password for keys of the source keystore") : inPwd);
            }
            char[] outPwd = this.outPass != null ? this.outPass.toCharArray() : this.readPassword("Enter the password of the target keystore");
            char[] outKeyPwd = null;
            if (containsKeyEntry) {
                inKeyPwd = this.outKeyPass != null ? this.outKeyPass.toCharArray() : (this.outKeyPassDiff != false ? this.readPassword("Enter the password for keys of the target keystore") : inPwd);
            }
            KeyStore destKs = StringUtil.isBlank((String)this.outProvider) ? KeyStore.getInstance(this.outType) : KeyStore.getInstance(this.outType, this.inProvider);
            destKs.load(null, outPwd);
            aliases = srcKs.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (srcKs.isKeyEntry(alias)) {
                    Key key = srcKs.getKey(alias, inKeyPwd);
                    java.security.cert.Certificate[] chain = srcKs.getCertificateChain(alias);
                    destKs.setKeyEntry(alias, key, outKeyPwd, chain);
                    continue;
                }
                if (srcKs.isCertificateEntry(alias)) {
                    java.security.cert.Certificate cert = srcKs.getCertificate(alias);
                    destKs.setCertificateEntry(alias, cert);
                    continue;
                }
                this.println("entry " + alias + " is neither key nor certificate, ignore it");
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            destKs.store(bout, outPwd);
            this.saveVerbose("converted keystore to", this.outFile, bout.toByteArray());
            return null;
        }
    }

    @Command(scope="xi", name="import-cert", description="import certificates to a keystore")
    @Service
    public static class ImportCert
    extends SecurityAction {
        @Option(name="--keystore", required=true, description="keystore file")
        @Completion(value=FileCompleter.class)
        private String ksFile;
        @Option(name="--type", required=true, description="type of the keystore")
        @Completion(value=SecurityCompleters.KeystoreTypeCompleter.class)
        private String ksType;
        @Option(name="--password", description="password of the keystore")
        private String ksPwd;
        @Option(name="--cert", aliases={"-c"}, required=true, multiValued=true, description="certificate files")
        @Completion(value=FileCompleter.class)
        private List<String> certFiles;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            File realKsFile = new File(IoUtil.expandFilepath((String)this.ksFile));
            KeyStore ks = KeyStore.getInstance(this.ksType);
            char[] password = this.readPasswordIfNotSet(this.ksPwd);
            HashSet<String> aliases = new HashSet<String>(10);
            if (realKsFile.exists()) {
                try (InputStream inStream = Files.newInputStream(realKsFile.toPath(), new OpenOption[0]);){
                    ks.load(inStream, password);
                }
                Enumeration<String> strs = ks.aliases();
                while (strs.hasMoreElements()) {
                    aliases.add(strs.nextElement());
                }
            } else {
                ks.load(null);
            }
            for (String certFile : this.certFiles) {
                String baseAlias;
                X509Cert cert = X509Util.parseCert((File)new File(certFile));
                String alias = baseAlias = X509Util.getCommonName((X500Name)cert.getSubject());
                int idx = 2;
                while (aliases.contains(alias)) {
                    alias = baseAlias + "-" + idx++;
                }
                ks.setCertificateEntry(alias, cert.toJceCert());
                aliases.add(alias);
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);
            ks.store(bout, password);
            this.saveVerbose("saved keystore to file", realKsFile, bout.toByteArray());
            return null;
        }
    }

    @Command(scope="xi", name="deobfuscate", description="deobfuscate password")
    @Service
    public static class Deobfuscate
    extends SecurityAction {
        @Option(name="--password", description="obfuscated password, starts with OBF:\nexactly one of password and password-file must be specified")
        private String passwordHint;
        @Option(name="--password-file", description="file containing the obfuscated password")
        @Completion(value=FileCompleter.class)
        private String passwordFile;
        @Option(name="--out", description="where to save the password")
        @Completion(value=FileCompleter.class)
        private String outFile;

        protected Object execute0() throws Exception {
            if (!(this.passwordHint == null ^ this.passwordFile == null)) {
                throw new IllegalCmdParamException("exactly one of password and password-file must be specified");
            }
            if (this.passwordHint == null) {
                this.passwordHint = new String(IoUtil.read((String)this.passwordFile));
            }
            if (!StringUtil.startsWithIgnoreCase((String)this.passwordHint, (String)"OBF:")) {
                throw new IllegalCmdParamException("encrypted password '" + this.passwordHint + "' does not start with OBF:");
            }
            String password = OBFPasswordService.deobfuscate((String)this.passwordHint);
            if (this.outFile != null) {
                this.saveVerbose("saved the password to file", this.outFile, StringUtil.toUtf8Bytes((String)password));
            } else {
                this.println("the password is: '" + new String(password) + "'");
            }
            return null;
        }
    }

    @Command(scope="xi", name="validate-csr", description="validate CSR")
    @Service
    public static class ValidateCsr
    extends SecurityAction {
        @Option(name="--csr", required=true, description="CSR file")
        @Completion(value=FileCompleter.class)
        private String csrFile;
        @Option(name="--keystore", description="peer's keystore file")
        @Completion(value=FileCompleter.class)
        private String peerKeystoreFile;
        @Option(name="--keystore-type", description="type of the keystore")
        @Completion(value=SecurityCompleters.KeystoreTypeCompleter.class)
        private String keystoreType = "PKCS12";
        @Option(name="--keystore-password", description="password of the keystore")
        private String keystorePassword;

        protected Object execute0() throws Exception {
            CertificationRequest csr = X509Util.parseCsr((byte[])IoUtil.read((String)this.csrFile));
            ASN1ObjectIdentifier algOid = csr.getSignatureAlgorithm().getAlgorithm();
            DHSigStaticKeyCertPair peerKeyAndCert = null;
            if (ObjectIdentifiers.Xipki.id_alg_dhPop_x25519_sha256.equals((ASN1Primitive)algOid) || ObjectIdentifiers.Xipki.id_alg_dhPop_x448_sha512.equals((ASN1Primitive)algOid)) {
                if (this.peerKeystoreFile == null || this.keystorePassword == null) {
                    System.err.println("could not verify CSR, please specify the peer's keystore");
                    return null;
                }
                String requiredKeyAlg = ObjectIdentifiers.Xipki.id_alg_dhPop_x25519_sha256.equals((ASN1Primitive)algOid) ? "X25519" : "X448";
                char[] password = this.keystorePassword.toCharArray();
                KeyStore ks = KeyUtil.getKeyStore((String)this.keystoreType);
                File file = IoUtil.expandFilepath((File)new File(this.peerKeystoreFile));
                try (FileInputStream is = new FileInputStream(file);){
                    ks.load(is, password);
                    Enumeration<String> aliases = ks.aliases();
                    while (aliases.hasMoreElements()) {
                        PrivateKey key;
                        String alias = aliases.nextElement();
                        if (!ks.isKeyEntry(alias) || !(key = (PrivateKey)ks.getKey(alias, password)).getAlgorithm().equalsIgnoreCase(requiredKeyAlg)) continue;
                        X509Cert cert = new X509Cert((X509Certificate)ks.getCertificate(alias));
                        peerKeyAndCert = new DHSigStaticKeyCertPair(key, cert);
                        break;
                    }
                }
                if (peerKeyAndCert == null) {
                    System.err.println("could not find peer key entry to verify the CSR");
                    return null;
                }
            }
            String sigAlgo = AlgorithmUtil.getSignatureAlgoName((AlgorithmIdentifier)csr.getSignatureAlgorithm());
            boolean bo = this.securityFactory.verifyPopo(csr, null, peerKeyAndCert);
            String txt = bo ? "valid" : "invalid";
            this.println("The POP is " + txt + " (signature algorithm " + sigAlgo + ").");
            return null;
        }
    }

    public static abstract class CsrGenAction
    extends SecurityAction {
        private static final long _12_HOURS_MS = 43200000L;
        @Option(name="--hash", description="hash algorithm name (will be ignored in some keys, e.g. edwards curve based keys)")
        @Completion(value=Completers.HashAlgCompleter.class)
        protected String hashAlgo = "SHA256";
        @Option(name="--subject-alt-name", aliases={"--san"}, multiValued=true, description="subjectAltName, in the form of [tagNo]value or [tagText]value. Valid tagNo/tagText/value: '0'/'othername'/OID=value, '1'/'email'/text, '2'/'dns'/text, '4'/'dirName'/X500 name e.g. CN=abc,'5'/'edi'/key=value, '6'/'uri'/text, '7'/'ip'/IP address,'8'/'rid'/OID")
        protected List<String> subjectAltNames;
        @Option(name="--subject-info-access", aliases={"--sia"}, multiValued=true, description="subjectInfoAccess")
        protected List<String> subjectInfoAccesses;
        @Option(name="--peer-cert", description="Peer certificate file, only for the Diffie-Hellman keys")
        @Completion(value=FileCompleter.class)
        private String peerCertFile;
        @Option(name="--peer-certs", description="Peer certificates file (A PEM file containing certificates, only for the Diffie-Hellman keys")
        @Completion(value=FileCompleter.class)
        private String peerCertsFile;
        @Option(name="--subject", aliases={"-s"}, required=true, description="subject in the CSR")
        private String subject;
        @Option(name="--dateOfBirth", description="Date of birth YYYYMMdd in subject")
        private String dateOfBirth;
        @Option(name="--postalAddress", multiValued=true, description="postal address in subject")
        private List<String> postalAddress;
        @Option(name="--rsa-mgf1", description="whether to use the RSAPSS MGF1 for the POPO computation\n(only applied to RSA key)")
        private Boolean rsaMgf1 = Boolean.FALSE;
        @Option(name="--dsa-plain", description="whether to use the Plain DSA for the POPO computation")
        private Boolean dsaPlain = Boolean.FALSE;
        @Option(name="--gm", description="whether to use the chinese GM algorithm for the POPO computation\n(only applied to EC key with GM curves)")
        private Boolean gm = Boolean.FALSE;
        @Option(name="--outform", description="output format of the CSR")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="CSR file")
        @Completion(value=FileCompleter.class)
        private String outputFilename;
        @Option(name="--challenge-password", aliases={"-c"}, description="challenge password")
        private String challengePassword;
        @Option(name="--keyusage", multiValued=true, description="keyusage")
        @Completion(value=Completers.KeyusageCompleter.class)
        private List<String> keyusages;
        @Option(name="--ext-keyusage", multiValued=true, description="extended keyusage (name or OID)")
        @Completion(value=Completers.ExtKeyusageCompleter.class)
        private List<String> extkeyusages;
        @Option(name="--qc-eu-limit", multiValued=true, description="QC EuLimitValue of format <currency>:<amount>:<exponent>")
        private List<String> qcEuLimits;
        @Option(name="--biometric-type", description="Biometric type")
        private String biometricType;
        @Option(name="--biometric-hash", description="Biometric hash algorithm")
        @Completion(value=Completers.HashAlgCompleter.class)
        private String biometricHashAlgo;
        @Option(name="--biometric-file", description="Biometric hash algorithm")
        private String biometricFile;
        @Option(name="--biometric-uri", description="Biometric sourcedata URI")
        @Completion(value=FileCompleter.class)
        private String biometricUri;
        @Option(name="--extra-extensions-file", description="Configuration file for extral extensions")
        @Completion(value=FileCompleter.class)
        private String extraExtensionsFile;
        @Option(name="--need-extension", multiValued=true, description="types (name or OID) of extension that must be contained in the certificate")
        @Completion(value=Completers.ExtensionNameCompleter.class)
        private List<String> needExtensionTypes;
        @Option(name="--want-extension", multiValued=true, description="types (name or OID) of extension that should be contained in the certificate if possible")
        @Completion(value=Completers.ExtensionNameCompleter.class)
        private List<String> wantExtensionTypes;

        protected abstract ConcurrentContentSigner getSigner(SignatureAlgoControl var1) throws Exception;

        protected List<X509Cert> getPeerCertificates() throws CertificateException, IOException {
            if (StringUtil.isNotBlank((String)this.peerCertsFile)) {
                try (PemReader pemReader = new PemReader((Reader)new FileReader(this.peerCertsFile));){
                    PemObject pemObj;
                    LinkedList<X509Cert> certs = new LinkedList<X509Cert>();
                    while ((pemObj = pemReader.readPemObject()) != null) {
                        if (!"CERTIFICATE".equals(pemObj.getType())) continue;
                        certs.add(X509Util.parseCert((byte[])pemObj.getContent()));
                    }
                    LinkedList<X509Cert> linkedList = certs.isEmpty() ? null : certs;
                    return linkedList;
                }
            }
            if (StringUtil.isNotBlank((String)this.peerCertFile)) {
                X509Cert cert = X509Util.parseCert((File)Paths.get(this.peerCertFile, new String[0]).toFile());
                return Arrays.asList(cert);
            }
            return null;
        }

        protected Object execute0() throws Exception {
            RDN[] id;
            RDN[] rdns;
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            Object bytes;
            ASN1EncodableVector vec;
            Object extType;
            ASN1ObjectIdentifier oid;
            ASN1OctetString extnValue;
            this.hashAlgo = this.hashAlgo.trim().toUpperCase();
            if (this.hashAlgo.indexOf(45) != -1) {
                this.hashAlgo = this.hashAlgo.replaceAll("-", "");
            }
            this.needExtensionTypes = this.needExtensionTypes != null ? this.resolveExtensionTypes(this.needExtensionTypes) : new LinkedList<String>();
            this.wantExtensionTypes = this.wantExtensionTypes != null ? this.resolveExtensionTypes(this.wantExtensionTypes) : new LinkedList<String>();
            if (this.extkeyusages != null) {
                ArrayList<String> list = new ArrayList<String>(this.extkeyusages.size());
                for (String m : this.extkeyusages) {
                    Object id2 = Completers.ExtKeyusageCompleter.getIdForUsageName((String)m);
                    if (id2 != null) continue;
                    try {
                        id2 = new ASN1ObjectIdentifier(m).getId();
                    }
                    catch (Exception ex) {
                        throw new IllegalCmdParamException("invalid extended key usage " + m);
                    }
                }
                this.extkeyusages = list;
            }
            LinkedList<Extension> extensions = new LinkedList<Extension>();
            ASN1OctetString aSN1OctetString = extnValue = CsrGenAction.isEmpty(this.subjectAltNames) ? null : X509Util.createExtnSubjectAltName(this.subjectAltNames, (boolean)false).getExtnValue();
            if (extnValue != null) {
                oid = Extension.subjectAlternativeName;
                extensions.add(new Extension(oid, false, extnValue));
                this.needExtensionTypes.add(oid.getId());
            }
            ASN1OctetString aSN1OctetString2 = extnValue = CsrGenAction.isEmpty(this.subjectInfoAccesses) ? null : X509Util.createExtnSubjectInfoAccess(this.subjectInfoAccesses, (boolean)false).getExtnValue();
            if (extnValue != null) {
                oid = Extension.subjectInfoAccess;
                extensions.add(new Extension(oid, false, extnValue));
                this.needExtensionTypes.add(oid.getId());
            }
            if (CsrGenAction.isNotEmpty(this.keyusages)) {
                HashSet<KeyUsage> usages = new HashSet<KeyUsage>();
                for (String usage : this.keyusages) {
                    usages.add(KeyUsage.getKeyUsage((String)usage));
                }
                org.bouncycastle.asn1.x509.KeyUsage extValue = X509Util.createKeyUsage(usages);
                ASN1ObjectIdentifier extType2 = Extension.keyUsage;
                extensions.add(new Extension(extType2, false, extValue.getEncoded()));
                this.needExtensionTypes.add(extType2.getId());
            }
            if (CsrGenAction.isNotEmpty(this.extkeyusages)) {
                ExtendedKeyUsage extValue = X509Util.createExtendedUsage(CsrGenAction.textToAsn1ObjectIdentifers(this.extkeyusages));
                extType = Extension.extendedKeyUsage;
                extensions.add(new Extension((ASN1ObjectIdentifier)extType, false, extValue.getEncoded()));
                this.needExtensionTypes.add(extType.getId());
            }
            if (CsrGenAction.isNotEmpty(this.qcEuLimits)) {
                ASN1EncodableVector vec2 = new ASN1EncodableVector();
                for (String m : this.qcEuLimits) {
                    StringTokenizer st = new StringTokenizer(m, ":");
                    try {
                        Iso4217CurrencyCode currency;
                        String currencyS = st.nextToken();
                        String amountS = st.nextToken();
                        String exponentS = st.nextToken();
                        try {
                            int intValue = Integer.parseInt(currencyS);
                            currency = new Iso4217CurrencyCode(intValue);
                        }
                        catch (NumberFormatException ex) {
                            currency = new Iso4217CurrencyCode(currencyS);
                        }
                        int amount = Integer.parseInt(amountS);
                        int exponent = Integer.parseInt(exponentS);
                        MonetaryValue monterayValue = new MonetaryValue(currency, amount, exponent);
                        QCStatement statment = new QCStatement(ObjectIdentifiers.Extn.id_etsi_qcs_QcLimitValue, (ASN1Encodable)monterayValue);
                        vec2.add((ASN1Encodable)statment);
                    }
                    catch (Exception ex) {
                        throw new Exception("invalid qc-eu-limit '" + m + "'");
                    }
                }
                extType = Extension.qCStatements;
                DERSequence extValue = new DERSequence(vec2);
                extensions.add(new Extension((ASN1ObjectIdentifier)extType, false, extValue.getEncoded()));
                this.needExtensionTypes.add(extType.getId());
            }
            if (this.biometricType != null && this.biometricHashAlgo != null && this.biometricFile != null) {
                TypeOfBiometricData tmpBiometricType = StringUtil.isNumber((String)this.biometricType) ? new TypeOfBiometricData(Integer.parseInt(this.biometricType)) : new TypeOfBiometricData(new ASN1ObjectIdentifier(this.biometricType));
                ASN1ObjectIdentifier tmpBiometricHashAlgo = AlgorithmUtil.getHashAlg((String)this.biometricHashAlgo);
                byte[] biometricBytes = IoUtil.read((String)this.biometricFile);
                MessageDigest md = MessageDigest.getInstance(tmpBiometricHashAlgo.getId());
                md.reset();
                byte[] tmpBiometricDataHash = md.digest(biometricBytes);
                DERIA5String tmpSourceDataUri = null;
                if (this.biometricUri != null) {
                    tmpSourceDataUri = new DERIA5String(this.biometricUri);
                }
                BiometricData biometricData = new BiometricData(tmpBiometricType, new AlgorithmIdentifier(tmpBiometricHashAlgo), (ASN1OctetString)new DEROctetString(tmpBiometricDataHash), tmpSourceDataUri);
                vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)biometricData);
                ASN1ObjectIdentifier extType3 = Extension.biometricInfo;
                DERSequence extValue = new DERSequence(vec);
                extensions.add(new Extension(extType3, false, extValue.getEncoded()));
                this.needExtensionTypes.add(extType3.getId());
            } else if (this.biometricType != null || this.biometricHashAlgo != null || this.biometricFile != null) {
                throw new Exception("either all of biometric triples (type, hash algo, file) must be set or none of them should be set");
            }
            if (this.extraExtensionsFile != null) {
                bytes = IoUtil.read((String)this.extraExtensionsFile);
                X509ExtensionType.ExtensionsType extraExtensions = (X509ExtensionType.ExtensionsType)JSON.parseObject((byte[])bytes, X509ExtensionType.ExtensionsType.class, (Feature[])new Feature[0]);
                extraExtensions.validate();
                List extnConfs = extraExtensions.getExtensions();
                if (CollectionUtil.isNotEmpty((Collection)extnConfs)) {
                    for (X509ExtensionType m : extnConfs) {
                        byte[] encodedExtnValue = m.getConstant().toASN1Encodable().toASN1Primitive().getEncoded("DER");
                        extensions.add(new Extension(new ASN1ObjectIdentifier(m.getType().getOid()), false, encodedExtnValue));
                    }
                }
            }
            bytes = this.getAdditionalExtensions().iterator();
            while (bytes.hasNext()) {
                Extension addExt = (Extension)bytes.next();
                extensions.add(addExt);
            }
            this.needExtensionTypes.addAll(this.getAdditionalNeedExtensionTypes());
            this.wantExtensionTypes.addAll(this.getAdditionalWantExtensionTypes());
            if (CsrGenAction.isNotEmpty(this.needExtensionTypes) || CsrGenAction.isNotEmpty(this.wantExtensionTypes)) {
                ExtensionExistence ee = new ExtensionExistence(CsrGenAction.textToAsn1ObjectIdentifers(this.needExtensionTypes), CsrGenAction.textToAsn1ObjectIdentifers(this.wantExtensionTypes));
                extensions.add(new Extension(ObjectIdentifiers.Xipki.id_xipki_ext_cmpRequestExtensions, false, ee.toASN1Primitive().getEncoded()));
            }
            ConcurrentContentSigner signer = this.getSigner(new SignatureAlgoControl(this.rsaMgf1.booleanValue(), this.dsaPlain.booleanValue(), this.gm.booleanValue()));
            HashMap<ASN1ObjectIdentifier, ASN1Encodable> attributes = new HashMap<ASN1ObjectIdentifier, ASN1Encodable>();
            if (CollectionUtil.isNotEmpty(extensions)) {
                attributes.put(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)new Extensions(extensions.toArray(new Extension[0])));
            }
            if (StringUtil.isNotBlank((String)this.challengePassword)) {
                attributes.put(PKCSObjectIdentifiers.pkcs_9_at_challengePassword, (ASN1Encodable)new DERPrintableString(this.challengePassword));
            }
            if (signer.getCertificate() != null) {
                Certificate cert = Certificate.getInstance((Object)signer.getCertificate().getEncoded());
                subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
            } else {
                subjectPublicKeyInfo = KeyUtil.createSubjectPublicKeyInfo((PublicKey)signer.getPublicKey());
            }
            X500Name subjectDn = this.getSubject(this.subject);
            LinkedList<RDN> list = new LinkedList<RDN>();
            if (StringUtil.isNotBlank((String)this.dateOfBirth) && ((rdns = subjectDn.getRDNs((ASN1ObjectIdentifier)(id = ObjectIdentifiers.DN.dateOfBirth))) == null || rdns.length == 0)) {
                Date date = DateUtil.parseUtcTimeyyyyMMdd((String)this.dateOfBirth);
                date = new Date(date.getTime() + 43200000L);
                DERGeneralizedTime atvValue = new DERGeneralizedTime(DateUtil.toUtcTimeyyyyMMddhhmmss((Date)date) + "Z");
                RDN rdn = new RDN((ASN1ObjectIdentifier)id, (ASN1Encodable)atvValue);
                list.add(rdn);
            }
            if (CollectionUtil.isNotEmpty(this.postalAddress) && ((rdns = subjectDn.getRDNs((ASN1ObjectIdentifier)(id = ObjectIdentifiers.DN.postalAddress))) == null || rdns.length == 0)) {
                vec = new ASN1EncodableVector();
                for (String m : this.postalAddress) {
                    vec.add((ASN1Encodable)new DERUTF8String(m));
                }
                if (vec.size() > 0) {
                    DERSequence atvValue = new DERSequence(vec);
                    RDN rdn = new RDN((ASN1ObjectIdentifier)id, (ASN1Encodable)atvValue);
                    list.add(rdn);
                }
            }
            if (!list.isEmpty()) {
                for (RDN rdn : subjectDn.getRDNs()) {
                    list.add(rdn);
                }
                subjectDn = new X500Name(list.toArray(new RDN[0]));
            }
            PKCS10CertificationRequest csr = this.generateRequest(signer, subjectPublicKeyInfo, subjectDn, attributes);
            this.saveVerbose("saved CSR to file", this.outputFilename, CsrGenAction.encodeCsr((byte[])csr.getEncoded(), (String)this.outform));
            return null;
        }

        protected X500Name getSubject(String subjectText) {
            return new X500Name(Args.notBlank((String)subjectText, (String)"subjectText"));
        }

        protected List<String> getAdditionalNeedExtensionTypes() {
            return Collections.emptyList();
        }

        protected List<String> getAdditionalWantExtensionTypes() {
            return Collections.emptyList();
        }

        protected List<Extension> getAdditionalExtensions() throws BadInputException {
            return Collections.emptyList();
        }

        private static List<ASN1ObjectIdentifier> textToAsn1ObjectIdentifers(List<String> oidTexts) {
            if (oidTexts == null) {
                return null;
            }
            ArrayList<ASN1ObjectIdentifier> ret = new ArrayList<ASN1ObjectIdentifier>(oidTexts.size());
            for (String oidText : oidTexts) {
                ASN1ObjectIdentifier oid;
                if (oidText.isEmpty() || ret.contains(oid = new ASN1ObjectIdentifier(oidText))) continue;
                ret.add(oid);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PKCS10CertificationRequest generateRequest(ConcurrentContentSigner signer, SubjectPublicKeyInfo subjectPublicKeyInfo, X500Name subjectDn, Map<ASN1ObjectIdentifier, ASN1Encodable> attributes) throws XiSecurityException {
            ConcurrentBagEntrySigner signer0;
            Args.notNull((Object)signer, (String)"signer");
            Args.notNull((Object)subjectPublicKeyInfo, (String)"subjectPublicKeyInfo");
            Args.notNull((Object)subjectDn, (String)"subjectDn");
            PKCS10CertificationRequestBuilder csrBuilder = new PKCS10CertificationRequestBuilder(subjectDn, subjectPublicKeyInfo);
            if (CollectionUtil.isNotEmpty(attributes)) {
                for (ASN1ObjectIdentifier attrType : attributes.keySet()) {
                    csrBuilder.addAttribute(attrType, attributes.get(attrType));
                }
            }
            try {
                signer0 = signer.borrowSigner();
            }
            catch (NoIdleSignerException ex) {
                throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
            }
            try {
                PKCS10CertificationRequest pKCS10CertificationRequest = csrBuilder.build((ContentSigner)signer0.value());
                return pKCS10CertificationRequest;
            }
            finally {
                signer.requiteSigner(signer0);
            }
        }

        private List<String> resolveExtensionTypes(List<String> types) throws IllegalCmdParamException {
            ArrayList<String> list = new ArrayList<String>(types.size());
            for (String m : types) {
                String id = Completers.ExtensionNameCompleter.getIdForExtensionName((String)m);
                if (id != null) continue;
                try {
                    id = new ASN1ObjectIdentifier(m).getId();
                }
                catch (Exception ex) {
                    throw new IllegalCmdParamException("invalid extension type " + m);
                }
            }
            return list;
        }
    }

    @Command(scope="xi", name="crl-info", description="print CRL information")
    @Service
    public static class CrlInfo
    extends SecurityAction {
        @Option(name="--in", description="CRL file")
        @Completion(value=FileCompleter.class)
        private String inFile;
        @Option(name="--hex", aliases={"-h"}, description="print hex number")
        private Boolean hex = Boolean.FALSE;
        @Option(name="--crlnumber", description="print CRL number")
        private Boolean crlNumber;
        @Option(name="--issuer", description="print issuer")
        private Boolean issuer;
        @Option(name="--this-update", description="print thisUpdate")
        private Boolean thisUpdate;
        @Option(name="--next-update", description="print nextUpdate")
        private Boolean nextUpdate;

        protected Object execute0() throws Exception {
            CertificateList crl = CertificateList.getInstance((Object)X509Util.toDerEncoded((byte[])IoUtil.read((String)this.inFile)));
            if (this.crlNumber != null && this.crlNumber.booleanValue()) {
                ASN1Encodable asn1 = crl.getTBSCertList().getExtensions().getExtensionParsedValue(Extension.cRLNumber);
                if (asn1 == null) {
                    return "null";
                }
                return this.getNumber(ASN1Integer.getInstance((Object)asn1).getPositiveValue());
            }
            if (this.issuer != null && this.issuer.booleanValue()) {
                return crl.getIssuer().toString();
            }
            if (this.thisUpdate != null && this.thisUpdate.booleanValue()) {
                return this.toUtcTimeyyyyMMddhhmmssZ(crl.getThisUpdate().getDate());
            }
            if (this.nextUpdate != null && this.nextUpdate.booleanValue()) {
                return crl.getNextUpdate() == null ? "null" : this.toUtcTimeyyyyMMddhhmmssZ(crl.getNextUpdate().getDate());
            }
            return null;
        }

        private String getNumber(Number no) {
            if (!this.hex.booleanValue()) {
                return no.toString();
            }
            if (no instanceof Byte) {
                return "0X" + Hex.encode((byte[])new byte[]{(Byte)no});
            }
            if (no instanceof Short) {
                return "0X" + Integer.toHexString(((Short)no).shortValue());
            }
            if (no instanceof Integer) {
                return "0X" + Integer.toHexString((Integer)no);
            }
            if (no instanceof Long) {
                return "0X" + Long.toHexString((Long)no);
            }
            if (no instanceof Long) {
                return "0X" + Long.toHexString((Long)no);
            }
            if (no instanceof BigInteger) {
                return "0X" + ((BigInteger)no).toString(16);
            }
            return no.toString();
        }
    }

    @Command(scope="xi", name="convert-keystore", description="Convert keystore")
    @Service
    public static class ConvertKeystore
    extends SecurityAction {
        @Option(name="--in", required=true, description="source keystore file")
        @Completion(value=FileCompleter.class)
        private String inFile;
        @Option(name="--intype", required=true, description="type of the source keystore")
        @Completion(value=SecurityCompleters.KeystoreTypeCompleter.class)
        private String inType;
        @Option(name="--inpwd", description="password of the source keystore")
        private String inPwd;
        @Option(name="--out", required=true, description="destination keystore file")
        @Completion(value=FileCompleter.class)
        private String outFile;
        @Option(name="--outtype", required=true, description="type of the destination keystore")
        @Completion(value=SecurityCompleters.KeystoreTypeCompleter.class)
        private String outType;
        @Option(name="--outpwd", description="password of the destination keystore")
        private String outPwd;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            File realOutFile;
            File realInFile = new File(IoUtil.expandFilepath((String)this.inFile));
            if (CompareUtil.equalsObject((Object)realInFile, (Object)(realOutFile = new File(IoUtil.expandFilepath((String)this.outFile))))) {
                throw new IllegalCmdParamException("in and out cannot be the same");
            }
            KeyStore inKs = KeyStore.getInstance(this.inType);
            KeyStore outKs = KeyStore.getInstance(this.outType);
            outKs.load(null);
            char[] inPassword = this.readPasswordIfNotSet("password of the source keystore", this.inPwd);
            try (InputStream inStream = Files.newInputStream(realInFile.toPath(), new OpenOption[0]);){
                inKs.load(inStream, inPassword);
            }
            char[] outPassword = this.readPasswordIfNotSet("password of the destination keystore", this.outPwd);
            Enumeration<String> aliases = inKs.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (inKs.isKeyEntry(alias)) {
                    java.security.cert.Certificate[] certs = inKs.getCertificateChain(alias);
                    Key key = inKs.getKey(alias, inPassword);
                    outKs.setKeyEntry(alias, key, outPassword, certs);
                    continue;
                }
                java.security.cert.Certificate cert = inKs.getCertificate(alias);
                outKs.setCertificateEntry(alias, cert);
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);
            outKs.store(bout, outPassword);
            this.saveVerbose("saved destination keystore to file", realOutFile, bout.toByteArray());
            return null;
        }
    }

    @Command(scope="xi", name="cert-info", description="print certificate information")
    @Service
    public static class CertInfo
    extends SecurityAction {
        @Option(name="--in", description="certificate file")
        @Completion(value=FileCompleter.class)
        private String inFile;
        @Option(name="--hex", aliases={"-h"}, description="print hex number")
        private Boolean hex = Boolean.FALSE;
        @Option(name="--serial", description="print serial number")
        private Boolean serial;
        @Option(name="--subject", description="print subject")
        private Boolean subject;
        @Option(name="--issuer", description="print issuer")
        private Boolean issuer;
        @Option(name="--not-before", description="print notBefore")
        private Boolean notBefore;
        @Option(name="--not-after", description="print notAfter")
        private Boolean notAfter;
        @Option(name="--fingerprint", description="print fingerprint in hex")
        private Boolean fingerprint;
        @Option(name="--hash", description="hash algorithm name")
        @Completion(value=Completers.HashAlgCompleter.class)
        protected String hashAlgo = "SHA256";

        protected Object execute0() throws Exception {
            X509Cert cert = X509Util.parseCert((byte[])IoUtil.read((String)this.inFile));
            if (this.serial != null && this.serial.booleanValue()) {
                return this.getNumber(cert.getSerialNumber());
            }
            if (this.subject != null && this.subject.booleanValue()) {
                return cert.getSubject().toString();
            }
            if (this.issuer != null && this.issuer.booleanValue()) {
                return cert.getIssuer().toString();
            }
            if (this.notBefore != null && this.notBefore.booleanValue()) {
                return this.toUtcTimeyyyyMMddhhmmssZ(cert.getNotBefore());
            }
            if (this.notAfter != null && this.notAfter.booleanValue()) {
                return this.toUtcTimeyyyyMMddhhmmssZ(cert.getNotAfter());
            }
            if (this.fingerprint != null && this.fingerprint.booleanValue()) {
                byte[] encoded = cert.getEncoded();
                return HashAlgo.getInstance((String)this.hashAlgo).hexHash((byte[][])new byte[][]{encoded});
            }
            return null;
        }

        private String getNumber(Number no) {
            if (!this.hex.booleanValue()) {
                return no.toString();
            }
            if (no instanceof Byte) {
                return "0x" + Hex.encode((byte[])new byte[]{(Byte)no});
            }
            if (no instanceof Short) {
                return "0x" + Integer.toHexString(((Short)no).shortValue());
            }
            if (no instanceof Integer) {
                return "0x" + Integer.toHexString((Integer)no);
            }
            if (no instanceof Long) {
                return "0x" + Long.toHexString((Long)no);
            }
            if (no instanceof Long) {
                return "0x" + Long.toHexString((Long)no);
            }
            if (no instanceof BigInteger) {
                return "0x" + ((BigInteger)no).toString(16);
            }
            return no.toString();
        }
    }
}

