/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.EdECConstants;
import org.xipki.security.SecurityFactory;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.qa.JceSignSpeed;
import org.xipki.security.qa.P11KeyGenSpeed;
import org.xipki.security.qa.P11SignSpeed;
import org.xipki.security.qa.P12KeyGenSpeed;
import org.xipki.security.qa.P12SignSpeed;
import org.xipki.security.shell.P11Actions;
import org.xipki.security.shell.QaCompleters;
import org.xipki.security.shell.SecurityCompleters;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.Args;
import org.xipki.util.BenchmarkExecutor;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class QaSecurityActions {
    private static ASN1ObjectIdentifier getCurveOid(String curveName) {
        ASN1ObjectIdentifier curveOid = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)curveName);
        if (curveOid == null) {
            throw new IllegalArgumentException("unknown curveName " + curveName);
        }
        return curveOid;
    }

    private static Queue<KeyControl.DSA> getKeyControlDSA() {
        LinkedList<KeyControl.DSA> queue = new LinkedList<KeyControl.DSA>();
        queue.add(new KeyControl.DSA(1024, 160));
        queue.add(new KeyControl.DSA(2048, 224));
        queue.add(new KeyControl.DSA(2048, 256));
        queue.add(new KeyControl.DSA(3072, 256));
        return queue;
    }

    private static Queue<KeyControl.RSA> getKeyControlRSA() {
        LinkedList<KeyControl.RSA> queue = new LinkedList<KeyControl.RSA>();
        queue.add(new KeyControl.RSA(1024));
        queue.add(new KeyControl.RSA(2048));
        queue.add(new KeyControl.RSA(3072));
        queue.add(new KeyControl.RSA(4096));
        return queue;
    }

    private static Queue<KeyControl.EC> getKeyControlEC() {
        LinkedList<KeyControl.EC> queue = new LinkedList<KeyControl.EC>();
        for (String curveName : AlgorithmUtil.getECCurveNames()) {
            queue.add(new KeyControl.EC(curveName));
        }
        return queue;
    }

    static /* synthetic */ Queue access$100() {
        return QaSecurityActions.getKeyControlDSA();
    }

    static /* synthetic */ Queue access$200() {
        return QaSecurityActions.getKeyControlEC();
    }

    static /* synthetic */ Queue access$500() {
        return QaSecurityActions.getKeyControlRSA();
    }

    @Command(scope="xi", name="qa-batch-ec-p11", description="(QA) generate EC keypairs for all known curves in PKCS#11 device")
    @Service
    public static class BECGenP11
    extends P11Actions.P11KeyGenAction {
        protected Object execute0() throws Exception {
            String[] edeccurves;
            P11Slot slot = this.getSlot();
            String labelPrefix = this.label + "-";
            Enumeration allNames = ECNamedCurveTable.getNames();
            while (allNames.hasMoreElements()) {
                String curveName = (String)allNames.nextElement();
                ASN1ObjectIdentifier curveOid = EdECConstants.getCurveOid((String)curveName);
                if (curveOid == null) {
                    curveOid = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)curveName);
                }
                if (curveOid == null) {
                    System.out.println("!!! ignore unknown curve " + curveName);
                    continue;
                }
                this.label = labelPrefix + curveName;
                this.finalize("EC", slot.generateECKeypair(curveOid, this.getControl()));
            }
            for (String curveName : edeccurves = new String[]{"ED25519", "ED448", "X25519", "X448"}) {
                this.label = labelPrefix + curveName;
                this.finalize("EC", slot.generateECKeypair(EdECConstants.getCurveOid((String)curveName), this.getControl()));
            }
            return null;
        }
    }

    @Command(scope="xi", name="speed-sign-jce", description="performance test of JCE signature creation")
    @Service
    public static class SpeedSignJce
    extends SingleSpeedActionQa {
        @Option(name="--type", required=true, description="JCE signer type")
        private String type;
        @Option(name="--alias", required=true, description="alias of the key in the JCE device")
        private String alias;
        @Option(name="--algo", required=true, description="signature algorithm")
        @Completion(value=SecurityCompleters.SignAlgoCompleter.class)
        private String algo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new JceSignSpeed(this.securityFactory, this.type, this.alias, this.algo, "alias-" + this.alias + "_algo-" + this.algo, this.getNumThreads());
        }
    }

    @Command(scope="xi", name="speed-sm2-sign-p12", description="performance test of PKCS#12 SM2 signature creation")
    @Service
    public static class SpeedSm2SignP12
    extends SpeedP12SignActionQa {
        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12SignSpeed.SM2(this.securityFactory, this.getNumThreads());
        }
    }

    @Command(scope="xi", name="speed-sm2-gen-p12", description="performance test of PKCS#12 SM2 key generation")
    @Service
    public static class SpeedSm2GenP12
    extends SingleSpeedActionQa {
        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12KeyGenSpeed.EC(GMObjectIdentifiers.sm2p256v1, this.securityFactory);
        }
    }

    public static abstract class SpeedP12SignActionQa
    extends SingleSpeedActionQa {
    }

    @Command(scope="xi", name="speed-rsa-sign-p12", description="performance test of PKCS#12 RSA signature creation")
    @Service
    public static class SpeedRsaSignP12
    extends SpeedP12SignActionQa {
        @Option(name="--key-size", description="keysize in bit")
        private Integer keysize = 2048;
        @Option(name="-e", description="public exponent")
        private String publicExponent = "0x10001";
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.RSASigAlgCompleter.class)
        private String signAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12SignSpeed.RSA(this.securityFactory, this.signAlgo, this.getNumThreads(), this.keysize.intValue(), SpeedRsaSignP12.toBigInt((String)this.publicExponent));
        }
    }

    @Command(scope="xi", name="speed-rsa-gen-p12", description="performance test of PKCS#12 RSA key generation")
    @Service
    public static class SpeedRsaGenP12
    extends SingleSpeedActionQa {
        @Option(name="--key-size", description="keysize in bit")
        private Integer keysize = 2048;
        @Option(name="-e", description="public exponent")
        private String publicExponent = "0x10001";

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12KeyGenSpeed.RSA(this.keysize.intValue(), SpeedRsaGenP12.toBigInt((String)this.publicExponent), this.securityFactory);
        }
    }

    @Command(scope="xi", name="speed-hmac-sign-p12", description="performance test of PKCS#12 HMAC signature creation")
    @Service
    public static class SpeedHmacSignP12
    extends SpeedP12SignActionQa {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.HMACSigAlgCompleter.class)
        private String signAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12SignSpeed.HMAC(this.securityFactory, this.signAlgo, this.getNumThreads());
        }
    }

    @Command(scope="xi", name="speed-ed-sign-p12", description="performance test of PKCS#12 EdDSA signature creation")
    @Service
    public static class SpeedEdSignP12
    extends SpeedP12SignActionQa {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.EDDSASigAlgCompleter.class)
        private String signAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12SignSpeed.EC(this.securityFactory, this.signAlgo, this.getNumThreads(), EdECConstants.getCurveOid((String)this.signAlgo));
        }
    }

    @Command(scope="xi", name="speed-ed-gen-p12", description="performance test of PKCS#12 Edwards and montgomery EC key generation")
    @Service
    public static class SpeedEdGenP12
    extends SingleSpeedActionQa {
        @Option(name="--curve", required=true, description="curve name")
        @Completion(value=Completers.EdCurveNameCompleter.class)
        private String curveName;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12KeyGenSpeed.EC(QaSecurityActions.getCurveOid(this.curveName), this.securityFactory);
        }
    }

    @Command(scope="xi", name="speed-ec-sign-p12", description="performance test of PKCS#12 EC signature creation")
    @Service
    public static class SpeedEcSignP12
    extends SpeedP12SignActionQa {
        @Option(name="--curve", required=true, description="EC curve name")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName;
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.ECDSASigAlgCompleter.class)
        private String signAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12SignSpeed.EC(this.securityFactory, this.signAlgo, this.getNumThreads(), QaSecurityActions.getCurveOid(this.curveName));
        }
    }

    @Command(scope="xi", name="speed-ec-gen-p12", description="performance test of PKCS#12 EC key generation")
    @Service
    public static class SpeedEcGenP12
    extends SingleSpeedActionQa {
        @Option(name="--curve", required=true, description="EC curve name")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12KeyGenSpeed.EC(QaSecurityActions.getCurveOid(this.curveName), this.securityFactory);
        }
    }

    @Command(scope="xi", name="speed-dsa-sign-p12", description="performance test of PKCS#12 DSA signature creation")
    @Service
    public static class SpeedDsaSignP12
    extends SpeedP12SignActionQa {
        @Option(name="--plen", description="bit length of the prime")
        private Integer plen = 2048;
        @Option(name="--qlen", description="bit length of the sub-prime")
        private Integer qlen;
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.DSASigAlgCompleter.class)
        private String signAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            if (this.qlen == null) {
                this.qlen = this.plen >= 2048 ? 256 : 160;
            }
            return new P12SignSpeed.DSA(this.securityFactory, this.signAlgo, this.getNumThreads(), this.plen.intValue(), this.qlen.intValue());
        }
    }

    @Command(scope="xi", name="speed-dsa-gen-p12", description="performance test of PKCS#12 DSA key generation")
    @Service
    public static class SpeedDsaGenP12
    extends SingleSpeedActionQa {
        @Option(name="--plen", description="bit length of the prime")
        private Integer plen = 2048;
        @Option(name="--qlen", description="bit length of the sub-prime")
        private Integer qlen;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            if (this.qlen == null) {
                this.qlen = this.plen >= 2048 ? 256 : 160;
            }
            return new P12KeyGenSpeed.DSA(this.plen.intValue(), this.qlen.intValue(), this.securityFactory);
        }
    }

    @Command(scope="xi", name="speed-gmac-sign-p12", description="performance test of PKCS#12 AES GMAC signature creation")
    @Service
    public static class SpeedP12AESGmacSignActionQa
    extends SpeedP12SignActionQa {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.GMACSigAlgCompleter.class)
        private String signAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P12SignSpeed.AESGmac(this.securityFactory, this.signAlgo, this.getNumThreads());
        }
    }

    public static abstract class BSpeedP12SignActionQa
    extends BatchSpeedActionQa {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        protected String signAlgo;
    }

    @Command(scope="xi", name="bspeed-rsa-sign-p12", description="performance test of PKCS#12 RSA signature creation (batch)")
    @Service
    public static class BspeedRsaSignP12
    extends BSpeedP12SignActionQa {
        private final Queue<KeyControl.RSA> queue = QaSecurityActions.access$500();

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.RSA control = this.queue.poll();
            return control == null ? null : new P12SignSpeed.RSA(this.securityFactory, this.signAlgo, this.getNumThreads(), control.modulusLen(), RSAKeyGenParameterSpec.F4);
        }
    }

    @Command(scope="xi", name="bspeed-rsa-gen-p12", description="performance test of PKCS#12 RSA key generation (batch)")
    @Service
    public static class BspeedRsaGenP12
    extends BatchSpeedActionQa {
        private final Queue<KeyControl.RSA> queue = QaSecurityActions.access$500();

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.RSA control = this.queue.poll();
            return control == null ? null : new P12KeyGenSpeed.RSA(control.modulusLen(), RSAKeyGenParameterSpec.F4, this.securityFactory);
        }
    }

    @Command(scope="xi", name="bspeed-ec-sign-p12", description="performance test of PKCS#12 EC signature creation (batch)")
    @Service
    public static class BspeedEcSignP12
    extends BSpeedP12SignActionQa {
        private final Queue<KeyControl.EC> queue = QaSecurityActions.access$200();

        @Override
        protected synchronized BenchmarkExecutor nextTester() throws Exception {
            KeyControl.EC control = this.queue.poll();
            boolean isSm2SignAlgo = this.signAlgo.toUpperCase(Locale.ROOT).contains("SM2");
            while (control != null) {
                boolean match;
                boolean bl = control.curveName.toUpperCase(Locale.ROOT).contains("SM2") ? isSm2SignAlgo : (match = !isSm2SignAlgo);
                if (match) break;
                control = this.queue.poll();
            }
            return control == null ? null : new P12SignSpeed.EC(this.securityFactory, this.signAlgo, this.getNumThreads(), QaSecurityActions.getCurveOid(control.curveName()));
        }
    }

    @Command(scope="xi", name="bspeed-ec-gen-p12", description="performance test of PKCS#12 EC key generation (batch)")
    @Service
    public static class BspeedEcGenP12
    extends BatchSpeedActionQa {
        private final Queue<KeyControl.EC> queue = QaSecurityActions.access$200();

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.EC control = this.queue.poll();
            return new P12KeyGenSpeed.EC(QaSecurityActions.getCurveOid(control.curveName()), this.securityFactory);
        }
    }

    @Command(scope="xi", name="bspeed-dsa-sign-p12", description="performance test of PKCS#12 DSA signature creation")
    @Service
    public static class BspeedDsaSignP12
    extends BSpeedP12SignActionQa {
        private final Queue<KeyControl.DSA> queue = QaSecurityActions.access$100();

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.DSA control = this.queue.poll();
            if (control == null) {
                return null;
            }
            if (control.plen() == 1024) {
                this.signAlgo = "SHA1withDSA";
            }
            return new P12SignSpeed.DSA(this.securityFactory, this.signAlgo, this.getNumThreads(), control.plen(), control.qlen());
        }
    }

    @Command(scope="xi", name="bspeed-dsa-gen-p12", description="performance test of PKCS#12 DSA key generation (batch)")
    @Service
    public static class BspeedDsaGenP12
    extends BatchSpeedActionQa {
        private final Queue<KeyControl.DSA> queue = QaSecurityActions.access$100();

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.DSA control = this.queue.poll();
            return control == null ? null : new P12KeyGenSpeed.DSA(control.plen(), control.qlen(), this.securityFactory);
        }
    }

    @Command(scope="xi", name="speed-sm2-sign-p11", description="performance test of PKCS#11 SM2 signature creation")
    @Service
    public static class SpeedSm2SignP11
    extends SpeedP11SignActionQa {
        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11SignSpeed.SM2(this.keyPresent.booleanValue(), this.securityFactory, this.getSlot(), this.getKeyId(), this.keyLabel, this.getNumThreads());
        }
    }

    @Command(scope="xi", name="speed-sm2-gen-p11", description="performance test of PKCS#11 SM2 key generation")
    @Service
    public static class SpeedSm2GenP11
    extends SpeedP11ActionQa {
        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11KeyGenSpeed.SM2(this.getSlot());
        }

        @Override
        protected int getNumThreads() {
            return this.getKeyId() == null ? super.getNumThreads() : 1;
        }
    }

    public static abstract class SpeedP11SignActionQa
    extends SpeedP11ActionQa {
        @Option(name="--key-present", description="the PKCS#11 key is present")
        protected Boolean keyPresent = Boolean.FALSE;
        @Option(name="--key-label", description="label of the PKCS#11 key")
        protected String keyLabel;
    }

    @Command(scope="xi", name="speed-rsa-sign-p11", description="performance test of PKCS#11 RSA signature creation")
    @Service
    public static class SpeedRsaSignP11
    extends SpeedP11SignActionQa {
        @Option(name="--key-size", description="keysize in bit")
        private Integer keysize = 2048;
        @Option(name="-e", description="public exponent")
        private String publicExponent = "0x10001";
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.RSASigAlgCompleter.class)
        private String signAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11SignSpeed.RSA(this.keyPresent.booleanValue(), this.securityFactory, this.getSlot(), this.getKeyId(), this.keyLabel, this.signAlgo, this.getNumThreads(), this.keysize.intValue(), SpeedRsaSignP11.toBigInt((String)this.publicExponent));
        }
    }

    @Command(scope="xi", name="speed-rsa-gen-p11", description="performance test of PKCS#11 RSA key generation")
    @Service
    public static class SpeedRsaGenP11
    extends SpeedP11ActionQa {
        @Option(name="--key-size", description="keysize in bit")
        private Integer keysize = 2048;
        @Option(name="--exponent", aliases={"-e"}, description="public exponent")
        private String publicExponent = "0x10001";

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11KeyGenSpeed.RSA(this.getSlot(), this.keysize.intValue(), SpeedRsaGenP11.toBigInt((String)this.publicExponent));
        }

        @Override
        protected int getNumThreads() {
            return this.getKeyId() == null ? super.getNumThreads() : 1;
        }
    }

    @Command(scope="xi", name="speed-hmac-sign-p11", description="performance test of PKCS#11 HMAC signature creation")
    @Service
    public static class SpeedHmacSignP11
    extends SpeedP11SignActionQa {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.HMACSigAlgCompleter.class)
        private String signAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11SignSpeed.HMAC(this.keyPresent.booleanValue(), this.securityFactory, this.getSlot(), this.getKeyId(), this.keyLabel, this.signAlgo, this.getNumThreads());
        }
    }

    @Command(scope="xi", name="speed-ed-sign-p11", description="performance test of PKCS#11 EdDSA signature creation")
    @Service
    public static class SpeedEdSignP11
    extends SpeedP11SignActionQa {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.EDDSASigAlgCompleter.class)
        private String signAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            ASN1ObjectIdentifier curveOid = EdECConstants.getCurveOid((String)this.signAlgo);
            if (curveOid == null) {
                throw new IllegalCmdParamException("invalid signAlgo " + this.signAlgo);
            }
            return new P11SignSpeed.EC(this.keyPresent.booleanValue(), this.securityFactory, this.getSlot(), this.getKeyId(), this.keyLabel, this.signAlgo, this.getNumThreads(), curveOid);
        }
    }

    @Command(scope="xi", name="speed-ed-gen-p11", description="performance test of PKCS#11 Edwards and montgomery EC key generation")
    @Service
    public static class SpeedEdGenP11
    extends SpeedP11ActionQa {
        @Option(name="--curve", required=true, description="curve name")
        @Completion(value=Completers.EdCurveNameCompleter.class)
        private String curveName;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11KeyGenSpeed.EC(this.getSlot(), QaSecurityActions.getCurveOid(this.curveName));
        }

        @Override
        protected int getNumThreads() {
            return this.getKeyId() == null ? super.getNumThreads() : 1;
        }
    }

    @Command(scope="xi", name="speed-ec-sign-p11", description="performance test of PKCS#11 EC signature creation")
    @Service
    public static class SpeedEcSignP11
    extends SpeedP11SignActionQa {
        @Option(name="--curve", description="EC curve name")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName = "secp256r1";
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.ECDSASigAlgCompleter.class)
        private String signAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11SignSpeed.EC(this.keyPresent.booleanValue(), this.securityFactory, this.getSlot(), this.getKeyId(), this.keyLabel, this.signAlgo, this.getNumThreads(), AlgorithmUtil.getCurveOidForCurveNameOrOid((String)this.curveName));
        }
    }

    @Command(scope="xi", name="speed-ec-gen-p11", description="performance test of PKCS#11 EC key generation")
    @Service
    public static class SpeedEcGenP11
    extends SpeedP11ActionQa {
        @Option(name="--curve", required=true, description="EC curve name")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            return new P11KeyGenSpeed.EC(this.getSlot(), QaSecurityActions.getCurveOid(this.curveName));
        }

        @Override
        protected int getNumThreads() {
            return this.getKeyId() == null ? super.getNumThreads() : 1;
        }
    }

    @Command(scope="xi", name="speed-dsa-sign-p11", description="performance test of PKCS#11 DSA signature creation")
    @Service
    public static class SpeedDsaSignP11
    extends SpeedP11SignActionQa {
        @Option(name="--plen", description="bit length of the prime")
        private Integer plen = 2048;
        @Option(name="--qlen", description="bit length of the sub-prime")
        private Integer qlen;
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.DSASigAlgCompleter.class)
        private String signAlgo;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            if (this.qlen == null) {
                this.qlen = this.plen >= 2048 ? 256 : 160;
            }
            if (this.plen == 1024 && !"SHA1withDSA".equalsIgnoreCase(this.signAlgo)) {
                throw new IllegalCmdParamException("only SHA1withDSA is permitted for DSA with 1024 bit");
            }
            return new P11SignSpeed.DSA(this.keyPresent.booleanValue(), this.securityFactory, this.getSlot(), this.getKeyId(), this.keyLabel, this.signAlgo, this.getNumThreads(), this.plen.intValue(), this.qlen.intValue());
        }
    }

    @Command(scope="xi", name="speed-dsa-gen-p11", description="performance test of PKCS#11 DSA key generation")
    @Service
    public static class SpeedDsaGenP11
    extends SpeedP11ActionQa {
        @Option(name="--plen", description="bit length of the prime")
        private Integer plen = 2048;
        @Option(name="--qlen", description="bit length of the sub-prime")
        private Integer qlen;

        @Override
        protected BenchmarkExecutor getTester() throws Exception {
            if (this.qlen == null) {
                this.qlen = this.plen >= 2048 ? 256 : 160;
            }
            return new P11KeyGenSpeed.DSA(this.getSlot(), this.plen.intValue(), this.qlen.intValue());
        }

        @Override
        protected int getNumThreads() {
            return this.getKeyId() == null ? super.getNumThreads() : 1;
        }
    }

    public static abstract class SpeedP11ActionQa
    extends SingleSpeedActionQa {
        @Reference(optional=true)
        protected P11CryptServiceFactory p11CryptServiceFactory;
        @Option(name="--key-id", description="id (hex) of the PKCS#11 key")
        private String hexKeyId;
        @Option(name="--slot", description="slot index")
        protected int slotIndex = 0;
        @Option(name="--module", description="Name of the PKCS#11 module.")
        @Completion(value=SecurityCompleters.P11ModuleNameCompleter.class)
        protected String moduleName = "default";

        protected P11Slot getSlot() throws XiSecurityException, TokenException, IllegalCmdParamException {
            P11CryptService p11Service = this.p11CryptServiceFactory.getP11CryptService(this.moduleName);
            if (p11Service == null) {
                throw new IllegalCmdParamException("undefined module " + this.moduleName);
            }
            P11Module module = p11Service.getModule();
            return module.getSlot(module.getSlotIdForIndex(this.slotIndex));
        }

        protected byte[] getKeyId() {
            return StringUtil.isBlank((String)this.hexKeyId) ? null : Hex.decode((String)this.hexKeyId);
        }
    }

    @Command(scope="xi", name="bspeed-rsa-sign-p11", description="performance test of PKCS#11 RSA signature creation (batch)")
    @Service
    public static class BspeedRsaSignP11
    extends BSpeedP11ActionQa {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.RSASigAlgCompleter.class)
        private String signAlgo;
        private final Queue<KeyControl.RSA> queue = QaSecurityActions.access$500();

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.RSA control = this.queue.poll();
            return control == null ? null : new P11SignSpeed.RSA(this.securityFactory, this.getSlot(), this.getKeyId(), this.signAlgo, this.getNumThreads(), control.modulusLen(), RSAKeyGenParameterSpec.F4);
        }
    }

    @Command(scope="xi", name="bspeed-rsa-gen-p11", description="performance test of PKCS#11 RSA key generation (batch)")
    @Service
    public static class BspeedRsaGenP11
    extends BSpeedP11ActionQa {
        private final Queue<KeyControl.RSA> queue = QaSecurityActions.access$500();

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.RSA control = this.queue.poll();
            return control == null ? null : new P11KeyGenSpeed.RSA(this.getSlot(), control.modulusLen(), RSAKeyGenParameterSpec.F4);
        }
    }

    @Command(scope="xi", name="bspeed-ec-sign-p11", description="performance test of PKCS#11 EC signature creation (batch)")
    @Service
    public static class BspeedEcSignP11
    extends BSpeedP11ActionQa {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.ECDSASigAlgCompleter.class)
        private String signAlgo;
        private final Queue<KeyControl.EC> queue = QaSecurityActions.access$200();

        @Override
        protected synchronized BenchmarkExecutor nextTester() throws Exception {
            KeyControl.EC control = this.queue.poll();
            boolean isSm2SignAlgo = this.signAlgo.toUpperCase(Locale.ROOT).contains("SM2");
            while (control != null) {
                boolean match;
                boolean bl = control.curveName.toUpperCase(Locale.ROOT).contains("SM2") ? isSm2SignAlgo : (match = !isSm2SignAlgo);
                if (match) break;
                control = this.queue.poll();
            }
            if (control == null) {
                return null;
            }
            return new P11SignSpeed.EC(this.securityFactory, this.getSlot(), this.getKeyId(), this.signAlgo, this.getNumThreads(), AlgorithmUtil.getCurveOidForCurveNameOrOid((String)control.curveName));
        }
    }

    @Command(scope="xi", name="bspeed-ec-gen-p11", description="performance test of PKCS#11 EC key generation (batch)")
    @Service
    public static class BspeedEcGenP11
    extends BSpeedP11ActionQa {
        private final Queue<KeyControl.EC> queue = QaSecurityActions.access$200();

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.EC control = this.queue.poll();
            if (control == null) {
                return null;
            }
            return new P11KeyGenSpeed.EC(this.getSlot(), QaSecurityActions.getCurveOid(control.curveName()));
        }

        protected int getNumThreads(int numThreads) {
            return this.getKeyId() == null ? numThreads : 1;
        }
    }

    @Command(scope="xi", name="bspeed-dsa-sign-p11", description="performance test of PKCS#11 DSA signature creation (batch)")
    @Service
    public static class BspeedDsaSignP11
    extends BSpeedP11ActionQa {
        @Option(name="--sig-algo", required=true, description="signature algorithm")
        @Completion(value=QaCompleters.DSASigAlgCompleter.class)
        private String signAlgo;
        private final Queue<KeyControl.DSA> queue = QaSecurityActions.access$100();

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.DSA control = this.queue.poll();
            if (control == null) {
                return null;
            }
            if (control.plen() == 1024 && !"SHA1withDSA".equalsIgnoreCase(this.signAlgo)) {
                throw new IllegalCmdParamException("only SHA1withDSA is permitted for DSA with 1024 bit");
            }
            return new P11SignSpeed.DSA(this.securityFactory, this.getSlot(), this.getKeyId(), this.signAlgo, this.getNumThreads(), control.plen(), control.qlen());
        }
    }

    @Command(scope="xi", name="bspeed-dsa-gen-p11", description="performance test of PKCS#11 DSA key generation (batch)")
    @Service
    public static class BspeedDsaGenP11
    extends BSpeedP11ActionQa {
        private final Queue<KeyControl.DSA> queue = QaSecurityActions.access$100();

        @Override
        protected BenchmarkExecutor nextTester() throws Exception {
            KeyControl.DSA control = this.queue.poll();
            return control == null ? null : new P11KeyGenSpeed.DSA(this.getSlot(), control.plen(), control.qlen());
        }

        @Override
        protected int getNumThreads() {
            return this.getKeyId() == null ? super.getNumThreads() : 1;
        }
    }

    public static abstract class BSpeedP11ActionQa
    extends BatchSpeedActionQa {
        @Reference(optional=true)
        protected P11CryptServiceFactory p11CryptServiceFactory;
        @Option(name="--key-id", description="id (hex) of the PKCS#11 key")
        private String hexKeyId;
        @Option(name="--slot", description="slot index")
        protected int slotIndex = 0;
        @Option(name="--module", description="name of the PKCS#11 module.")
        @Completion(value=SecurityCompleters.P11ModuleNameCompleter.class)
        protected String moduleName = "default";

        protected P11Slot getSlot() throws XiSecurityException, TokenException, IllegalCmdParamException {
            P11CryptService p11Service = this.p11CryptServiceFactory.getP11CryptService(this.moduleName);
            if (p11Service == null) {
                throw new IllegalCmdParamException("undefined module " + this.moduleName);
            }
            P11Module module = p11Service.getModule();
            return module.getSlot(module.getSlotIdForIndex(this.slotIndex));
        }

        protected byte[] getKeyId() {
            return StringUtil.isBlank((String)this.hexKeyId) ? null : Hex.decode((String)this.hexKeyId);
        }
    }

    public static abstract class BatchSpeedActionQa
    extends QaSecurityAction {
        private static final Logger LOG = LoggerFactory.getLogger(BatchSpeedActionQa.class);
        @Option(name="--duration", description="duration for each test case")
        private String duration = "10s";
        @Option(name="--thread", description="number of threads")
        private Integer numThreads = 5;

        protected abstract BenchmarkExecutor nextTester() throws Exception;

        protected Object execute0() throws InterruptedException {
            block3: {
                while (true) {
                    BenchmarkExecutor tester;
                    this.println("============================================");
                    try {
                        tester = this.nextTester();
                    }
                    catch (Exception ex) {
                        String msg = "could not get nextTester";
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        this.println(msg + ": " + ex.getMessage());
                        continue;
                    }
                    if (tester == null) break block3;
                    tester.setDuration(this.duration).setThreads(this.numThreads.intValue()).execute();
                    if (tester.isInterrupted()) break;
                }
                throw new InterruptedException("cancelled by the user");
            }
            return null;
        }

        protected int getNumThreads() {
            return this.numThreads;
        }
    }

    public static abstract class SingleSpeedActionQa
    extends QaSecurityAction {
        @Option(name="--duration", description="duration")
        private String duration = "30s";
        @Option(name="--thread", description="number of threads")
        private Integer numThreads = 5;

        protected abstract BenchmarkExecutor getTester() throws Exception;

        protected Object execute0() throws Exception {
            this.getTester().setDuration(this.duration).setThreads(this.getNumThreads()).execute();
            return null;
        }

        protected int getNumThreads() {
            return this.numThreads;
        }
    }

    public static abstract class QaSecurityAction
    extends XiAction {
        @Reference
        protected SecurityFactory securityFactory;
    }

    private static class KeyControl {
        private KeyControl() {
        }

        public static class RSA
        extends KeyControl {
            private final int modulusLen;

            public RSA(int modulusLen) {
                this.modulusLen = modulusLen;
            }

            public int modulusLen() {
                return this.modulusLen;
            }
        }

        public static class EC
        extends KeyControl {
            private final String curveName;

            public EC(String curveName) {
                this.curveName = Args.notBlank((String)curveName, (String)"curveName");
            }

            public String curveName() {
                return this.curveName;
            }
        }

        public static class DSA
        extends KeyControl {
            private final int plen;
            private final int qlen;

            public DSA(int plen, int qlen) {
                this.plen = plen;
                this.qlen = qlen;
            }

            public int plen() {
                return this.plen;
            }

            public int qlen() {
                return this.qlen;
            }
        }
    }
}

