/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.shell;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.FileUtils;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.Args;
import org.xipki.util.Curl;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class Actions {

    @Command(scope="xi", name="rm", description="remove file or directory")
    @Service
    public static class Rm
    extends XiAction {
        @Argument(index=0, name="file", required=true, description="file or directory to be deleted")
        @Completion(value=FileCompleter.class)
        private String targetPath;
        @Option(name="--recursive", aliases={"-r"}, description="remove directories and their contents recursively")
        private Boolean recursive = Boolean.FALSE;
        @Option(name="--force", aliases={"-f"}, description="remove files without prompt")
        private Boolean force = Boolean.FALSE;

        @Override
        protected Object execute0() throws Exception {
            this.targetPath = Rm.expandFilepath(this.targetPath);
            File target = new File(this.targetPath);
            if (!target.exists()) {
                return null;
            }
            if (target.isDirectory()) {
                if (!this.recursive.booleanValue()) {
                    this.println("Please use option --recursive to delete directory");
                    return null;
                }
                if (this.force.booleanValue() || this.confirm("Do you want to remove directory " + this.targetPath, 3)) {
                    FileUtils.deleteDirectory(target);
                    this.println("removed directory " + this.targetPath);
                }
            } else if (this.force.booleanValue() || this.confirm("Do you want to remove file " + this.targetPath, 3)) {
                target.delete();
                this.println("removed file " + this.targetPath);
            }
            return null;
        }
    }

    @Command(scope="xi", name="replace", description="replace text in file")
    @Service
    public static class Replace
    extends XiAction {
        @Argument(index=0, name="file", required=true, description="file")
        @Completion(value=FileCompleter.class)
        private String source;
        @Option(name="--old", required=true, description="text to be replaced")
        private String oldText;
        @Option(name="--new", required=true, description="next text")
        private String newText;

        @Override
        protected Object execute0() throws Exception {
            File sourceFile = new File(Replace.expandFilepath(this.source));
            if (!sourceFile.exists()) {
                System.err.println(this.source + " does not exist");
                return null;
            }
            if (!sourceFile.isFile()) {
                System.err.println(this.source + " is not a file");
                return null;
            }
            Args.notBlank((String)this.oldText, (String)"oldText");
            this.replaceFile(sourceFile, this.oldText, this.newText);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replaceFile(File file, String oldText, String newText) throws Exception {
            BufferedReader reader = Files.newBufferedReader(file.toPath());
            ByteArrayOutputStream writer = new ByteArrayOutputStream();
            boolean changed = false;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.contains(oldText)) {
                        changed = true;
                        writer.write(line.replace(oldText, newText).getBytes());
                    } else {
                        writer.write(line.getBytes());
                    }
                    writer.write(10);
                }
            }
            finally {
                writer.close();
                reader.close();
            }
            if (changed) {
                File newFile = new File(file.getPath() + "-new");
                byte[] newBytes = writer.toByteArray();
                IoUtil.save((File)file, (byte[])newBytes);
                newFile.renameTo(file);
            }
        }
    }

    @Command(scope="xi", name="move-file", description="move file")
    @Service
    public static class MoveFile
    extends XiAction {
        @Argument(index=0, name="source file", required=true, description="file to be moved")
        @Completion(value=FileCompleter.class)
        private String source;
        @Argument(index=1, name="destination", required=true, description="destination file")
        @Completion(value=FileCompleter.class)
        private String dest;
        @Option(name="--force", aliases={"-f"}, description="override existing file, never prompt")
        private Boolean force = Boolean.FALSE;

        @Override
        protected Object execute0() throws Exception {
            this.source = MoveFile.expandFilepath(this.source);
            this.dest = MoveFile.expandFilepath(this.dest);
            File sourceFile = new File(this.source);
            if (!sourceFile.exists()) {
                throw new IllegalCmdParamException(this.source + " does not exist");
            }
            if (!sourceFile.isFile()) {
                throw new IllegalCmdParamException(this.source + " is not a file");
            }
            File destFile = new File(this.dest);
            if (destFile.exists()) {
                if (!destFile.isFile()) {
                    throw new IllegalCmdParamException("cannot override an existing directory by a file");
                }
                if (!this.force.booleanValue() && !this.confirm("Do you want to override the file " + this.dest, 3)) {
                    return null;
                }
            } else {
                IoUtil.mkdirsParent((Path)destFile.toPath());
            }
            FileUtils.copyFile(sourceFile, destFile, true);
            sourceFile.delete();
            return null;
        }
    }

    @Command(scope="xi", name="move-dir", description="move content of the directory to destination")
    @Service
    public static class MoveDir
    extends XiAction {
        @Argument(index=0, name="source", required=true, description="content of this directory will be copied")
        @Completion(value=Completers.DirCompleter.class)
        private String source;
        @Argument(index=1, name="destination", required=true, description="destination directory")
        @Completion(value=Completers.DirCompleter.class)
        private String dest;

        @Override
        protected Object execute0() throws Exception {
            this.source = MoveDir.expandFilepath(this.source);
            this.dest = MoveDir.expandFilepath(this.dest);
            File sourceDir = new File(this.source);
            if (!sourceDir.exists()) {
                throw new IllegalCmdParamException(this.source + " does not exist");
            }
            if (!sourceDir.isDirectory()) {
                throw new IllegalCmdParamException(this.source + " is not a directory");
            }
            File destDir = new File(this.dest);
            if (destDir.exists()) {
                if (destDir.isFile()) {
                    throw new IllegalCmdParamException(this.dest + " is not a directory");
                }
            } else {
                destDir.mkdirs();
            }
            FileUtils.copyDirectory(sourceDir, destDir);
            FileUtils.deleteDirectory(sourceDir);
            return null;
        }
    }

    @Command(scope="xi", name="mkdir", description="make directories")
    @Service
    public static class Mkdir
    extends XiAction {
        @Argument(index=0, name="directory", required=true, description="directory to be created")
        @Completion(value=Completers.DirCompleter.class)
        private String dirName;

        @Override
        protected Object execute0() throws Exception {
            File target = new File(Mkdir.expandFilepath(this.dirName));
            if (target.exists()) {
                if (!target.isDirectory()) {
                    System.err.println(this.dirName + " exists but is not a directory, cannot override it");
                    return null;
                }
            } else {
                target.mkdirs();
            }
            return null;
        }
    }

    @Command(scope="xi", name="curl", description="transfer a URL")
    @Service
    public static class Curl
    extends XiAction {
        @Argument(index=0, name="url", required=true, description="URL")
        private String url;
        @Option(name="--verbose", aliases={"-v"}, description="show request and response verbosely")
        private Boolean verbose = Boolean.FALSE;
        @Option(name="--post", aliases={"-p"}, description="send the request via HTTP POST")
        private Boolean usePost = Boolean.FALSE;
        @Option(name="--data", aliases={"-d"}, description="data to be sent in a POST request")
        private String postData;
        @Option(name="--data-charset", aliases={"-c"}, description="charset of data")
        private String postDataCharSet = "UTF-8";
        @Option(name="--data-file", description="file contains the data to be sent in a POST request")
        @Completion(value=FileCompleter.class)
        private String postDataFile;
        @Option(name="--out", description="where to save the response")
        @Completion(value=FileCompleter.class)
        private String outFile;
        @Option(name="--header", aliases={"-h"}, multiValued=true, description="header in request")
        private List<String> headers;
        @Option(name="--user", aliases={"-u"}, description="User and password of the form user:password")
        private String userPassword;
        @Reference
        private org.xipki.util.Curl curl;

        @Override
        protected Object execute0() throws Exception {
            Curl.CurlResult result;
            byte[] content = null;
            if (this.postData != null) {
                content = this.postData.getBytes(this.postDataCharSet);
            } else if (this.postDataFile != null) {
                content = IoUtil.read((String)this.postDataFile);
            }
            if (content != null) {
                this.usePost = Boolean.TRUE;
            }
            HashMap<String, String> headerNameValues = null;
            if (this.headers != null) {
                headerNameValues = new HashMap<String, String>();
                for (String header : this.headers) {
                    int idx = header.indexOf(58);
                    if (idx == -1 || idx == header.length() - 1) {
                        throw new IllegalCmdParamException("invalid HTTP header: '" + header + "'");
                    }
                    String key = header.substring(0, idx);
                    String value = header.substring(idx + 1).trim();
                    headerNameValues.put(key, value);
                }
            }
            if ((result = this.usePost != false ? this.curl.curlPost(this.url, this.verbose.booleanValue(), headerNameValues, this.userPassword, content) : this.curl.curlGet(this.url, this.verbose.booleanValue(), headerNameValues, this.userPassword)).getContent() == null && result.getErrorContent() == null) {
                this.println("NO response content");
                return null;
            }
            if (this.outFile != null) {
                if (result.getContent() != null) {
                    this.saveVerbose("saved response to file", this.outFile, result.getContent());
                } else {
                    this.saveVerbose("saved (error) response to file", "error-" + this.outFile, result.getErrorContent());
                }
            } else {
                String ct = result.getContentType();
                String charset = Curl.getCharset(ct);
                if (charset == null) {
                    charset = "UTF-8";
                }
                if (result.getContent() != null) {
                    this.println(new String(result.getContent(), charset));
                } else {
                    this.println("ERROR: ");
                    this.println(new String(result.getContent(), charset));
                }
            }
            return null;
        }

        private static String getCharset(String contentType) {
            if (StringUtil.isBlank((String)contentType) || contentType.indexOf(59) == -1) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(contentType, ";");
            st.nextToken();
            while (st.hasMoreTokens()) {
                String paramName;
                String token = st.nextToken();
                int idx = token.indexOf(61);
                if (idx == -1 || !"charset".equalsIgnoreCase(paramName = token.substring(0, idx).trim())) continue;
                return token.substring(idx + 1, token.length());
            }
            return null;
        }
    }

    @Command(scope="xi", name="copy-file", description="copy file")
    @Service
    public static class CopyFile
    extends XiAction {
        @Argument(index=0, name="source file", required=true, description="file to be copied")
        @Completion(value=FileCompleter.class)
        private String source;
        @Argument(index=1, name="destination", required=true, description="destination file")
        @Completion(value=FileCompleter.class)
        private String dest;
        @Option(name="--force", aliases={"-f"}, description="override existing file, never prompt")
        private Boolean force = Boolean.FALSE;

        @Override
        protected Object execute0() throws Exception {
            this.source = CopyFile.expandFilepath(this.source);
            this.dest = CopyFile.expandFilepath(this.dest);
            File sourceFile = new File(this.source);
            if (!sourceFile.exists()) {
                throw new IllegalCmdParamException(this.source + " does not exist");
            }
            if (!sourceFile.isFile()) {
                throw new IllegalCmdParamException(this.source + " is not a file");
            }
            File destFile = new File(this.dest);
            if (destFile.exists()) {
                if (!destFile.isFile()) {
                    throw new IllegalCmdParamException("cannot override an existing directory by a file");
                }
                if (!this.force.booleanValue() && !this.confirm("Do you want to override the file " + this.dest, 3)) {
                    return null;
                }
            } else {
                IoUtil.mkdirsParent((Path)destFile.toPath());
            }
            FileUtils.copyFile(sourceFile, destFile, true);
            return null;
        }
    }

    @Command(scope="xi", name="copy-dir", description="copy content of the directory to destination")
    @Service
    public static class CopyDir
    extends XiAction {
        @Argument(index=0, name="source", required=true, description="content of this directory will be copied")
        @Completion(value=Completers.DirCompleter.class)
        private String source;
        @Argument(index=1, name="destination", required=true, description="destination directory")
        @Completion(value=Completers.DirCompleter.class)
        private String dest;

        @Override
        protected Object execute0() throws Exception {
            this.source = CopyDir.expandFilepath(this.source);
            this.dest = CopyDir.expandFilepath(this.dest);
            File sourceDir = new File(this.source);
            if (!sourceDir.exists()) {
                throw new IllegalCmdParamException(this.source + " does not exist");
            }
            if (!sourceDir.isDirectory()) {
                throw new IllegalCmdParamException(this.source + " is not a directory");
            }
            File destDir = new File(this.dest);
            if (destDir.exists()) {
                if (destDir.isFile()) {
                    throw new IllegalCmdParamException(this.dest + " is not a directory");
                }
            } else {
                destDir.mkdirs();
            }
            FileUtils.copyDirectory(sourceDir, destDir);
            return null;
        }
    }

    @Command(scope="xi", name="confirm", description="confirm an action")
    @Service
    public static class Confirm
    extends XiAction {
        @Argument(index=0, name="message", required=true, description="prompt message")
        private String prompt;

        @Override
        protected Object execute0() throws Exception {
            boolean toContinue = this.confirm(this.prompt + "\nDo you want to continue", 3);
            if (!toContinue) {
                throw new CmdFailure("User cancelled");
            }
            return null;
        }
    }
}

