/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.shell;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.SecurePasswordInputPanel;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.PemEncoder;
import org.xipki.util.RandomUtil;
import org.xipki.util.StringUtil;

public abstract class XiAction
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(XiAction.class);
    @Reference
    protected Session session;

    protected abstract Object execute0() throws Exception;

    public Object execute() throws Exception {
        return this.execute0();
    }

    protected boolean isTrue(Boolean bo) {
        return bo != null && bo != false;
    }

    protected ConfPairs embedFileContent(ConfPairs confPairs) throws IOException {
        boolean changed = false;
        for (String name : confPairs.names()) {
            String value = confPairs.value(name);
            if (!value.startsWith("file:")) continue;
            changed = true;
            break;
        }
        if (!changed) {
            return confPairs;
        }
        ConfPairs newPairs = new ConfPairs();
        for (String name : confPairs.names()) {
            String value = confPairs.value(name);
            if (value.startsWith("file:")) {
                String fileName = value.substring("file:".length());
                byte[] binValue = IoUtil.read((String)fileName);
                confPairs.putPair(name, "base64:" + Base64.encodeToString((byte[])binValue));
                continue;
            }
            newPairs.putPair(name, value);
        }
        return newPairs;
    }

    protected void saveVerbose(String promptPrefix, String file, byte[] encoded) throws IOException {
        this.saveVerbose(promptPrefix, new File(file), encoded);
    }

    protected void saveVerbose(String promptPrefix, File file, byte[] encoded) throws IOException {
        String newFn;
        File saveTo = XiAction.expandFilepath(file);
        if (saveTo.exists()) {
            try {
                boolean bo = true;
                while (saveTo.exists()) {
                    String answer = bo ? this.readPrompt("A file named '" + saveTo.getPath() + "' already exists. Do you want to replace it [Yes/No]? ") : this.readPrompt("Please answer with Yer or No: ");
                    if (answer == null) {
                        throw new IOException("interrupted");
                    }
                    if (!StringUtil.orEqualsIgnoreCase((String)answer, (String[])new String[]{"yes", "y"})) {
                        if (StringUtil.orEqualsIgnoreCase((String)answer, (String[])new String[]{"no", "n"})) {
                            bo = true;
                            while ((newFn = this.readPrompt("Enter new path to save to ... ")).trim().isEmpty()) {
                            }
                            saveTo = new File(newFn);
                            continue;
                        }
                        bo = false;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not save file");
                saveTo = new File("tmp-" + XiAction.randomHex(6));
            }
        }
        int tries = 2;
        while (true) {
            try {
                --tries;
                this.save(saveTo, encoded);
            }
            catch (IOException ex) {
                this.println("ERROR: " + ex.getMessage());
                if (tries > 0) {
                    while ((newFn = this.readPrompt("Enter new path to save to ... ")).trim().isEmpty()) {
                    }
                    saveTo = new File(newFn);
                    continue;
                }
                if (tries == 0) {
                    saveTo = new File("tmp-" + XiAction.randomHex(6));
                    continue;
                }
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not save to file");
                throw new IOException("could not save to file", ex);
            }
            break;
        }
        String tmpPromptPrefix = promptPrefix;
        if (promptPrefix == null || promptPrefix.isEmpty()) {
            tmpPromptPrefix = "saved to file";
        }
        this.println(tmpPromptPrefix + " " + saveTo.getPath());
    }

    protected void save(String file, byte[] encoded) throws IOException {
        this.save(new File(file), encoded);
    }

    protected void save(File file, byte[] encoded) throws IOException {
        File tmpFile = XiAction.expandFilepath(file);
        File parent = tmpFile.getParentFile();
        if (parent != null) {
            if (parent.exists()) {
                if (!parent.isDirectory()) {
                    throw new IOException("The path " + parent.getPath() + " is not a directory.");
                }
            } else {
                parent.mkdirs();
            }
        }
        Files.copy(new ByteArrayInputStream(encoded), tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static String randomHex(int numOfBytes) {
        return Hex.encode((byte[])RandomUtil.nextBytes((int)numOfBytes));
    }

    protected static boolean isEnabled(String enabledS, boolean defaultEnabled, String optionName) {
        return enabledS == null ? defaultEnabled : XiAction.isEnabled(enabledS, optionName);
    }

    private static boolean isEnabled(String enabledS, String optionName) {
        if (StringUtil.orEqualsIgnoreCase((String)enabledS, (String[])new String[]{"yes", "enabled", "true"})) {
            return true;
        }
        if (StringUtil.orEqualsIgnoreCase((String)enabledS, (String[])new String[]{"no", "disabled", "false"})) {
            return false;
        }
        throw new IllegalArgumentException("invalid option " + optionName + ": " + enabledS);
    }

    protected String readPrompt(String prompt) throws IOException {
        String tmpPrompt = prompt;
        if (StringUtil.isNotBlank((String)prompt) && !prompt.endsWith(" ")) {
            tmpPrompt = tmpPrompt + " ";
        }
        return this.readLine(tmpPrompt, null);
    }

    protected char[] readPasswordIfNotSet(String password) throws IOException {
        return this.readPasswordIfNotSet(null, password);
    }

    protected char[] readPasswordIfNotSet(String prompt, String password) throws IOException {
        return password != null ? password.toCharArray() : this.readPassword(prompt);
    }

    protected char[] readPassword() throws IOException {
        return this.readPassword(null);
    }

    protected char[] readPassword(String prompt) throws IOException {
        String passwordUi;
        String tmpPrompt;
        String string = tmpPrompt = prompt == null ? "Password:" : prompt.trim();
        if (!tmpPrompt.endsWith(":")) {
            tmpPrompt = tmpPrompt + ":";
        }
        return "gui".equalsIgnoreCase(passwordUi = System.getProperty("org.xipki.console.passwordui")) ? SecurePasswordInputPanel.readPassword((String)tmpPrompt) : this.readLine(tmpPrompt, Character.valueOf('*')).toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLine(String prompt, Character ch) throws IOException {
        Object oldIgnoreInterrupts = this.session.get("karaf.ignoreInterrupts");
        this.session.put("karaf.ignoreInterrupts", (Object)Boolean.TRUE);
        try {
            String line = this.session.readLine(prompt, ch);
            if (line == null) {
                throw new IOException("interrupted");
            }
            String string = line;
            return string;
        }
        finally {
            this.session.put("karaf.ignoreInterrupts", oldIgnoreInterrupts);
        }
    }

    protected static String expandFilepath(String path) {
        return IoUtil.expandFilepath((String)path);
    }

    protected static File expandFilepath(File file) {
        return IoUtil.expandFilepath((File)file);
    }

    protected void println(String message) {
        System.out.println(message);
    }

    protected void print(String message) {
        System.out.print(message);
    }

    protected static boolean isBlank(String str) {
        return StringUtil.isBlank((String)str);
    }

    protected static boolean isNotBlank(String str) {
        return StringUtil.isNotBlank((String)str);
    }

    protected static boolean isEmpty(Collection<?> col) {
        return CollectionUtil.isEmpty(col);
    }

    protected static boolean isNotEmpty(Collection<?> col) {
        return CollectionUtil.isNotEmpty(col);
    }

    protected static List<String> split(String str, String delim) {
        return StringUtil.split((String)str, (String)delim);
    }

    protected static BigInteger toBigInt(String str) {
        return XiAction.toBigInt(str, false);
    }

    protected static BigInteger toBigInt(String str, boolean defaultHex) {
        return StringUtil.toBigInt((String)str, (boolean)defaultHex);
    }

    protected static byte[] encodeCert(byte[] data, String encodeForm) {
        return XiAction.derPemEncode(data, encodeForm, PemEncoder.PemLabel.CERTIFICATE);
    }

    protected static byte[] encodeCrl(byte[] data, String encodeForm) {
        return XiAction.derPemEncode(data, encodeForm, PemEncoder.PemLabel.X509_CRL);
    }

    protected static byte[] encodeCsr(byte[] data, String encodeForm) {
        return XiAction.derPemEncode(data, encodeForm, PemEncoder.PemLabel.CERTIFICATE_REQUEST);
    }

    protected static byte[] derPemEncode(byte[] data, String encodeForm, PemEncoder.PemLabel pemLabel) {
        return "pem".equalsIgnoreCase(encodeForm) ? PemEncoder.encode((byte[])data, (PemEncoder.PemLabel)pemLabel) : data;
    }

    protected boolean confirm(String prompt, int maxTries) throws IOException {
        String tmpPrompt;
        if (prompt == null || prompt.isEmpty()) {
            tmpPrompt = "(Yes/No)? ";
        } else {
            tmpPrompt = '?' == prompt.charAt(prompt.length() - 1) ? prompt.substring(0, prompt.length() - 1) : prompt;
            tmpPrompt = tmpPrompt + " (Yes/No)? ";
        }
        String answer = this.readLine(tmpPrompt, null);
        if (answer == null) {
            throw new IOException("interrupted");
        }
        for (int tries = 1; tries < maxTries; ++tries) {
            if (StringUtil.orEqualsIgnoreCase((String)answer, (String[])new String[]{"yes", "y"})) {
                return true;
            }
            if (StringUtil.orEqualsIgnoreCase((String)answer, (String[])new String[]{"no", "n"})) {
                return false;
            }
            answer = this.readLine("Please answer with Yes or No: ", null);
        }
        return false;
    }
}

