/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.http.server;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.http.server.HttpServer;
import org.xipki.http.server.HttpServersConf;
import org.xipki.http.server.ServletListener;
import org.xipki.http.servlet.SslReverseProxyMode;
import org.xipki.httpserver.v1.FileOrValueType;
import org.xipki.httpserver.v1.HttpserverType;
import org.xipki.httpserver.v1.KeystoreType;
import org.xipki.httpserver.v1.TlsType;
import org.xipki.httpserver.v1.TruststoreType;
import org.xipki.password.PasswordResolver;

public final class HttpServers {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServers.class);
    private final Set<HttpServer> servers = new HashSet<HttpServer>();
    private ServletListener servletListener;
    private HttpServersConf conf;
    private PasswordResolver passwordResolver;

    public void setServletListener(ServletListener servletListener) {
        this.servletListener = servletListener;
        for (HttpServer server : this.servers) {
            server.setServletListener(servletListener);
        }
    }

    public void setPasswordResolver(PasswordResolver passwordResolver) {
        this.passwordResolver = passwordResolver;
    }

    public void setConf(HttpServersConf conf) {
        this.conf = conf;
    }

    public void start() throws Exception {
        if (this.conf == null) {
            throw new IllegalStateException("conf is not set");
        }
        if (this.servletListener == null) {
            throw new IllegalStateException("servletListener is not set");
        }
        List<HttpserverType> serverConfs = this.conf.getConf().getHttpserver();
        HashSet<Integer> ports = new HashSet<Integer>();
        for (HttpserverType conf : serverConfs) {
            SslReverseProxyMode mode;
            int port;
            if (!conf.isEnabled()) {
                LOG.info("HTTP server on port {} is disabled, ignore it", (Object)conf.getPort());
            }
            if (ports.contains(port = conf.getPort())) {
                throw new Exception("Duplicated use of the port " + port);
            }
            ports.add(port);
            int numThreads = conf.getThreads() == null ? 0 : conf.getThreads();
            String str = conf.getReverseProxy();
            if (str == null || str.equalsIgnoreCase("NONE")) {
                mode = SslReverseProxyMode.NONE;
            } else if (str.equalsIgnoreCase("APACHE")) {
                mode = SslReverseProxyMode.APACHE;
            } else {
                throw new Exception("invalid reverseProxy " + str);
            }
            HttpServer server = new HttpServer(this.buildSslContext(conf), port, numThreads);
            server.setServletListener(this.servletListener);
            server.setSslReverseProxyMode(mode);
            this.servers.add(server);
        }
        for (HttpServer server : this.servers) {
            server.start();
        }
    }

    public void shutdown() {
        if (this.servers.isEmpty()) {
            LOG.info("found no HTTP server to shutdown");
            return;
        }
        for (HttpServer server : this.servers) {
            server.shutdown();
            LOG.info("shutdown HTTP server {}", (Object)server);
        }
        this.servers.clear();
    }

    private SslContext buildSslContext(HttpserverType conf) throws Exception {
        ClientAuth clientAuth;
        List<String> availableCiphersuits;
        List<String> availableProtocols;
        SslProvider sslProvider;
        TlsType tt = conf.getTls();
        if (tt == null) {
            return null;
        }
        KeystoreType kst = tt.getKeystore();
        if (kst == null) {
            throw new IllegalArgumentException("no keystore is configured");
        }
        char[] kstPwd = this.passwordResolver.resolvePassword(kst.getPassword());
        KeyStore ks = this.loadKeyStore(kst.getType(), kst.getStore(), kstPwd);
        String alias = kst.getKeyAlias();
        if (alias != null) {
            if (!ks.isKeyEntry(alias)) {
                throw new Exception("'" + alias + "' is not a valid key alias");
            }
        } else {
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String al = aliases.nextElement();
                if (!ks.isKeyEntry(al)) continue;
                alias = al;
                break;
            }
            if (alias == null) {
                throw new Exception("found no key entries in the keystore");
            }
        }
        char[] keypwd = kst.getKeyPassword() == null ? kstPwd : this.passwordResolver.resolvePassword(kst.getKeyPassword());
        PrivateKey key = (PrivateKey)ks.getKey(alias, keypwd);
        Certificate[] certs = ks.getCertificateChain(alias);
        X509Certificate[] keyCertChain = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            keyCertChain[i] = (X509Certificate)certs[i];
        }
        SslContextBuilder builder = SslContextBuilder.forServer((PrivateKey)key, (X509Certificate[])keyCertChain);
        boolean opensslAvailable = OpenSsl.isAvailable();
        if (tt.getProvider() == null) {
            if (!opensslAvailable) {
                HttpServers.logOpenSslWarning();
            }
            sslProvider = SslContext.defaultServerProvider();
        } else {
            String providerStr = tt.getProvider();
            String providerStr0 = providerStr.toLowerCase().replaceAll("[^a-z0-9]+", "");
            if ("jdk".equals(providerStr0)) {
                sslProvider = SslProvider.JDK;
            } else if ("openssl".equals(providerStr0) || "opensslrefcnt".equals(providerStr0)) {
                if (!opensslAvailable) {
                    HttpServers.logOpenSslWarning();
                    throw new Exception("OpenSSL not available");
                }
                sslProvider = "openssl".equals(providerStr0) ? SslProvider.OPENSSL : SslProvider.OPENSSL_REFCNT;
            } else {
                throw new Exception("unknwon SSL provider " + providerStr);
            }
        }
        LOG.info("use SSL provider {}", (Object)sslProvider);
        builder.sslProvider(sslProvider);
        switch (sslProvider) {
            case JDK: {
                SSLParameters sslParams = SSLContext.getDefault().getSupportedSSLParameters();
                availableProtocols = Arrays.asList(sslParams.getProtocols());
                availableCiphersuits = Arrays.asList(sslParams.getCipherSuites());
                break;
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                availableProtocols = Arrays.asList("TLSv1.1", "TLSv1.2");
                availableCiphersuits = new ArrayList<String>(OpenSsl.availableJavaCipherSuites());
                break;
            }
            default: {
                throw new RuntimeException("should not reach here, unknown SssProvider " + sslProvider);
            }
        }
        List<String> protocols = tt.getProtocols() != null ? tt.getProtocols().getProtocol() : Arrays.asList("TLSv1.1", "TLSv1.2");
        String[] strArray = new String[]{};
        HashSet<String> usedProtocols = new HashSet<String>();
        for (String protocol : protocols) {
            boolean added = false;
            for (String supported : availableProtocols) {
                if (!protocol.equalsIgnoreCase(supported)) continue;
                usedProtocols.add(supported);
                added = true;
                break;
            }
            if (added) continue;
            LOG.warn("SSL Protocol {} unsupported, ignore it", (Object)protocol);
        }
        if (usedProtocols.isEmpty()) {
            throw new Exception("None of the configured SSL protocols is supported");
        }
        LOG.info("use SSL protocols {}", usedProtocols);
        builder.protocols(usedProtocols.toArray(strArray));
        boolean cipherWithTLS = availableCiphersuits.get(0).startsWith("TLS_");
        HashSet<String> usedCipherSuites = new HashSet<String>();
        if (tt.getCiphersuites() != null) {
            for (String cipherSuite : tt.getCiphersuites().getCiphersuite()) {
                if (cipherSuite.length() < 5) {
                    LOG.warn("cipher suite {} unsupported, ignore it", (Object)cipherSuite);
                    continue;
                }
                String adaptedCipher = cipherWithTLS == cipherSuite.startsWith("TLS_") ? cipherSuite : (cipherWithTLS ? "TLS_" + cipherSuite.substring(4) : "SSL_" + cipherSuite.substring(4));
                boolean added = false;
                for (String string : availableCiphersuits) {
                    if (!adaptedCipher.equalsIgnoreCase(string)) continue;
                    usedCipherSuites.add(string);
                    added = true;
                    break;
                }
                if (added) continue;
                LOG.warn("SSL cipher suite {} unsupported, ignore it", (Object)cipherSuite);
            }
        } else {
            String[] excludeMiddlePatterns = new String[]{"_3DES", "_DES", "EMPTY", "EXPORT", "anno", "NULL"};
            String[] excludeEndPatterns = new String[]{"MD5", "SHA"};
            for (String cipherSuite : availableCiphersuits) {
                boolean add = true;
                for (String p : excludeMiddlePatterns) {
                    if (!cipherSuite.contains(p)) continue;
                    add = false;
                    break;
                }
                if (add) {
                    for (String p : excludeEndPatterns) {
                        if (!cipherSuite.endsWith(p)) continue;
                        add = false;
                        break;
                    }
                }
                if (!add) continue;
                usedCipherSuites.add(cipherSuite);
            }
        }
        LOG.info("use SSL cipher suites {}", usedCipherSuites);
        builder.ciphers(usedCipherSuites);
        String str = tt.getClientauth();
        if ("none".equalsIgnoreCase(str)) {
            clientAuth = ClientAuth.NONE;
        } else if ("optional".equalsIgnoreCase(str)) {
            clientAuth = ClientAuth.OPTIONAL;
        } else if ("require".equalsIgnoreCase(str)) {
            clientAuth = ClientAuth.REQUIRE;
        } else {
            throw new Exception("invalid client authentication '" + str + "'");
        }
        builder.clientAuth(clientAuth);
        if (clientAuth != ClientAuth.NONE) {
            TruststoreType tst = tt.getTruststore();
            if (tst == null) {
                throw new Exception("Client authentication is activated, but no truststore is configured");
            }
            char[] pwd = this.passwordResolver.resolvePassword(tst.getPassword());
            KeyStore ks2 = this.loadKeyStore(tst.getType(), tst.getStore(), pwd);
            LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
            Enumeration<String> aliases = ks2.aliases();
            while (aliases.hasMoreElements()) {
                String alias2 = aliases.nextElement();
                Certificate cert = ks2.getCertificate(alias2);
                linkedList.add((X509Certificate)cert);
            }
            builder.trustManager(linkedList.toArray(new X509Certificate[0]));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore(String storeType, FileOrValueType store, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keystore = KeyStore.getInstance(storeType);
        try (InputStream stream = store.getValue() != null ? new ByteArrayInputStream(store.getValue()) : new FileInputStream(store.getFile());){
            keystore.load(stream, password);
        }
        return keystore;
    }

    private static void logOpenSslWarning() {
        if (LOG.isWarnEnabled()) {
            StringBuilder sb = new StringBuilder(120);
            sb.append("To use the OpenSSL as SSL provider, both libapr-1 and OpenSSL must be ").append("installed and configured. Note that OpenSSL cannot be applied in ").append("Fedora distribution");
            LOG.warn(sb.toString());
        }
    }
}

