/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.http.server;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.http.servlet.HttpServlet;
import org.xipki.http.servlet.ServletURI;
import org.xipki.http.servlet.ServletURIPool;

public class ServletListener {
    private static final Logger LOG = LoggerFactory.getLogger(ServletListener.class);
    private final ConcurrentMap<HttpServlet, String> servletAliasMap = new ConcurrentHashMap<HttpServlet, String>();
    private final ConcurrentMap<String, HttpServlet> aliasServletMap = new ConcurrentHashMap<String, HttpServlet>();
    private final Set<String> aliases = new HashSet<String>();

    public void register(HttpServlet servlet, Map<?, ?> properties) {
        if (properties == null) {
            LOG.info("registerServlet invoked with null properties, ingore it");
            return;
        }
        Object propValue = properties.get("alias");
        if (!(propValue instanceof String)) {
            LOG.info("registerServlet invoked with invalid type ({}) of alias, ingore it", (Object)propValue.getClass().getName());
            return;
        }
        this.register(servlet, (String)propValue);
    }

    public void register(HttpServlet servlet, String aliasList) {
        if (servlet == null) {
            LOG.info("registerServlet invoked with null servlet, ingore it");
            return;
        }
        if (aliasList.isEmpty()) {
            LOG.info("registerServlet invoked with empty alias, ingore it");
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(aliasList, ", ");
        ArrayList<String> list = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.isEmpty()) continue;
            list.add(token);
        }
        for (String alias : list) {
            if (alias.charAt(0) != '/') {
                alias = "/" + alias;
            }
            if (alias.length() > 1 && alias.charAt(alias.length() - 1) == '/') {
                alias = alias.substring(0, alias.length() - 1);
            }
            if (this.aliases.contains(alias)) {
                LOG.info("registerServlet invoked with duplicated alias {}, ingore it", (Object)alias);
                continue;
            }
            String previousAlias = this.servletAliasMap.put(servlet, alias);
            this.aliases.add(alias);
            this.aliasServletMap.put(alias, servlet);
            if (previousAlias != null) {
                this.aliases.remove(previousAlias);
                this.aliasServletMap.remove(previousAlias);
                LOG.info("re-register HttpServet {} for alias {} (previous {})", new Object[]{servlet, alias, previousAlias});
                continue;
            }
            LOG.info("register HttpServet {} for alias {}", (Object)servlet, (Object)alias);
        }
    }

    public void unregister(HttpServlet servlet) {
        if (servlet == null) {
            LOG.debug("unregisterServlet invoked with null.");
            return;
        }
        String alias = (String)this.servletAliasMap.remove(servlet);
        if (alias != null) {
            this.aliases.remove(alias);
            this.aliasServletMap.remove(alias);
            LOG.info("removed HttpServlet for {}", (Object)servlet);
        } else {
            LOG.info("no HttpServlet found to remove for {}", (Object)servlet);
        }
    }

    public Object[] getServlet(String rawPath) throws URISyntaxException {
        String alias = null;
        String uriText = null;
        for (String m : this.aliases) {
            if (m.equals("/")) {
                alias = m;
                uriText = rawPath;
                break;
            }
            if (rawPath.startsWith(m)) {
                int mLen;
                int len = rawPath.length();
                if (len == (mLen = m.length())) {
                    uriText = "/";
                    alias = m;
                } else {
                    char ch = rawPath.charAt(mLen);
                    if (ch == '/') {
                        uriText = len == mLen + 1 ? "/" : rawPath.substring(mLen);
                        alias = m;
                    } else if (ch == '?') {
                        uriText = rawPath.substring(mLen);
                        alias = m;
                    }
                }
            }
            if (alias == null) continue;
            break;
        }
        if (alias == null) {
            return null;
        }
        ServletURI servletUri = ServletURIPool.getServletURI(uriText);
        HttpServlet servlet = (HttpServlet)this.aliasServletMap.get(alias);
        return new Object[]{servletUri, servlet};
    }
}

