/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.http.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.http.server.ServletListener;
import org.xipki.http.servlet.HttpServlet;
import org.xipki.http.servlet.ServletURI;
import org.xipki.http.servlet.SslReverseProxyMode;

public final class HttpServer {
    private static final Logger LOG;
    private static Boolean epollAvailable;
    private static Boolean kqueueAvailable;
    private final int port;
    private final SslContext sslContext;
    private final int numThreads;
    private ServletListener servletListener;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private SslReverseProxyMode sslReverseProxyMode = SslReverseProxyMode.NONE;

    public void setSslReverseProxyMode(SslReverseProxyMode mode) {
        this.sslReverseProxyMode = mode == null ? SslReverseProxyMode.NONE : mode;
    }

    public HttpServer(SslContext sslContext, int port, int numThreads) {
        this.sslContext = sslContext;
        this.port = port;
        this.numThreads = numThreads > 0 ? numThreads : 4 * Runtime.getRuntime().availableProcessors();
    }

    public void setServletListener(ServletListener servletListener) {
        this.servletListener = servletListener;
    }

    public void start() {
        Class<?> clazz;
        int numProcessors = Runtime.getRuntime().availableProcessors();
        Class channelClass = null;
        int bossGroupThreads = numProcessors == 1 ? 1 : (numProcessors + 1) / 2;
        ClassLoader loader = this.getClass().getClassLoader();
        if (epollAvailable != null && epollAvailable.booleanValue()) {
            try {
                channelClass = Class.forName("io.netty.channel.epoll.EpollServerSocketChannel", false, loader);
                clazz = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup", true, loader);
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
                this.bossGroup = (EventLoopGroup)constructor.newInstance(bossGroupThreads);
                this.workerGroup = (EventLoopGroup)constructor.newInstance(this.numThreads);
                LOG.info("use Epoll Transport");
            }
            catch (Throwable th) {
                if (th instanceof ClassNotFoundException) {
                    LOG.info("epoll linux is not in classpath");
                } else {
                    LOG.warn("could not use Epoll transport: {}", (Object)th.getMessage());
                    LOG.debug("could not use Epoll transport", th);
                }
                channelClass = null;
                this.bossGroup = null;
                this.workerGroup = null;
            }
        } else if (kqueueAvailable != null && kqueueAvailable.booleanValue()) {
            try {
                channelClass = Class.forName("io.netty.channel.kqueue.KQueueServerSocketChannel", false, loader);
                clazz = Class.forName("io.netty.channel.kqueue.KQueueEventLoopGroup", true, loader);
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
                this.bossGroup = (EventLoopGroup)constructor.newInstance(bossGroupThreads);
                this.workerGroup = (EventLoopGroup)constructor.newInstance(this.numThreads);
                LOG.info("Use KQueue Transport");
            }
            catch (Exception ex) {
                LOG.warn("could not use KQueue transport: {}", (Object)ex.getMessage());
                LOG.debug("could not use KQueue transport", (Throwable)ex);
                channelClass = null;
                this.bossGroup = null;
                this.workerGroup = null;
            }
        }
        if (this.bossGroup == null) {
            channelClass = NioServerSocketChannel.class;
            this.bossGroup = new NioEventLoopGroup(bossGroupThreads);
            this.workerGroup = new NioEventLoopGroup(this.numThreads);
        }
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(channelClass)).handler((ChannelHandler)new LoggingHandler())).childHandler((ChannelHandler)new NettyHttpServerInitializer());
        bootstrap.bind(this.port).syncUninterruptibly();
        LOG.info("HTTP server is listening on port {}", (Object)this.port);
    }

    public void shutdown() {
        this.bossGroup.shutdownGracefully();
        this.bossGroup = null;
        this.workerGroup.shutdownGracefully();
        this.workerGroup = null;
    }

    static {
        block10: {
            LOG = LoggerFactory.getLogger(HttpServer.class);
            String os = System.getProperty("os.name").toLowerCase();
            ClassLoader loader = HttpServer.class.getClassLoader();
            if (os.contains("linux")) {
                try {
                    Class<?> checkClazz = Class.forName("io.netty.channel.epoll.Epoll", false, loader);
                    Method mt = checkClazz.getMethod("isAvailable", new Class[0]);
                    Object obj = mt.invoke(null, new Object[0]);
                    if (obj instanceof Boolean) {
                        epollAvailable = (Boolean)obj;
                    }
                }
                catch (Throwable th) {
                    if (th instanceof ClassNotFoundException) {
                        LOG.info("epoll linux is not in classpath");
                        break block10;
                    }
                    LOG.warn("could not use Epoll transport: {}", (Object)th.getMessage());
                    LOG.debug("could not use Epoll transport", th);
                }
            } else if (os.contains("mac os") || os.contains("os x")) {
                try {
                    Class<?> checkClazz = Class.forName("io.netty.channel.epoll.kqueue.KQueue", false, loader);
                    Method mt = checkClazz.getMethod("isAvailable", new Class[0]);
                    Object obj = mt.invoke(null, new Object[0]);
                    if (obj instanceof Boolean) {
                        kqueueAvailable = (Boolean)obj;
                    }
                }
                catch (Exception ex) {
                    LOG.warn("could not use KQueue transport: {}", (Object)ex.getMessage());
                    LOG.debug("could not use KQueue transport", (Throwable)ex);
                }
            }
        }
    }

    private class NettyHttpServerHandler
    extends SimpleChannelInboundHandler<FullHttpRequest> {
        private NettyHttpServerHandler() {
            super(true);
        }

        public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
            FullHttpResponse response;
            SslHandler handler;
            if (!request.decoderResult().isSuccess()) {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            Object[] objs = HttpServer.this.servletListener.getServlet(request.uri());
            if (objs == null) {
                this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                return;
            }
            ServletURI servletUri = (ServletURI)objs[0];
            HttpServlet servlet = (HttpServlet)objs[1];
            SSLSession sslSession = null;
            if (servlet.needsTlsSessionInfo() && HttpServer.this.sslContext != null && (handler = (SslHandler)ctx.channel().pipeline().get("ssl")) != null) {
                sslSession = handler.engine().getSession();
            }
            try {
                response = servlet.service(request, servletUri, sslSession, HttpServer.this.sslReverseProxyMode);
            }
            catch (Exception ex) {
                this.logException("exception raised while processing request", ex);
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                return;
            }
            boolean keepAlive = true;
            int status = response.status().code();
            if (status < 200 | status > 299) {
                keepAlive = false;
            }
            ChannelFuture cf = ctx.writeAndFlush((Object)response);
            if (!keepAlive) {
                cf.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (ctx.channel().isActive()) {
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }

        private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
            ByteBuf content = Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        private void logException(String msg, Exception ex) {
            LOG.warn("{} - {}: {}", new Object[]{msg, ex.getClass().getName(), ex.getMessage()});
            LOG.debug(msg, (Throwable)ex);
        }
    }

    private class NettyHttpServerInitializer
    extends ChannelInitializer<SocketChannel> {
        public void initChannel(SocketChannel ch) {
            ChannelPipeline pipeline = ch.pipeline();
            if (HttpServer.this.sslContext != null) {
                pipeline.addLast("ssl", (ChannelHandler)HttpServer.this.sslContext.newHandler(ch.alloc()));
            }
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)}).addLast(new ChannelHandler[]{new ChunkedWriteHandler()}).addLast(new ChannelHandler[]{new NettyHttpServerHandler()});
        }
    }
}

