/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.math.BigInteger;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.common.util.IoUtil;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.shell.SecurityCommandSupport;

@Command(scope="xipki-tk", name="crl-info", description="print CRL information")
@Service
public class CrlInfoCmd
extends SecurityCommandSupport {
    @Option(name="--in", description="CRL file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String inFile;
    @Option(name="--hex", aliases={"-h"}, description="print hex number")
    private Boolean hex = Boolean.FALSE;
    @Option(name="--crlnumber", description="print CRL number")
    private Boolean crlNumber;
    @Option(name="--issuer", description="print issuer")
    private Boolean issuer;
    @Option(name="--this-update", description="print thisUpdate")
    private Boolean thisUpdate;
    @Option(name="--next-update", description="print nextUpdate")
    private Boolean nextUpdate;

    protected Object execute0() throws Exception {
        CertificateList crl = CertificateList.getInstance((Object)IoUtil.read((String)this.inFile));
        if (this.crlNumber != null && this.crlNumber.booleanValue()) {
            ASN1Encodable asn1 = crl.getTBSCertList().getExtensions().getExtensionParsedValue(Extension.cRLNumber);
            if (asn1 == null) {
                return "null";
            }
            return this.getNumber(ASN1Integer.getInstance((Object)asn1).getPositiveValue());
        }
        if (this.issuer != null && this.issuer.booleanValue()) {
            return crl.getIssuer().toString();
        }
        if (this.thisUpdate != null && this.thisUpdate.booleanValue()) {
            return this.toUtcTimeyyyyMMddhhmmssZ(crl.getThisUpdate().getDate());
        }
        if (this.nextUpdate != null && this.nextUpdate.booleanValue()) {
            return crl.getNextUpdate() == null ? "null" : this.toUtcTimeyyyyMMddhhmmssZ(crl.getNextUpdate().getDate());
        }
        return null;
    }

    private String getNumber(Number no) {
        if (!this.hex.booleanValue()) {
            return no.toString();
        }
        if (no instanceof Byte) {
            return "0X" + Hex.toHexString((byte[])new byte[]{(Byte)no});
        }
        if (no instanceof Short) {
            return "0X" + Integer.toHexString(((Short)no).shortValue());
        }
        if (no instanceof Integer) {
            return "0X" + Integer.toHexString((Integer)no);
        }
        if (no instanceof Long) {
            return "0X" + Long.toHexString((Long)no);
        }
        if (no instanceof Long) {
            return "0X" + Long.toHexString((Long)no);
        }
        if (no instanceof BigInteger) {
            return "0X" + ((BigInteger)no).toString(16);
        }
        return no.toString();
    }
}

