/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.util.IoUtil;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.shell.SecurityCommandSupport;
import org.xipki.security.shell.completer.KeystoreTypeCompleter;
import org.xipki.security.util.X509Util;

@Command(scope="xipki-tk", name="import-cert", description="Import certificates to a keystore")
@Service
public class ImportCertCmd
extends SecurityCommandSupport {
    @Option(name="--keystore", required=true, description="Keystore file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String ksFile;
    @Option(name="--type", required=true, description="Type of the keystore\n(required)")
    @Completion(value=KeystoreTypeCompleter.class)
    private String ksType;
    @Option(name="--password", description="password of the keystore")
    private String ksPwd;
    @Option(name="--cert", aliases={"-c"}, required=true, multiValued=true, description="Certificate files\n(required, multi-valued)")
    private List<String> certFiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute0() throws Exception {
        File realKsFile = new File(IoUtil.expandFilepath((String)this.ksFile));
        KeyStore ks = KeyStore.getInstance(this.ksType);
        char[] password = this.readPasswordIfNotSet(this.ksPwd);
        HashSet<String> aliases = new HashSet<String>(10);
        if (realKsFile.exists()) {
            try (FileInputStream inStream = new FileInputStream(realKsFile);){
                ks.load(inStream, password);
            }
            Enumeration<String> strs = ks.aliases();
            while (strs.hasMoreElements()) {
                aliases.add(strs.nextElement());
            }
        } else {
            ks.load(null);
        }
        for (String certFile : this.certFiles) {
            String baseAlias;
            X509Certificate cert = X509Util.parseCert((String)certFile);
            String alias = baseAlias = X509Util.getCommonName((X500Principal)cert.getSubjectX500Principal());
            int idx = 2;
            while (aliases.contains(alias)) {
                alias = baseAlias + "-" + idx++;
            }
            ks.setCertificateEntry(alias, cert);
            aliases.add(alias);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);
        ks.store(bout, password);
        this.saveVerbose("saved keystore to file", realKsFile, bout.toByteArray());
        return null;
    }
}

