/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.shell.SecurityCommandSupport;
import org.xipki.security.util.KeyUtil;

@Command(scope="xipki-tk", name="keystore-convert", description="convert the keystore format")
@Service
public class KeystoreConvertCmd
extends SecurityCommandSupport {
    @Option(name="--in-type", required=true, description="type of source keystore\n(required)")
    private String inType;
    @Option(name="--in", required=true, description="file of source keystore\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String inFile;
    @Option(name="--in-pass", description="password of source keystore")
    private String inPass;
    @Option(name="--in-keypass-diff", description="whether the password for the keys differs from that of source keystore\nwill be ignored if --in-keypass is set")
    private Boolean inKeyPassDiff = Boolean.FALSE;
    @Option(name="--in-keypass", description="password for the keys of source keystore\nDefault to the keystore password")
    private String inKeyPass;
    @Option(name="--out-type", required=true, description="type of target keystore\n(required)")
    private String outType;
    @Option(name="--out", required=true, description="file of target keystore\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String outFile;
    @Option(name="--out-pass", description="password of target keystore")
    private String outPass;
    @Option(name="--out-keypass-diff", description="whether the password for the keys differs from that of target keystore\nwill be ignored if --out-keypass is set")
    private Boolean outKeyPassDiff = Boolean.FALSE;
    @Option(name="--out-keypass", description="password for the keys of target keystore\nDefault to the keystore password")
    private String outKeyPass;

    protected Object execute0() throws Exception {
        KeyStore srcKs = KeyUtil.getKeyStore((String)this.inType);
        char[] inPwd = this.inPass != null ? this.inPass.toCharArray() : this.readPassword("Enter the password of the source keystore");
        srcKs.load(new FileInputStream(this.inFile), inPwd);
        Enumeration<String> aliases = srcKs.aliases();
        boolean containsKeyEntry = false;
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!srcKs.isKeyEntry(alias)) continue;
            containsKeyEntry = true;
            break;
        }
        char[] inKeyPwd = null;
        if (containsKeyEntry) {
            inKeyPwd = this.inKeyPass != null ? this.inKeyPass.toCharArray() : (this.inKeyPassDiff != false ? this.readPassword("Enter the password for keys of the source keystore") : inPwd);
        }
        char[] outPwd = this.outPass != null ? this.outPass.toCharArray() : this.readPassword("Enter the password of the target keystore");
        char[] outKeyPwd = null;
        if (containsKeyEntry) {
            inKeyPwd = this.outKeyPass != null ? this.outKeyPass.toCharArray() : (this.outKeyPassDiff != false ? this.readPassword("Enter the password for keys of the target keystore") : inPwd);
        }
        KeyStore destKs = KeyUtil.getKeyStore((String)this.outType);
        destKs.load(null, outPwd);
        aliases = srcKs.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (srcKs.isKeyEntry(alias)) {
                Key key = srcKs.getKey(alias, inKeyPwd);
                Certificate[] chain = srcKs.getCertificateChain(alias);
                destKs.setKeyEntry(alias, key, outKeyPwd, chain);
                continue;
            }
            if (srcKs.isCertificateEntry(alias)) {
                Certificate cert = srcKs.getCertificate(alias);
                destKs.setCertificateEntry(alias, cert);
                continue;
            }
            this.println("entry " + alias + " is neither key nor certificate, ignore it");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        destKs.store(bout, outPwd);
        this.saveVerbose("converted keystore to", new File(this.outFile), bout.toByteArray());
        return null;
    }
}

