/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.File;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.password.OBFPasswordService;
import org.xipki.password.PBEAlgo;
import org.xipki.password.PBEPasswordService;
import org.xipki.security.shell.SecurityCommandSupport;

@Command(scope="xipki-tk", name="pbe-enc", description="encrypt password with master password")
@Service
public class PBEEncryptCmd
extends SecurityCommandSupport {
    @Option(name="--iteration-count", aliases={"-n"}, description="iteration count, between 1 and 65535")
    private int iterationCount = 2000;
    @Option(name="--out", description="where to save the encrypted password")
    @Completion(value=FilePathCompleter.class)
    private String outFile;
    @Option(name="-k", description="quorum of the password parts")
    private Integer quorum = 1;
    @Option(name="--mpassword-file", description="file containing the (obfuscated) master password")
    @Completion(value=FilePathCompleter.class)
    private String masterPasswordFile;
    @Option(name="--mk", description="quorum of the master password parts")
    private Integer mquorum = 1;

    protected Object execute0() throws Exception {
        char[] password;
        char[] masterPassword;
        ParamUtil.requireRange((String)"iterationCount", (int)this.iterationCount, (int)1, (int)65535);
        ParamUtil.requireRange((String)"k", (int)this.quorum, (int)1, (int)10);
        ParamUtil.requireRange((String)"mk", (int)this.mquorum, (int)1, (int)10);
        if (this.masterPasswordFile != null) {
            String str = new String(IoUtil.read((String)this.masterPasswordFile));
            if (str.startsWith("OBF:") || str.startsWith("obf:")) {
                str = OBFPasswordService.deobfuscate((String)str);
            }
            masterPassword = str.toCharArray();
        } else if (this.mquorum == 1) {
            masterPassword = this.readPassword("Master password");
        } else {
            char[][] parts = new char[this.mquorum.intValue()][];
            for (int i = 0; i < this.mquorum; ++i) {
                parts[i] = this.readPassword("Master password (part " + (i + 1) + "/" + this.mquorum + ")");
            }
            masterPassword = StringUtil.merge((char[][])parts);
        }
        if (this.quorum == 1) {
            password = this.readPassword("Password");
        } else {
            char[][] parts = new char[this.quorum.intValue()][];
            for (int i = 0; i < this.quorum; ++i) {
                parts[i] = this.readPassword("Password (part " + (i + 1) + "/" + this.quorum + ")");
            }
            password = StringUtil.merge((char[][])parts);
        }
        String passwordHint = PBEPasswordService.encryptPassword((PBEAlgo)PBEAlgo.PBEWithHmacSHA256AndAES_256, (int)this.iterationCount, (char[])masterPassword, (char[])password);
        if (this.outFile != null) {
            this.saveVerbose("saved the encrypted password to file", new File(this.outFile), passwordHint.getBytes());
        } else {
            this.println("the encrypted password is: '" + passwordHint + "'");
        }
        return null;
    }
}

