/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import java.security.cert.X509Certificate;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.shell.SecurityCommandSupport;
import org.xipki.security.shell.completer.P11ModuleNameCompleter;
import org.xipki.security.util.X509Util;

@Command(scope="xipki-tk", name="add-cert", description="add certificate to PKCS#11 device")
@Service
public class P11CertAddCmd
extends SecurityCommandSupport {
    @Option(name="--slot", required=true, description="slot index\n(required)")
    private Integer slotIndex;
    @Option(name="--cert", required=true, description="certificate file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String certFile;
    @Option(name="--module", description="name of the PKCS#11 module.")
    @Completion(value=P11ModuleNameCompleter.class)
    private String moduleName = "default";

    protected Object execute0() throws Exception {
        X509Certificate cert = X509Util.parseCert((String)this.certFile);
        P11Slot slot = this.getSlot(this.moduleName, this.slotIndex);
        P11ObjectIdentifier objectId = slot.addCert(cert);
        this.println("added certificate under " + objectId);
        return null;
    }
}

