/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import java.security.cert.X509Certificate;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgoType;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;
import org.xipki.security.shell.CertRequestGenCommandSupport;
import org.xipki.security.shell.completer.P11ModuleNameCompleter;

@Command(scope="xipki-tk", name="req", description="generate CSR request with PKCS#11 device")
@Service
public class P11CertRequestGenCmd
extends CertRequestGenCommandSupport {
    @Option(name="--slot", required=true, description="slot index\n(required)")
    private Integer slotIndex;
    @Option(name="--id", description="id of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
    private String id;
    @Option(name="--label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
    private String label;
    @Option(name="--module", description="name of the PKCS#11 module")
    @Completion(value=P11ModuleNameCompleter.class)
    private String moduleName = "default";

    @Override
    protected ConcurrentContentSigner getSigner(SignatureAlgoControl signatureAlgoControl) throws Exception {
        ParamUtil.requireNonNull((String)"signatureAlgoControl", (Object)signatureAlgoControl);
        byte[] idBytes = null;
        if (this.id != null) {
            idBytes = Hex.decode((String)this.id);
        }
        SignerConf conf = SignerConf.getPkcs11SignerConf((String)this.moduleName, (Integer)this.slotIndex, null, (String)this.label, (byte[])idBytes, (int)1, (HashAlgoType)HashAlgoType.getNonNullHashAlgoType((String)this.hashAlgo), (SignatureAlgoControl)signatureAlgoControl);
        return this.securityFactory.createSigner("PKCS11", conf, (X509Certificate[])null);
    }
}

