/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.shell.p11.P11KeyGenCommandSupport;

@Command(scope="xipki-tk", name="dsa", description="generate DSA keypair in PKCS#11 device")
@Service
public class P11DSAKeyGenCmd
extends P11KeyGenCommandSupport {
    @Option(name="--plen", description="bit length of the prime")
    private Integer plen = 2048;
    @Option(name="--qlen", description="bit length of the sub-prime")
    private Integer qlen;

    protected Object execute0() throws Exception {
        if (this.plen % 1024 != 0) {
            throw new IllegalCmdParamException("plen is not multiple of 1024: " + this.plen);
        }
        if (this.qlen == null) {
            this.qlen = this.plen <= 1024 ? Integer.valueOf(160) : (this.plen <= 2048 ? Integer.valueOf(224) : Integer.valueOf(256));
        }
        P11Slot slot = this.getSlot();
        P11ObjectIdentifier objId = slot.generateDSAKeypair(this.plen.intValue(), this.qlen.intValue(), this.label, this.getControl());
        this.finalize("DSA", objId);
        return null;
    }

    @Override
    protected boolean getDefaultExtractable() {
        return true;
    }
}

