/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.completer.ECCurveNameCompleter;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.shell.p11.P11KeyGenCommandSupport;

@Command(scope="xipki-tk", name="ec", description="generate EC keypair in PKCS#11 device")
@Service
public class P11ECKeyGenCmd
extends P11KeyGenCommandSupport {
    @Option(name="--curve", description="EC curve name")
    @Completion(value=ECCurveNameCompleter.class)
    private String curveName = "secp256r1";

    protected Object execute0() throws Exception {
        P11Slot slot = this.getSlot();
        P11ObjectIdentifier objId = slot.generateECKeypair(this.curveName, this.label, this.getControl());
        this.finalize("EC", objId);
        return null;
    }

    @Override
    protected boolean getDefaultExtractable() {
        return false;
    }
}

