/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.shell.SecurityCommandSupport;
import org.xipki.security.shell.completer.P11ModuleNameCompleter;

@Command(scope="xipki-tk", name="delete-objects", description="delete objects in PKCS#11 device")
@Service
public class P11ObjectsDeleteCmd
extends SecurityCommandSupport {
    @Option(name="--slot", required=true, description="slot index\n(required)")
    protected Integer slotIndex;
    @Option(name="--id", description="id (hex) of the objects in the PKCS#11 device\nat least one of id and label must be specified")
    private String id;
    @Option(name="--label", description="label of the objects in the PKCS#11 device\nat least one of id and label must be specified")
    private String label;
    @Option(name="--module", description="name of the PKCS#11 module")
    @Completion(value=P11ModuleNameCompleter.class)
    protected String moduleName = "default";

    protected Object execute0() throws Exception {
        P11Slot slot = this.getSlot(this.moduleName, this.slotIndex);
        byte[] idBytes = null;
        if (this.id != null) {
            idBytes = Hex.decode((String)this.id);
        }
        int num = slot.removeObjects(idBytes, this.label);
        this.println("deleted " + num + " objects");
        return null;
    }
}

