/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.shell.p11.P11KeyGenCommandSupport;

@Command(scope="xipki-tk", name="rsa", description="generate RSA keypair in PKCS#11 device")
@Service
public class P11RSAKeyGenCmd
extends P11KeyGenCommandSupport {
    @Option(name="--key-size", description="keysize in bit")
    private Integer keysize = 2048;
    @Option(name="-e", description="public exponent")
    private String publicExponent = "0x10001";

    protected Object execute0() throws Exception {
        if (this.keysize % 1024 != 0) {
            throw new IllegalCmdParamException("keysize is not multiple of 1024: " + this.keysize);
        }
        P11Slot slot = this.getSlot();
        P11ObjectIdentifier objId = slot.generateRSAKeypair(this.keysize.intValue(), P11RSAKeyGenCmd.toBigInt((String)this.publicExponent), this.label, this.getControl());
        this.finalize("RSA", objId);
        return null;
    }

    @Override
    protected boolean getDefaultExtractable() {
        return false;
    }
}

