/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.util.IoUtil;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.shell.completer.SecretKeyTypeCompleter;
import org.xipki.security.shell.p11.P11KeyGenCommandSupport;

@Command(scope="xipki-tk", name="create-secretkey", description="create secret key with given value in PKCS#11 device")
@Service
public class P11SecretKeyCreateCmd
extends P11KeyGenCommandSupport {
    @Option(name="--key-type", required=true, description="keytype, current only AES, DES3 and GENERIC are supported\n(required)")
    @Completion(value=SecretKeyTypeCompleter.class)
    private String keyType;
    @Option(name="--keystore", required=true, description="JCEKS keystore from which the key is imported\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String keyOutFile;
    @Option(name="--password", description="password of the keystore file")
    private String password;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute0() throws Exception {
        long p11KeyType;
        if ("AES".equalsIgnoreCase(this.keyType)) {
            p11KeyType = 31L;
        } else if ("DES3".equalsIgnoreCase(this.keyType)) {
            p11KeyType = 21L;
        } else if ("GENERIC".equalsIgnoreCase(this.keyType)) {
            p11KeyType = 16L;
        } else {
            throw new IllegalCmdParamException("invalid keyType " + this.keyType);
        }
        KeyStore ks = KeyStore.getInstance("JCEKS");
        char[] pwd = this.getPassword();
        try (FileInputStream ksStream = new FileInputStream(IoUtil.expandFilepath((String)this.keyOutFile));){
            ks.load(ksStream, pwd);
        }
        byte[] keyValue = null;
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            Key key;
            String alias = aliases.nextElement();
            if (!ks.isKeyEntry(alias) || !((key = ks.getKey(alias, pwd)) instanceof SecretKey)) continue;
            keyValue = ((SecretKey)key).getEncoded();
            break;
        }
        if (keyValue == null) {
            throw new IllegalCmdParamException("keystore does not contain secret key");
        }
        P11Slot slot = this.getSlot();
        P11ObjectIdentifier objId = slot.createSecretKey(p11KeyType, keyValue, this.label, this.getControl());
        this.finalize("Create Secret Key", objId);
        return null;
    }

    @Override
    protected boolean getDefaultExtractable() {
        return true;
    }

    protected char[] getPassword() throws IOException {
        char[] pwdInChar = this.readPasswordIfNotSet(this.password);
        if (pwdInChar != null) {
            this.password = new String(pwdInChar);
        }
        return pwdInChar;
    }
}

