/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.shell.completer.SecretKeyTypeCompleter;
import org.xipki.security.shell.p11.P11KeyGenCommandSupport;

@Command(scope="xipki-tk", name="secretkey", description="generate secret key in PKCS#11 device")
@Service
public class P11SecretKeyGenCmd
extends P11KeyGenCommandSupport {
    @Option(name="--key-type", required=true, description="keytype, current only AES, DES3 and GENERIC are supported\n(required)")
    @Completion(value=SecretKeyTypeCompleter.class)
    private String keyType;
    @Option(name="--key-size", required=true, description="keysize in bit.")
    private Integer keysize;

    protected Object execute0() throws Exception {
        long p11KeyType;
        if ("AES".equalsIgnoreCase(this.keyType)) {
            p11KeyType = 31L;
        } else if ("DES3".equalsIgnoreCase(this.keyType)) {
            p11KeyType = 21L;
        } else if ("GENERIC".equalsIgnoreCase(this.keyType)) {
            p11KeyType = 16L;
        } else {
            throw new IllegalCmdParamException("invalid keyType " + this.keyType);
        }
        P11Slot slot = this.getSlot();
        P11ObjectIdentifier objId = slot.generateSecretKey(p11KeyType, this.keysize.intValue(), this.label, this.getControl());
        this.finalize("Generate Secret Key", objId);
        return null;
    }

    @Override
    protected boolean getDefaultExtractable() {
        return true;
    }
}

