/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.shell.SecurityCommandSupport;
import org.xipki.security.shell.completer.P11ModuleNameCompleter;

public abstract class P11SecurityCommandSupport
extends SecurityCommandSupport {
    @Option(name="--slot", required=true, description="slot index\n(required)")
    protected Integer slotIndex;
    @Option(name="--id", description="id of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
    protected String id;
    @Option(name="--label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
    protected String label;
    @Option(name="--module", description="name of the PKCS#11 module")
    @Completion(value=P11ModuleNameCompleter.class)
    protected String moduleName = "default";

    public P11ObjectIdentifier getObjectIdentifier() throws IllegalCmdParamException, XiSecurityException, P11TokenException {
        P11ObjectIdentifier objIdentifier;
        P11Slot slot = this.getSlot();
        if (this.id != null && this.label == null) {
            objIdentifier = slot.getObjectIdForId(Hex.decode((String)this.id));
        } else if (this.id == null && this.label != null) {
            objIdentifier = slot.getObjectIdForLabel(this.label);
        } else {
            throw new IllegalCmdParamException("exactly one of keyId or keyLabel should be specified");
        }
        return objIdentifier;
    }

    protected P11Slot getSlot() throws XiSecurityException, P11TokenException, IllegalCmdParamException {
        return this.getSlot(this.moduleName, this.slotIndex);
    }
}

