/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import java.io.OutputStream;
import java.util.List;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.shell.SecurityCommandSupport;
import org.xipki.security.shell.completer.P11ModuleNameCompleter;

@Command(scope="xipki-tk", name="token-info", description="list objects in PKCS#11 device")
@Service
public class P11TokenInfoCmd
extends SecurityCommandSupport {
    @Option(name="--verbose", aliases={"-v"}, description="show object information verbosely")
    private Boolean verbose = Boolean.FALSE;
    @Option(name="--module", description="name of the PKCS#11 module.")
    @Completion(value=P11ModuleNameCompleter.class)
    private String moduleName = "default";
    @Option(name="--slot", description="slot index")
    private Integer slotIndex;

    protected Object execute0() throws Exception {
        P11Module module = this.getP11Module(this.moduleName);
        this.println("module: " + this.moduleName);
        List slots = module.slotIdentifiers();
        if (this.slotIndex == null) {
            this.output(slots);
            return null;
        }
        P11Slot slot = this.getSlot(this.moduleName, this.slotIndex);
        slot.showDetails((OutputStream)System.out, this.verbose.booleanValue());
        System.out.println();
        System.out.flush();
        return null;
    }

    private void output(List<P11SlotIdentifier> slots) {
        int n = slots.size();
        if (n == 0 || n == 1) {
            String numText = n == 0 ? "no" : "1";
            this.println(numText + " slot is configured");
        } else {
            this.println(n + " slots are configured");
        }
        for (P11SlotIdentifier slotId : slots) {
            this.println("\tslot[" + slotId.index() + "]: " + slotId.id());
        }
    }
}

