/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p12;

import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.ConfPairs;
import org.xipki.common.ObjectCreationException;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.HashAlgoType;
import org.xipki.security.SignerConf;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.shell.p12.P12SecurityCommandSupport;
import org.xipki.security.util.X509Util;

@Command(scope="xipki-tk", name="update-cert-p12", description="update certificate in PKCS#12 keystore")
@Service
public class P12CertUpdateCmd
extends P12SecurityCommandSupport {
    @Option(name="--cert", required=true, description="certificate file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String certFile;
    @Option(name="--ca-cert", multiValued=true, description="CA Certificate file\n(multi-valued)")
    @Completion(value=FilePathCompleter.class)
    private Set<String> caCertFiles;

    protected Object execute0() throws Exception {
        KeyStore ks = this.getKeyStore();
        char[] pwd = this.getPassword();
        X509Certificate newCert = X509Util.parseCert((String)this.certFile);
        this.assertMatch(newCert, new String(pwd));
        String keyname = null;
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            keyname = alias;
            break;
        }
        if (keyname == null) {
            throw new XiSecurityException("could not find private key");
        }
        Key key = ks.getKey(keyname, pwd);
        HashSet<X509Certificate> caCerts = new HashSet<X509Certificate>();
        if (P12CertUpdateCmd.isNotEmpty(this.caCertFiles)) {
            for (String caCertFile : this.caCertFiles) {
                caCerts.add(X509Util.parseCert((String)caCertFile));
            }
        }
        Certificate[] certChain = X509Util.buildCertPath((X509Certificate)newCert, caCerts);
        ks.setKeyEntry(keyname, key, pwd, certChain);
        try (FileOutputStream out = new FileOutputStream(this.p12File);){
            ks.store(out, pwd);
            this.println("updated certificate");
            Object var11_11 = null;
            return var11_11;
        }
    }

    private void assertMatch(X509Certificate cert, String password) throws ObjectCreationException {
        ConfPairs pairs = new ConfPairs("keystore", "file:" + this.p12File);
        if (password != null) {
            pairs.putPair("password", new String(password));
        }
        SignerConf conf = new SignerConf(pairs.getEncoded(), HashAlgoType.SHA256, null);
        this.securityFactory.createSigner("PKCS12", conf, cert);
    }
}

