/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p12;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.security.pkcs12.P12KeyGenerationResult;
import org.xipki.security.pkcs12.P12KeyGenerator;
import org.xipki.security.shell.p12.P12KeyGenCommandSupport;

@Command(scope="xipki-tk", name="dsa-p12", description="generate RSA keypair in PKCS#12 keystore")
@Service
public class P12DSAKeyGenCmd
extends P12KeyGenCommandSupport {
    @Option(name="--subject", aliases={"-s"}, description="subject of the self-signed certificate")
    private String subject;
    @Option(name="--plen", description="bit length of the prime")
    private Integer plen = 2048;
    @Option(name="--qlen", description="bit length of the sub-prime")
    private Integer qlen;

    protected Object execute0() throws Exception {
        if (this.plen % 1024 != 0) {
            throw new IllegalCmdParamException("plen is not multiple of 1024: " + this.plen);
        }
        if (this.qlen == null) {
            this.qlen = this.plen <= 1024 ? Integer.valueOf(160) : (this.plen <= 2048 ? Integer.valueOf(224) : Integer.valueOf(256));
        }
        P12KeyGenerationResult keypair = new P12KeyGenerator().generateDSAKeypair(this.plen.intValue(), this.qlen.intValue(), this.getKeyGenParameters(), this.subject);
        this.saveKey(keypair);
        return null;
    }
}

