/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p12;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.shell.SecurityCommandSupport;
import org.xipki.security.util.KeyUtil;

public abstract class P12SecurityCommandSupport
extends SecurityCommandSupport {
    @Option(name="--p12", required=true, description="PKCS#12 keystore file\n(required)")
    @Completion(value=FilePathCompleter.class)
    protected String p12File;
    @Option(name="--password", description="password of the PKCS#12 file")
    protected String password;

    protected char[] getPassword() throws IOException {
        char[] pwdInChar = this.readPasswordIfNotSet(this.password);
        if (pwdInChar != null) {
            this.password = new String(pwdInChar);
        }
        return pwdInChar;
    }

    protected KeyStore getKeyStore() throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, NoSuchProviderException {
        KeyStore ks;
        try (FileInputStream in = new FileInputStream(P12SecurityCommandSupport.expandFilepath((String)this.p12File));){
            ks = KeyUtil.getKeyStore((String)"PKCS12");
            ks.load(in, this.getPassword());
        }
        return ks;
    }
}

