/*
 *
 * Copyright (c) 2013 - 2017 Lijun Liao
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.xipki.security.shell.completer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.AbstractDynamicEnumCompleter;

/**
 * @author Lijun Liao
 * @since 2.2.0
 */

@Service
public class SecretKeyTypeCompleter extends AbstractDynamicEnumCompleter {

    private static final Set<String> TYPES = Collections.unmodifiableSet(
            new HashSet<>(Arrays.asList("DES3", "AES", "GENERIC")));

    @Override
    protected Set<String> getEnums() {
        return TYPES;
    }

}
