/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.math.BigInteger;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.common.util.IoUtil;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.console.karaf.completer.HashAlgCompleter;
import org.xipki.security.HashAlgoType;
import org.xipki.security.shell.SecurityCommandSupport;

@Command(scope="xi", name="cert-info", description="print certificate information")
@Service
public class CertInfoCmd
extends SecurityCommandSupport {
    @Option(name="--in", description="certificate file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String inFile;
    @Option(name="--hex", aliases={"-h"}, description="print hex number")
    private Boolean hex = Boolean.FALSE;
    @Option(name="--serial", description="print serial number")
    private Boolean serial;
    @Option(name="--subject", description="print subject")
    private Boolean subject;
    @Option(name="--issuer", description="print issuer")
    private Boolean issuer;
    @Option(name="--not-before", description="print notBefore")
    private Boolean notBefore;
    @Option(name="--not-after", description="print notAfter")
    private Boolean notAfter;
    @Option(name="--fingerprint", description="print fingerprint in hex")
    private Boolean fingerprint;
    @Option(name="--hash", description="hash algorithm name")
    @Completion(value=HashAlgCompleter.class)
    protected String hashAlgo = "SHA256";

    protected Object execute0() throws Exception {
        Certificate cert = Certificate.getInstance((Object)IoUtil.read((String)this.inFile));
        if (this.serial != null && this.serial.booleanValue()) {
            return this.getNumber(cert.getSerialNumber().getPositiveValue());
        }
        if (this.subject != null && this.subject.booleanValue()) {
            return cert.getSubject().toString();
        }
        if (this.issuer != null && this.issuer.booleanValue()) {
            return cert.getIssuer().toString();
        }
        if (this.notBefore != null && this.notBefore.booleanValue()) {
            return this.toUtcTimeyyyyMMddhhmmssZ(cert.getStartDate().getDate());
        }
        if (this.notAfter != null && this.notAfter.booleanValue()) {
            return this.toUtcTimeyyyyMMddhhmmssZ(cert.getEndDate().getDate());
        }
        if (this.fingerprint != null && this.fingerprint.booleanValue()) {
            byte[] encoded = cert.getEncoded();
            return HashAlgoType.getHashAlgoType((String)this.hashAlgo).hexHash(encoded);
        }
        return null;
    }

    private String getNumber(Number no) {
        if (!this.hex.booleanValue()) {
            return no.toString();
        }
        if (no instanceof Byte) {
            return "0X" + Hex.toHexString((byte[])new byte[]{(Byte)no});
        }
        if (no instanceof Short) {
            return "0X" + Integer.toHexString(((Short)no).shortValue());
        }
        if (no instanceof Integer) {
            return "0X" + Integer.toHexString((Integer)no);
        }
        if (no instanceof Long) {
            return "0X" + Long.toHexString((Long)no);
        }
        if (no instanceof Long) {
            return "0X" + Long.toHexString((Long)no);
        }
        if (no instanceof BigInteger) {
            return "0X" + ((BigInteger)no).toString(16);
        }
        return no.toString();
    }
}

