/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.File;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.qualified.BiometricData;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.console.karaf.completer.ExtKeyusageCompleter;
import org.xipki.console.karaf.completer.ExtensionNameCompleter;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.console.karaf.completer.HashAlgCompleter;
import org.xipki.console.karaf.completer.KeyusageCompleter;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.ExtensionExistence;
import org.xipki.security.KeyUsage;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.exception.BadInputException;
import org.xipki.security.exception.InvalidOidOrNameException;
import org.xipki.security.exception.NoIdleSignerException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.shell.SecurityCommandSupport;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;

public abstract class CertRequestGenCommandSupport
extends SecurityCommandSupport {
    @Option(name="--hash", description="hash algorithm name")
    @Completion(value=HashAlgCompleter.class)
    protected String hashAlgo = "SHA256";
    @Option(name="--subject-alt-name", multiValued=true, description="subjectAltName\n(multi-valued)")
    protected List<String> subjectAltNames;
    @Option(name="--subject-info-access", multiValued=true, description="subjectInfoAccess\n(multi-valued)")
    protected List<String> subjectInfoAccesses;
    @Option(name="--subject", aliases={"-s"}, required=true, description="subject in the CSR\n(required)")
    private String subject;
    @Option(name="--rsa-mgf1", description="whether to use the RSAPSS MGF1 for the POPO computation\n(only applied to RSA key)")
    private Boolean rsaMgf1 = Boolean.FALSE;
    @Option(name="--dsa-plain", description="whether to use the Plain DSA for the POPO computation")
    private Boolean dsaPlain = Boolean.FALSE;
    @Option(name="--out", aliases={"-o"}, required=true, description="output file name\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String outputFilename;
    @Option(name="--challenge-password", aliases={"-c"}, description="Challenge password")
    private String challengePassword;
    @Option(name="--keyusage", multiValued=true, description="keyusage\n(multi-valued)")
    @Completion(value=KeyusageCompleter.class)
    private List<String> keyusages;
    @Option(name="--ext-keyusage", multiValued=true, description="extended keyusage\n(multi-valued)")
    @Completion(value=ExtKeyusageCompleter.class)
    private List<String> extkeyusages;
    @Option(name="--qc-eu-limit", multiValued=true, description="QC EuLimitValue of format <currency>:<amount>:<exponent>.\n(multi-valued)")
    private List<String> qcEuLimits;
    @Option(name="--biometric-type", description="Biometric type")
    private String biometricType;
    @Option(name="--biometric-hash", description="Biometric hash algorithm")
    @Completion(value=HashAlgCompleter.class)
    private String biometricHashAlgo;
    @Option(name="--biometric-file", description="Biometric hash algorithm")
    private String biometricFile;
    @Option(name="--biometric-uri", description="Biometric sourcedata URI")
    @Completion(value=FilePathCompleter.class)
    private String biometricUri;
    @Option(name="--need-extension", multiValued=true, description="types of extension that must be contained in the certificate\n(multi-valued)")
    @Completion(value=ExtensionNameCompleter.class)
    private List<String> needExtensionTypes;
    @Option(name="--want-extension", multiValued=true, description="types of extension that should be contained in the certificate if possible\n(multi-valued)")
    @Completion(value=ExtensionNameCompleter.class)
    private List<String> wantExtensionTypes;

    protected abstract ConcurrentContentSigner getSigner(SignatureAlgoControl var1) throws Exception;

    protected Object execute0() throws Exception {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        Object extType;
        ASN1ObjectIdentifier oid;
        this.hashAlgo = this.hashAlgo.trim().toUpperCase();
        if (this.hashAlgo.indexOf(45) != -1) {
            this.hashAlgo = this.hashAlgo.replaceAll("-", "");
        }
        if (this.needExtensionTypes == null) {
            this.needExtensionTypes = new LinkedList<String>();
        }
        if (this.wantExtensionTypes == null) {
            this.wantExtensionTypes = new LinkedList<String>();
        }
        LinkedList<Extension> extensions = new LinkedList<Extension>();
        ASN1OctetString extnValue = this.createExtnValueSubjectAltName();
        if (extnValue != null) {
            oid = Extension.subjectAlternativeName;
            extensions.add(new Extension(oid, false, extnValue));
            this.needExtensionTypes.add(oid.getId());
        }
        if ((extnValue = this.createExtnValueSubjectInfoAccess()) != null) {
            oid = Extension.subjectInfoAccess;
            extensions.add(new Extension(oid, false, extnValue));
            this.needExtensionTypes.add(oid.getId());
        }
        if (CertRequestGenCommandSupport.isNotEmpty(this.keyusages)) {
            HashSet<KeyUsage> usages = new HashSet<KeyUsage>();
            for (String usage : this.keyusages) {
                usages.add(KeyUsage.getKeyUsage((String)usage));
            }
            org.bouncycastle.asn1.x509.KeyUsage extValue = X509Util.createKeyUsage(usages);
            ASN1ObjectIdentifier extType2 = Extension.keyUsage;
            extensions.add(new Extension(extType2, false, extValue.getEncoded()));
            this.needExtensionTypes.add(extType2.getId());
        }
        if (CertRequestGenCommandSupport.isNotEmpty(this.extkeyusages)) {
            ExtendedKeyUsage extValue = X509Util.createExtendedUsage(CertRequestGenCommandSupport.textToAsn1ObjectIdentifers(this.extkeyusages));
            extType = Extension.extendedKeyUsage;
            extensions.add(new Extension((ASN1ObjectIdentifier)extType, false, extValue.getEncoded()));
            this.needExtensionTypes.add(extType.getId());
        }
        if (CertRequestGenCommandSupport.isNotEmpty(this.qcEuLimits)) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            for (String m : this.qcEuLimits) {
                StringTokenizer st = new StringTokenizer(m, ":");
                try {
                    Iso4217CurrencyCode currency;
                    String currencyS = st.nextToken();
                    String amountS = st.nextToken();
                    String exponentS = st.nextToken();
                    try {
                        int intValue = Integer.parseInt(currencyS);
                        currency = new Iso4217CurrencyCode(intValue);
                    }
                    catch (NumberFormatException ex) {
                        currency = new Iso4217CurrencyCode(currencyS);
                    }
                    int amount = Integer.parseInt(amountS);
                    int exponent = Integer.parseInt(exponentS);
                    MonetaryValue monterayValue = new MonetaryValue(currency, amount, exponent);
                    QCStatement statment = new QCStatement(ObjectIdentifiers.id_etsi_qcs_QcLimitValue, (ASN1Encodable)monterayValue);
                    vec.add((ASN1Encodable)statment);
                }
                catch (Exception ex) {
                    throw new Exception("invalid qc-eu-limit '" + m + "'");
                }
            }
            extType = Extension.qCStatements;
            DERSequence extValue = new DERSequence(vec);
            extensions.add(new Extension((ASN1ObjectIdentifier)extType, false, extValue.getEncoded()));
            this.needExtensionTypes.add(extType.getId());
        }
        if (this.biometricType != null && this.biometricHashAlgo != null && this.biometricFile != null) {
            TypeOfBiometricData tmpBiometricType = StringUtil.isNumber((String)this.biometricType) ? new TypeOfBiometricData(Integer.parseInt(this.biometricType)) : new TypeOfBiometricData(new ASN1ObjectIdentifier(this.biometricType));
            ASN1ObjectIdentifier tmpBiometricHashAlgo = AlgorithmUtil.getHashAlg((String)this.biometricHashAlgo);
            byte[] biometricBytes = IoUtil.read((String)this.biometricFile);
            MessageDigest md = MessageDigest.getInstance(tmpBiometricHashAlgo.getId());
            md.reset();
            byte[] tmpBiometricDataHash = md.digest(biometricBytes);
            DERIA5String tmpSourceDataUri = null;
            if (this.biometricUri != null) {
                tmpSourceDataUri = new DERIA5String(this.biometricUri);
            }
            BiometricData biometricData = new BiometricData(tmpBiometricType, new AlgorithmIdentifier(tmpBiometricHashAlgo), (ASN1OctetString)new DEROctetString(tmpBiometricDataHash), tmpSourceDataUri);
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)biometricData);
            ASN1ObjectIdentifier extType3 = Extension.biometricInfo;
            DERSequence extValue = new DERSequence(vec);
            extensions.add(new Extension(extType3, false, extValue.getEncoded()));
            this.needExtensionTypes.add(extType3.getId());
        } else if (this.biometricType != null || this.biometricHashAlgo != null || this.biometricFile != null) {
            throw new Exception("either all of biometric triples (type, hash algo, file) must be set or none of them should be set");
        }
        for (Extension addExt : this.getAdditionalExtensions()) {
            extensions.add(addExt);
        }
        this.needExtensionTypes.addAll(this.getAdditionalNeedExtensionTypes());
        this.wantExtensionTypes.addAll(this.getAdditionalWantExtensionTypes());
        if (CertRequestGenCommandSupport.isNotEmpty(this.needExtensionTypes) || CertRequestGenCommandSupport.isNotEmpty(this.wantExtensionTypes)) {
            ExtensionExistence ee = new ExtensionExistence(CertRequestGenCommandSupport.textToAsn1ObjectIdentifers(this.needExtensionTypes), CertRequestGenCommandSupport.textToAsn1ObjectIdentifers(this.wantExtensionTypes));
            extensions.add(new Extension(ObjectIdentifiers.id_xipki_ext_cmpRequestExtensions, false, ee.toASN1Primitive().getEncoded()));
        }
        ConcurrentContentSigner signer = this.getSigner(new SignatureAlgoControl(this.rsaMgf1.booleanValue(), this.dsaPlain.booleanValue()));
        HashMap<ASN1ObjectIdentifier, ASN1Encodable> attributes = new HashMap<ASN1ObjectIdentifier, ASN1Encodable>();
        if (CollectionUtil.isNonEmpty(extensions)) {
            attributes.put(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)new Extensions(extensions.toArray(new Extension[0])));
        }
        if (StringUtil.isNotBlank((String)this.challengePassword)) {
            attributes.put(PKCSObjectIdentifiers.pkcs_9_at_challengePassword, (ASN1Encodable)new DERPrintableString(this.challengePassword));
        }
        if (signer.getCertificate() != null) {
            Certificate cert = Certificate.getInstance((Object)signer.getCertificate().getEncoded());
            subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
        } else {
            subjectPublicKeyInfo = KeyUtil.createSubjectPublicKeyInfo((PublicKey)signer.getPublicKey());
        }
        X500Name subjectDn = this.getSubject(this.subject);
        PKCS10CertificationRequest csr = this.generateRequest(signer, subjectPublicKeyInfo, subjectDn, attributes);
        File file = new File(this.outputFilename);
        this.saveVerbose("saved CSR to file", file, csr.getEncoded());
        return null;
    }

    protected X500Name getSubject(String subjectText) {
        ParamUtil.requireNonBlank((String)"subjectText", (String)subjectText);
        return new X500Name(subjectText);
    }

    protected List<String> getAdditionalNeedExtensionTypes() {
        return Collections.emptyList();
    }

    protected List<String> getAdditionalWantExtensionTypes() {
        return Collections.emptyList();
    }

    protected List<Extension> getAdditionalExtensions() throws BadInputException {
        return Collections.emptyList();
    }

    protected ASN1OctetString createExtnValueSubjectAltName() throws BadInputException {
        return CertRequestGenCommandSupport.isEmpty(this.subjectAltNames) ? null : X509Util.createExtensionSubjectAltName(this.subjectAltNames, (boolean)false).getExtnValue();
    }

    protected ASN1OctetString createExtnValueSubjectInfoAccess() throws BadInputException {
        return CertRequestGenCommandSupport.isEmpty(this.subjectInfoAccesses) ? null : X509Util.createExtensionSubjectInfoAccess(this.subjectInfoAccesses, (boolean)false).getExtnValue();
    }

    private static List<ASN1ObjectIdentifier> textToAsn1ObjectIdentifers(List<String> oidTexts) throws InvalidOidOrNameException {
        if (oidTexts == null) {
            return null;
        }
        ArrayList<ASN1ObjectIdentifier> ret = new ArrayList<ASN1ObjectIdentifier>(oidTexts.size());
        for (String oidText : oidTexts) {
            ASN1ObjectIdentifier oid;
            if (oidText.isEmpty() || ret.contains(oid = CertRequestGenCommandSupport.toOid(oidText))) continue;
            ret.add(oid);
        }
        return ret;
    }

    private static ASN1ObjectIdentifier toOid(String str) throws InvalidOidOrNameException {
        ASN1ObjectIdentifier oid;
        int n = str.length();
        boolean isName = false;
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '1' || ch == '.') continue;
            isName = true;
        }
        if (!isName) {
            try {
                return new ASN1ObjectIdentifier(str);
            }
            catch (IllegalArgumentException i) {
                // empty catch block
            }
        }
        if ((oid = ObjectIdentifiers.nameToOid((String)str)) == null) {
            throw new InvalidOidOrNameException(str);
        }
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PKCS10CertificationRequest generateRequest(ConcurrentContentSigner signer, SubjectPublicKeyInfo subjectPublicKeyInfo, X500Name subjectDn, Map<ASN1ObjectIdentifier, ASN1Encodable> attributes) throws XiSecurityException {
        ConcurrentBagEntrySigner signer0;
        ParamUtil.requireNonNull((String)"signer", (Object)signer);
        ParamUtil.requireNonNull((String)"subjectPublicKeyInfo", (Object)subjectPublicKeyInfo);
        ParamUtil.requireNonNull((String)"subjectDn", (Object)subjectDn);
        PKCS10CertificationRequestBuilder csrBuilder = new PKCS10CertificationRequestBuilder(subjectDn, subjectPublicKeyInfo);
        if (CollectionUtil.isNonEmpty(attributes)) {
            for (ASN1ObjectIdentifier attrType : attributes.keySet()) {
                csrBuilder.addAttribute(attrType, attributes.get(attrType));
            }
        }
        try {
            signer0 = signer.borrowContentSigner();
        }
        catch (NoIdleSignerException ex) {
            throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
        }
        try {
            PKCS10CertificationRequest pKCS10CertificationRequest = csrBuilder.build((ContentSigner)signer0.value());
            return pKCS10CertificationRequest;
        }
        finally {
            signer.requiteContentSigner(signer0);
        }
    }
}

