/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xipki.common.util.IoUtil;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.shell.SecurityCommandSupport;
import org.xipki.security.util.AlgorithmUtil;

@Command(scope="xi", name="validate-csr", description="validate CSR")
@Service
public class CertRequestValidateCmd
extends SecurityCommandSupport {
    @Option(name="--csr", required=true, description="CSR file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String csrFile;

    protected Object execute0() throws Exception {
        CertificationRequest csr = CertificationRequest.getInstance((Object)IoUtil.read((String)this.csrFile));
        String sigAlgo = AlgorithmUtil.getSignatureAlgoName((AlgorithmIdentifier)csr.getSignatureAlgorithm());
        boolean bo = this.securityFactory.verifyPopo(csr, null);
        String txt = bo ? "valid" : "invalid";
        this.println("The POP is " + txt + " (signature algorithm " + sigAlgo + ").");
        return null;
    }
}

