/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.util.CompareUtil;
import org.xipki.common.util.IoUtil;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.shell.SecurityCommandSupport;
import org.xipki.security.shell.completer.KeystoreTypeCompleter;

@Command(scope="xi", name="convert-keystore", description="Convert keystore")
@Service
public class ConvertKeystoreCmd
extends SecurityCommandSupport {
    @Option(name="--in", required=true, description="Source keystore file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String inFile;
    @Option(name="--intype", required=true, description="Type of the source keystore\n(required)")
    @Completion(value=KeystoreTypeCompleter.class)
    private String inType;
    @Option(name="--inpwd", description="password of the source keystore")
    private String inPwd;
    @Option(name="--out", required=true, description="Destination keystore file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String outFile;
    @Option(name="--outtype", required=true, description="Type of the destination keystore\n(required)")
    @Completion(value=KeystoreTypeCompleter.class)
    private String outType;
    @Option(name="--outpwd", description="password of the destination keystore")
    private String outPwd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute0() throws Exception {
        File realOutFile;
        File realInFile = new File(IoUtil.expandFilepath((String)this.inFile));
        if (CompareUtil.equalsObject((Object)realInFile, (Object)(realOutFile = new File(IoUtil.expandFilepath((String)this.outFile))))) {
            throw new IllegalCmdParamException("in and out cannot be the same");
        }
        KeyStore inKs = KeyStore.getInstance(this.inType);
        KeyStore outKs = KeyStore.getInstance(this.outType);
        outKs.load(null);
        char[] inPassword = this.readPasswordIfNotSet("password of the source keystore", this.inPwd);
        try (FileInputStream inStream = new FileInputStream(realInFile);){
            inKs.load(inStream, inPassword);
        }
        char[] outPassword = this.readPasswordIfNotSet("password of the destination keystore", this.outPwd);
        Enumeration<String> aliases = inKs.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (inKs.isKeyEntry(alias)) {
                Certificate[] certs = inKs.getCertificateChain(alias);
                Key key = inKs.getKey(alias, inPassword);
                outKs.setKeyEntry(alias, key, outPassword, certs);
                continue;
            }
            Certificate cert = inKs.getCertificate(alias);
            outKs.setCertificateEntry(alias, cert);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);
        outKs.store(bout, outPassword);
        this.saveVerbose("saved destination keystore to file", realOutFile, bout.toByteArray());
        return null;
    }
}

