/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.File;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.password.OBFPasswordService;
import org.xipki.security.shell.SecurityCommandSupport;

@Command(scope="xi", name="deobfuscate", description="deobfuscate password")
@Service
public class DeobfuscateCmd
extends SecurityCommandSupport {
    @Option(name="--password", description="obfuscated password, starts with OBF:\nexactly one of password and password-file must be specified")
    private String passwordHint;
    @Option(name="--password-file", description="file containing the obfuscated password")
    @Completion(value=FilePathCompleter.class)
    private String passwordFile;
    @Option(name="--out", description="where to save the password")
    @Completion(value=FilePathCompleter.class)
    private String outFile;

    protected Object execute0() throws Exception {
        if (!(this.passwordHint == null ^ this.passwordFile == null)) {
            throw new IllegalCmdParamException("exactly one of password and password-file must be specified");
        }
        if (this.passwordHint == null) {
            this.passwordHint = new String(IoUtil.read((String)this.passwordFile));
        }
        if (!StringUtil.startsWithIgnoreCase((String)this.passwordHint, (String)"OBF:")) {
            throw new IllegalCmdParamException("encrypted password '" + this.passwordHint + "' does not start with OBF:");
        }
        String password = OBFPasswordService.deobfuscate((String)this.passwordHint);
        if (this.outFile != null) {
            this.saveVerbose("saved the password to file", new File(this.outFile), new String(password).getBytes());
        } else {
            this.println("the password is: '" + new String(password) + "'");
        }
        return null;
    }
}

