/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.security.cert.X509CRL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.console.karaf.CmdFailure;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.HashAlgoType;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.shell.SecurityCommandSupport;
import org.xipki.security.util.X509Util;

@Command(scope="xi", name="extract-cert", description="extract certificates from CRL")
@Service
public class ExtractCertFromCrlCmd
extends SecurityCommandSupport {
    @Option(name="--crl", required=true, description="CRL file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String crlFile;
    @Option(name="--out", aliases={"-o"}, required=true, description="ZIP file to save the extracted certificates\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String outFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute0() throws Exception {
        String oidExtnCerts;
        X509CRL crl = X509Util.parseCrl((String)this.crlFile);
        byte[] extnValue = crl.getExtensionValue(oidExtnCerts = ObjectIdentifiers.id_xipki_ext_crlCertset.getId());
        if (extnValue == null) {
            throw new IllegalCmdParamException("no certificate is contained in " + this.crlFile);
        }
        ASN1Set asn1Set = DERSet.getInstance((Object)(extnValue = ExtractCertFromCrlCmd.removingTagAndLenFromExtensionValue(extnValue)));
        int n = asn1Set.size();
        if (n == 0) {
            throw new CmdFailure("no certificate is contained in " + this.crlFile);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(out);
        for (int i = 0; i < n; ++i) {
            Certificate cert;
            ASN1Encodable asn1 = asn1Set.getObjectAt(i);
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)asn1);
                cert = Certificate.getInstance((Object)seq.getObjectAt(0));
            }
            catch (IllegalArgumentException ex) {
                cert = Certificate.getInstance((Object)asn1);
            }
            byte[] certBytes = cert.getEncoded();
            String sha1FpCert = HashAlgoType.SHA1.hexHash(certBytes);
            ZipEntry certZipEntry = new ZipEntry(sha1FpCert + ".der");
            zip.putNextEntry(certZipEntry);
            try {
                zip.write(certBytes);
                continue;
            }
            finally {
                zip.closeEntry();
            }
        }
        zip.flush();
        zip.close();
        this.saveVerbose("extracted " + n + " certificates to", new File(this.outFile), out.toByteArray());
        return null;
    }

    private static byte[] removingTagAndLenFromExtensionValue(byte[] encodedExtensionValue) {
        DEROctetString derOctet = (DEROctetString)DEROctetString.getInstance((Object)encodedExtensionValue);
        return derOctet.getOctets();
    }
}

