/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.File;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.password.OBFPasswordService;
import org.xipki.security.shell.SecurityCommandSupport;

@Command(scope="xi", name="obfuscate", description="obfuscate password")
@Service
public class ObfuscateCmd
extends SecurityCommandSupport {
    @Option(name="--out", description="where to save the encrypted password")
    @Completion(value=FilePathCompleter.class)
    private String outFile;
    @Option(name="-k", description="quorum of the password parts")
    private Integer quorum = 1;

    protected Object execute0() throws Exception {
        char[] password;
        ParamUtil.requireRange((String)"k", (int)this.quorum, (int)1, (int)10);
        if (this.quorum == 1) {
            password = this.readPassword("Password");
        } else {
            char[][] parts = new char[this.quorum.intValue()][];
            for (int i = 0; i < this.quorum; ++i) {
                parts[i] = this.readPassword("Password " + (i + 1) + "/" + this.quorum);
            }
            password = StringUtil.merge((char[][])parts);
        }
        String passwordHint = OBFPasswordService.obfuscate((String)new String(password));
        if (this.outFile != null) {
            this.saveVerbose("saved the obfuscated password to file", new File(this.outFile), passwordHint.getBytes());
        } else {
            this.println("the obfuscated password is: '" + passwordHint + "'");
        }
        return null;
    }
}

