/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.File;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.password.OBFPasswordService;
import org.xipki.password.PBEPasswordService;
import org.xipki.security.shell.SecurityCommandSupport;

@Command(scope="xi", name="pbe-dec", description="decrypt password with master password")
@Service
public class PBEDecryptCmd
extends SecurityCommandSupport {
    @Option(name="--password", description="encrypted password, starts with PBE:\nexactly one of password and password-file must be specified")
    private String passwordHint;
    @Option(name="--password-file", description="file containing the encrypted password")
    @Completion(value=FilePathCompleter.class)
    private String passwordFile;
    @Option(name="--mpassword-file", description="file containing the (obfuscated) master password")
    @Completion(value=FilePathCompleter.class)
    private String masterPasswordFile;
    @Option(name="--mk", description="quorum of the master password parts")
    private Integer mquorum = 1;
    @Option(name="--out", description="where to save the password")
    @Completion(value=FilePathCompleter.class)
    private String outFile;

    protected Object execute0() throws Exception {
        char[] masterPassword;
        ParamUtil.requireRange((String)"mk", (int)this.mquorum, (int)1, (int)10);
        if (!(this.passwordHint == null ^ this.passwordFile == null)) {
            throw new IllegalCmdParamException("exactly one of password and password-file must be specified");
        }
        if (this.passwordHint == null) {
            this.passwordHint = new String(IoUtil.read((String)this.passwordFile));
        }
        if (!StringUtil.startsWithIgnoreCase((String)this.passwordHint, (String)"PBE:")) {
            throw new IllegalCmdParamException("encrypted password '" + this.passwordHint + "' does not start with PBE:");
        }
        if (this.masterPasswordFile != null) {
            String str = new String(IoUtil.read((String)this.masterPasswordFile));
            if (str.startsWith("OBF:") || str.startsWith("obf:")) {
                str = OBFPasswordService.deobfuscate((String)str);
            }
            masterPassword = str.toCharArray();
        } else if (this.mquorum == 1) {
            masterPassword = this.readPassword("Master password");
        } else {
            char[][] parts = new char[this.mquorum.intValue()][];
            for (int i = 0; i < this.mquorum; ++i) {
                parts[i] = this.readPassword("Master password (part " + (i + 1) + "/" + this.mquorum + ")");
            }
            masterPassword = StringUtil.merge((char[][])parts);
        }
        char[] password = PBEPasswordService.decryptPassword((char[])masterPassword, (String)this.passwordHint);
        if (this.outFile != null) {
            this.saveVerbose("saved the password to file", new File(this.outFile), new String(password).getBytes());
        } else {
            this.println("the password is: '" + new String(password) + "'");
        }
        return null;
    }
}

