/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.util.Date;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.xipki.common.util.DateUtil;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.console.karaf.XipkiCommandSupport;
import org.xipki.security.SecurityFactory;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;

public abstract class SecurityCommandSupport
extends XipkiCommandSupport {
    protected static final String DEFAULT_P11MODULE_NAME = "default";
    @Reference
    protected SecurityFactory securityFactory;
    @Reference(optional=true)
    protected P11CryptServiceFactory p11CryptServiceFactory;

    protected P11Slot getSlot(String moduleName, int slotIndex) throws XiSecurityException, P11TokenException, IllegalCmdParamException {
        P11Module module = this.getP11Module(moduleName);
        P11SlotIdentifier slotId = module.getSlotIdForIndex(slotIndex);
        return module.getSlot(slotId);
    }

    protected P11Module getP11Module(String moduleName) throws XiSecurityException, P11TokenException, IllegalCmdParamException {
        P11CryptService p11Service = this.p11CryptServiceFactory.getP11CryptService(moduleName);
        if (p11Service == null) {
            throw new IllegalCmdParamException("undefined module " + moduleName);
        }
        return p11Service.module();
    }

    protected String toUtcTimeyyyyMMddhhmmssZ(Date date) {
        return DateUtil.toUtcTimeyyyyMMddhhmmss((Date)date) + "Z";
    }
}

