/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.shell.SecurityCommandSupport;
import org.xipki.security.shell.completer.P11ModuleNameCompleter;

@Command(scope="xi", name="rm-cert-p11", description="remove certificate from PKCS#11 device")
@Service
public class P11CertDeleteCmd
extends SecurityCommandSupport {
    @Option(name="--slot", required=true, description="slot index\n(required)")
    private Integer slotIndex;
    @Option(name="--id", required=true, description="id of the certificate in the PKCS#11 device\n(required)")
    private String id;
    @Option(name="--module", description="name of the PKCS#11 module.")
    @Completion(value=P11ModuleNameCompleter.class)
    private String moduleName = "default";

    protected Object execute0() throws Exception {
        P11Slot slot = this.getSlot(this.moduleName, this.slotIndex);
        P11ObjectIdentifier objectId = slot.getObjectIdForId(Hex.decode((String)this.id));
        slot.removeCerts(objectId);
        this.println("deleted certificates");
        return null;
    }
}

