/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import java.io.File;
import java.security.cert.X509Certificate;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.CmdFailure;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.shell.p11.P11SecurityCommandSupport;

@Command(scope="xi", name="export-cert-p11", description="export certificate from PKCS#11 device")
@Service
public class P11CertExportCmd
extends P11SecurityCommandSupport {
    @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String outFile;

    protected Object execute0() throws Exception {
        P11ObjectIdentifier objIdentifier;
        P11Slot slot = this.getSlot();
        X509Certificate cert = slot.exportCert(objIdentifier = this.getObjectIdentifier());
        if (cert == null) {
            throw new CmdFailure("could not export certificate " + objIdentifier);
        }
        this.saveVerbose("saved certificate to file", new File(this.outFile), cert.getEncoded());
        return null;
    }
}

