/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import java.security.cert.X509Certificate;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.shell.p11.P11SecurityCommandSupport;
import org.xipki.security.util.X509Util;

@Command(scope="xi", name="update-cert-p11", description="update certificate in PKCS#11 device")
@Service
public class P11CertUpdateCmd
extends P11SecurityCommandSupport {
    @Option(name="--cert", required=true, description="certificate file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String certFile;

    protected Object execute0() throws Exception {
        P11Slot slot = this.getSlot();
        P11ObjectIdentifier objIdentifier = this.getObjectIdentifier();
        X509Certificate newCert = X509Util.parseCert((String)this.certFile);
        slot.updateCertificate(objIdentifier, newCert);
        this.println("updated certificate");
        return null;
    }
}

