/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.xipki.common.util.ParamUtil;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11NewKeyControl;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.shell.KeyGenCommandSupport;
import org.xipki.security.shell.completer.P11ModuleNameCompleter;

public abstract class P11KeyGenCommandSupport
extends KeyGenCommandSupport {
    @Option(name="--label", required=true, description="label of the PKCS#11 objects\n(required)")
    protected String label;
    @Option(name="--extractable", aliases={"-x"}, description="whether the key is extractable")
    private Boolean extractable;
    @Option(name="--slot", required=true, description="slot index\n(required)")
    private Integer slotIndex;
    @Option(name="--module", description="Name of the PKCS#11 module.")
    @Completion(value=P11ModuleNameCompleter.class)
    private String moduleName = "default";

    protected abstract boolean getDefaultExtractable();

    protected void finalize(String keyType, P11ObjectIdentifier objectId) throws Exception {
        ParamUtil.requireNonNull((String)"objectId", (Object)objectId);
        this.println("generated " + keyType + " key " + objectId);
    }

    protected P11Slot getSlot() throws XiSecurityException, P11TokenException, IllegalCmdParamException {
        return this.getSlot(this.moduleName, this.slotIndex);
    }

    protected P11NewKeyControl getControl() {
        P11NewKeyControl control = new P11NewKeyControl();
        control.setExtractable(this.extractable == null ? this.getDefaultExtractable() : this.extractable.booleanValue());
        return control;
    }
}

