/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p11;

import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xipki.console.karaf.completer.HashAlgCompleter;
import org.xipki.security.HashAlgoType;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.shell.p11.P11SecurityCommandSupport;
import org.xipki.security.util.AlgorithmUtil;

@Command(scope="xi", name="p11provider-test", description="test the Xipki PKCS#11 JCA/JCE provider")
@Service
public class P11ProviderTestCmd
extends P11SecurityCommandSupport {
    @Option(name="--verbose", aliases={"-v"}, description="show object information verbosely")
    private Boolean verbose = Boolean.FALSE;
    @Option(name="--hash", description="hash algorithm name")
    @Completion(value=HashAlgCompleter.class)
    protected String hashAlgo = "SHA256";
    @Option(name="--rsa-mgf1", description="whether to use the RSAPSS MGF1 for the POPO computation\n(only applied to RSA key)")
    private Boolean rsaMgf1 = Boolean.FALSE;
    @Option(name="--dsa-plain", description="whether to use the Plain DSA for the POPO computation\n(only applied to ECDSA key)")
    private Boolean dsaPlain = Boolean.FALSE;

    protected Object execute0() throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS11", "XiPKI");
        ks.load(null, null);
        if (this.verbose.booleanValue()) {
            this.println("available aliases:");
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias2 = aliases.nextElement();
                this.println("    " + alias2);
            }
        }
        String alias = this.getAlias();
        this.println("alias: " + alias);
        PrivateKey key = (PrivateKey)ks.getKey(alias, null);
        if (key == null) {
            this.println("could not find key with alias '" + alias + "'");
            return null;
        }
        Certificate cert = ks.getCertificate(alias);
        if (cert == null) {
            this.println("could not find certificate to verify signature");
            return null;
        }
        PublicKey pubKey = cert.getPublicKey();
        String sigAlgo = this.getSignatureAlgo(pubKey);
        this.println("signature algorithm: " + sigAlgo);
        Signature sig = Signature.getInstance(sigAlgo, "XiPKI");
        sig.initSign(key);
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        sig.update(data);
        byte[] signature = sig.sign();
        this.println("signature created successfully");
        Signature ver = Signature.getInstance(sigAlgo, "BC");
        ver.initVerify(pubKey);
        ver.update(data);
        boolean valid = ver.verify(signature);
        this.println("signature valid: " + valid);
        return null;
    }

    private String getAlias() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.moduleName).append("#slotindex-").append(this.slotIndex);
        if (this.label != null) {
            sb.append("#keylabel-").append(this.label);
        } else {
            sb.append("#keyid-").append(this.id.toUpperCase());
        }
        return sb.toString();
    }

    private String getSignatureAlgo(PublicKey pubKey) throws NoSuchAlgorithmException {
        SignatureAlgoControl algoControl = new SignatureAlgoControl(this.rsaMgf1.booleanValue(), this.dsaPlain.booleanValue());
        AlgorithmIdentifier sigAlgId = AlgorithmUtil.getSigAlgId((PublicKey)pubKey, (HashAlgoType)HashAlgoType.getNonNullHashAlgoType((String)this.hashAlgo), (SignatureAlgoControl)algoControl);
        return AlgorithmUtil.getSignatureAlgoName((AlgorithmIdentifier)sigAlgId);
    }
}

