/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p12;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.security.pkcs12.P12KeyGenerationResult;
import org.xipki.security.pkcs12.P12KeyGenerator;
import org.xipki.security.shell.completer.SecretKeyTypeCompleter;
import org.xipki.security.shell.p12.P12KeyGenCommandSupport;

@Command(scope="xi", name="secretkey-p12", description="generate secret key in JCEKS (not PKCS#12) keystore")
@Service
public class JceksSecretKeyGenCmd
extends P12KeyGenCommandSupport {
    @Option(name="--key-type", required=true, description="keytype, current only AES, DES3 and GENERIC are supported\n(required)")
    @Completion(value=SecretKeyTypeCompleter.class)
    private String keyType;
    @Option(name="--key-size", required=true, description="keysize in bit.")
    private Integer keysize;

    protected Object execute0() throws Exception {
        if (!("AES".equalsIgnoreCase(this.keyType) || "DES3".equalsIgnoreCase(this.keyType) || "GENERIC".equalsIgnoreCase(this.keyType))) {
            throw new IllegalCmdParamException("invalid keyType " + this.keyType);
        }
        P12KeyGenerationResult key = new P12KeyGenerator().generateSecretKey(this.keyType.toUpperCase(), this.keysize.intValue(), this.getKeyGenParameters());
        this.saveKey(key);
        return null;
    }
}

