/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p12;

import java.io.File;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.CmdFailure;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.shell.p12.P12SecurityCommandSupport;

@Command(scope="xi", name="export-cert-p12", description="export certificate from PKCS#12 keystore")
@Service
public class P12CertExportCmd
extends P12SecurityCommandSupport {
    @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String outFile;

    protected Object execute0() throws Exception {
        KeyStore ks = this.getKeyStore();
        String keyname = null;
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            keyname = alias;
            break;
        }
        if (keyname == null) {
            throw new CmdFailure("could not find private key");
        }
        X509Certificate cert = (X509Certificate)ks.getCertificate(keyname);
        this.saveVerbose("saved certificate to file", new File(this.outFile), cert.getEncoded());
        return null;
    }
}

