/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p12;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.ObjectCreationException;
import org.xipki.common.util.ParamUtil;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgoType;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;
import org.xipki.security.shell.CertRequestGenCommandSupport;
import org.xipki.security.util.KeyUtil;

@Command(scope="xi", name="req-p12", description="generate CSR with PKCS#12 keystore")
@Service
public class P12CertRequestGenCmd
extends CertRequestGenCommandSupport {
    @Option(name="--p12", required=true, description="PKCS#12 keystore file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String p12File;
    @Option(name="--password", description="password of the PKCS#12 file")
    private String password;

    private char[] getPassword() throws IOException {
        char[] pwdInChar = this.readPasswordIfNotSet(this.password);
        if (pwdInChar != null) {
            this.password = new String(pwdInChar);
        }
        return pwdInChar;
    }

    public KeyStore getKeyStore() throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks;
        try (FileInputStream in = new FileInputStream(P12CertRequestGenCmd.expandFilepath((String)this.p12File));){
            ks = KeyUtil.getKeyStore((String)"PKCS12");
            ks.load(in, this.getPassword());
        }
        return ks;
    }

    @Override
    protected ConcurrentContentSigner getSigner(SignatureAlgoControl signatureAlgoControl) throws ObjectCreationException {
        char[] pwd;
        ParamUtil.requireNonNull((String)"signatureAlgoControl", (Object)signatureAlgoControl);
        try {
            pwd = this.getPassword();
        }
        catch (IOException ex) {
            throw new ObjectCreationException("could not read password: " + ex.getMessage(), (Throwable)ex);
        }
        SignerConf conf = SignerConf.getKeystoreSignerConf((String)this.p12File, (String)new String(pwd), (int)1, (HashAlgoType)HashAlgoType.getNonNullHashAlgoType((String)this.hashAlgo), (SignatureAlgoControl)signatureAlgoControl);
        return this.securityFactory.createSigner("PKCS12", conf, (X509Certificate[])null);
    }
}

