/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p12;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.isismtt.x509.AdmissionSyntax;
import org.bouncycastle.asn1.isismtt.x509.Admissions;
import org.bouncycastle.asn1.isismtt.x509.ProfessionInfo;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.xipki.common.ObjectCreationException;
import org.xipki.common.util.ParamUtil;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgoType;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;
import org.xipki.security.exception.BadInputException;
import org.xipki.security.shell.CertRequestGenCommandSupport;
import org.xipki.security.util.KeyUtil;

@Command(scope="xi", name="req-p12-complex", description="generate complex CSR with PKCS#12 keystore (only for test)")
@Service
public class P12ComplexCertRequestGenCmd
extends CertRequestGenCommandSupport {
    @Option(name="--p12", required=true, description="PKCS#12 keystore file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String p12File;
    @Option(name="--password", description="password of the PKCS#12 file")
    private String password;
    @Option(name="--complex-subject", description="whether complex subject should be used")
    private Boolean complexSubject = Boolean.FALSE;

    private char[] getPassword() throws IOException {
        char[] pwdInChar = this.readPasswordIfNotSet(this.password);
        if (pwdInChar != null) {
            this.password = new String(pwdInChar);
        }
        return pwdInChar;
    }

    public KeyStore getKeyStore() throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks;
        try (FileInputStream in = new FileInputStream(P12ComplexCertRequestGenCmd.expandFilepath((String)this.p12File));){
            ks = KeyUtil.getKeyStore((String)"PKCS12");
            ks.load(in, this.getPassword());
        }
        return ks;
    }

    @Override
    protected ConcurrentContentSigner getSigner(SignatureAlgoControl signatureAlgoControl) throws ObjectCreationException {
        char[] pwd;
        ParamUtil.requireNonNull((String)"signatureAlgoControl", (Object)signatureAlgoControl);
        try {
            pwd = this.getPassword();
        }
        catch (IOException ex) {
            throw new ObjectCreationException("could not read password: " + ex.getMessage(), (Throwable)ex);
        }
        SignerConf signerConf = SignerConf.getKeystoreSignerConf((String)this.p12File, (String)new String(pwd), (int)1, (HashAlgoType)HashAlgoType.getNonNullHashAlgoType((String)this.hashAlgo), (SignatureAlgoControl)signatureAlgoControl);
        return this.securityFactory.createSigner("PKCS12", signerConf, (X509Certificate[])null);
    }

    @Override
    protected X500Name getSubject(String subject) {
        RDN rdn;
        ASN1ObjectIdentifier id;
        RDN[] rdns;
        RDN[] rs;
        X500Name name = new X500Name(subject);
        LinkedList<RDN> list = new LinkedList<RDN>();
        for (RDN m : rs = name.getRDNs()) {
            list.add(m);
        }
        if (this.complexSubject.booleanValue() && ((rdns = name.getRDNs(id = ObjectIdentifiers.DN_DATE_OF_BIRTH)) == null || rdns.length == 0)) {
            DERGeneralizedTime atvValue = new DERGeneralizedTime("19950102120000Z");
            rdn = new RDN(id, (ASN1Encodable)atvValue);
            list.add(rdn);
        }
        if (this.complexSubject.booleanValue() && ((rdns = name.getRDNs(id = ObjectIdentifiers.DN_POSTAL_ADDRESS)) == null || rdns.length == 0)) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new DERUTF8String("my street 1"));
            vec.add((ASN1Encodable)new DERUTF8String("12345 Germany"));
            DERSequence atvValue = new DERSequence(vec);
            RDN rdn2 = new RDN(id, (ASN1Encodable)atvValue);
            list.add(rdn2);
        }
        if ((rdns = name.getRDNs(id = ObjectIdentifiers.DN_UNIQUE_IDENTIFIER)) == null || rdns.length == 0) {
            DERUTF8String atvValue = new DERUTF8String("abc-def-ghi");
            rdn = new RDN(id, (ASN1Encodable)atvValue);
            list.add(rdn);
        }
        return new X500Name(list.toArray(new RDN[0]));
    }

    @Override
    protected ASN1OctetString createExtnValueSubjectAltName() throws BadInputException {
        if (!P12ComplexCertRequestGenCmd.isEmpty((Collection)this.subjectAltNames)) {
            throw new BadInputException("subjectAltNames must be null");
        }
        GeneralNames names = P12ComplexCertRequestGenCmd.createComplexGeneralNames("SAN-");
        try {
            return new DEROctetString((ASN1Encodable)names);
        }
        catch (IOException ex) {
            throw new BadInputException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    protected ASN1OctetString createExtnValueSubjectInfoAccess() throws BadInputException {
        if (!P12ComplexCertRequestGenCmd.isEmpty((Collection)this.subjectInfoAccesses)) {
            throw new BadInputException("subjectInfoAccess must be null");
        }
        ASN1EncodableVector vec = new ASN1EncodableVector();
        GeneralName[] names = P12ComplexCertRequestGenCmd.createComplexGeneralNames("SIA-").getNames();
        ASN1EncodableVector vec2 = new ASN1EncodableVector();
        vec2.add((ASN1Encodable)ObjectIdentifiers.id_ad_caRepository);
        vec2.add((ASN1Encodable)names[0]);
        vec.add((ASN1Encodable)new DERSequence(vec2));
        for (int i = 1; i < names.length; ++i) {
            vec2 = new ASN1EncodableVector();
            vec2.add((ASN1Encodable)new ASN1ObjectIdentifier("2.3.4." + i));
            vec2.add((ASN1Encodable)names[i]);
            vec.add((ASN1Encodable)new DERSequence(vec2));
        }
        try {
            return new DEROctetString((ASN1Encodable)new DERSequence(vec));
        }
        catch (IOException ex) {
            throw new BadInputException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static GeneralNames createComplexGeneralNames(String prefix) {
        LinkedList<GeneralName> list = new LinkedList<GeneralName>();
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.3.1"));
        vec.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(prefix + "I am otherName 1.2.3.1")));
        list.add(new GeneralName(0, (ASN1Encodable)new DERSequence(vec)));
        vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.3.2"));
        vec.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(prefix + "I am otherName 1.2.3.2")));
        list.add(new GeneralName(0, (ASN1Encodable)new DERSequence(vec)));
        list.add(new GeneralName(1, prefix + "info@example.org"));
        list.add(new GeneralName(2, prefix + "dns.example.org"));
        list.add(new GeneralName(4, (ASN1Encodable)new X500Name("CN=demo,C=DE")));
        vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DirectoryString(prefix + "assigner1")));
        vec.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DirectoryString(prefix + "party1")));
        list.add(new GeneralName(5, (ASN1Encodable)new DERSequence(vec)));
        list.add(new GeneralName(6, prefix + "uri.example.org"));
        list.add(new GeneralName(7, "69.1.2.190"));
        list.add(new GeneralName(8, "2.3.4.5"));
        return new GeneralNames(list.toArray(new GeneralName[0]));
    }

    @Override
    protected List<Extension> getAdditionalExtensions() throws BadInputException {
        String[] countryOfResidenceList;
        String[] countryOfCitizenshipList;
        LinkedList<Extension> extensions = new LinkedList<Extension>();
        ASN1EncodableVector vec = new ASN1EncodableVector();
        DirectoryString[] dummyItems = new DirectoryString[]{new DirectoryString("dummy")};
        ProfessionInfo pi = new ProfessionInfo(null, dummyItems, null, "aaaab", null);
        Admissions admissions = new Admissions(null, null, new ProfessionInfo[]{pi});
        vec.add((ASN1Encodable)admissions);
        AdmissionSyntax adSyn = new AdmissionSyntax(null, (ASN1Sequence)new DERSequence(vec));
        try {
            extensions.add(new Extension(ObjectIdentifiers.id_extension_admission, false, adSyn.getEncoded()));
        }
        catch (IOException ex) {
            throw new BadInputException(ex.getMessage(), (Throwable)ex);
        }
        Vector<Attribute> attrs = new Vector<Attribute>();
        ASN1GeneralizedTime dateOfBirth = new ASN1GeneralizedTime("19800122120000Z");
        attrs.add(new Attribute(ObjectIdentifiers.DN_DATE_OF_BIRTH, (ASN1Set)new DERSet((ASN1Encodable)dateOfBirth)));
        DERPrintableString gender = new DERPrintableString("M");
        attrs.add(new Attribute(ObjectIdentifiers.DN_GENDER, (ASN1Set)new DERSet((ASN1Encodable)gender)));
        DERUTF8String placeOfBirth = new DERUTF8String("Berlin");
        attrs.add(new Attribute(ObjectIdentifiers.DN_PLACE_OF_BIRTH, (ASN1Set)new DERSet((ASN1Encodable)placeOfBirth)));
        for (String country : countryOfCitizenshipList = new String[]{"DE", "FR"}) {
            DERPrintableString val = new DERPrintableString(country);
            attrs.add(new Attribute(ObjectIdentifiers.DN_COUNTRY_OF_CITIZENSHIP, (ASN1Set)new DERSet((ASN1Encodable)val)));
        }
        for (String country : countryOfResidenceList = new String[]{"DE"}) {
            DERPrintableString val = new DERPrintableString(country);
            attrs.add(new Attribute(ObjectIdentifiers.DN_COUNTRY_OF_RESIDENCE, (ASN1Set)new DERSet((ASN1Encodable)val)));
        }
        SubjectDirectoryAttributes subjectDirAttrs = new SubjectDirectoryAttributes(attrs);
        try {
            extensions.add(new Extension(Extension.subjectDirectoryAttributes, false, subjectDirAttrs.getEncoded()));
        }
        catch (IOException ex) {
            throw new BadInputException(ex.getMessage(), (Throwable)ex);
        }
        return extensions;
    }
}

